/*
 * Decompiled with CFR 0.152.
 */
package com.sas.contentserver.springextensions.jcr;

import com.sas.contentserver.springextensions.jcr.JcrAccessor;
import com.sas.contentserver.springextensions.jcr.SessionFactoryUtils;
import javax.jcr.Session;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class JcrInterceptor
extends JcrAccessor
implements MethodInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(JcrInterceptor.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
        boolean existingTransaction = false;
        Session session = SessionFactoryUtils.getSession(this.getSessionFactory(), true);
        if (TransactionSynchronizationManager.hasResource((Object)this.getSessionFactory())) {
            LOG.debug("Found thread-bound Session for JCR interceptor");
            existingTransaction = true;
        } else {
            LOG.debug("Using new Session for JCR interceptor");
        }
        try {
            Object retVal;
            Object object = retVal = methodInvocation.proceed();
            return object;
        }
        finally {
            if (existingTransaction) {
                LOG.debug("Not closing pre-bound JCR Session after interceptor");
            } else {
                TransactionSynchronizationManager.unbindResource((Object)this.getSessionFactory());
                SessionFactoryUtils.releaseSession(session, this.getSessionFactory());
            }
        }
    }
}

