/*
 * Decompiled with CFR 0.152.
 */
package com.sas.contentserver.springextensions.jcr;

import com.sas.contentserver.springextensions.jcr.SessionFactory;
import com.sas.contentserver.springextensions.jcr.SessionFactoryUtils;
import java.io.IOException;
import javax.jcr.RepositoryException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.DataAccessException;

public abstract class JcrAccessor
implements InitializingBean {
    private SessionFactory sessionFactory;

    public void afterPropertiesSet() {
        if (this.getSessionFactory() == null) {
            throw new IllegalArgumentException("sessionFactory is required");
        }
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public DataAccessException convertJcrAccessException(RepositoryException ex) {
        return SessionFactoryUtils.translateException(ex);
    }

    public DataAccessException convertJcrAccessException(IOException ex) {
        return SessionFactoryUtils.translateException(ex);
    }

    public RuntimeException convertJcrAccessException(RuntimeException ex) {
        return ex;
    }
}

