/*
 * Decompiled with CFR 0.152.
 */
package com.sas.contentserver.security;

import com.sas.contentserver.core.TenantRepositoryImpl;
import com.sas.contentserver.security.SASDefaultSecurityManager;
import com.sas.framework.commons.holders.TenantHolder;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.Credentials;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.security.auth.Subject;
import org.apache.jackrabbit.api.security.principal.PrincipalManager;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.jackrabbit.core.RepositoryImpl;
import org.apache.jackrabbit.core.security.AMContext;
import org.apache.jackrabbit.core.security.AccessManager;
import org.apache.jackrabbit.core.security.JackrabbitSecurityManager;
import org.apache.jackrabbit.core.security.authentication.AuthContext;
import org.apache.jackrabbit.core.security.principal.PrincipalProvider;
import org.apache.jackrabbit.core.security.principal.PrincipalProviderRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TenantSecurityManager
implements JackrabbitSecurityManager {
    private static Logger log = LoggerFactory.getLogger(TenantSecurityManager.class);
    private final Map<Integer, SASDefaultSecurityManager> initializedSecurityManagers = new HashMap<Integer, SASDefaultSecurityManager>();
    private Repository repo;

    public synchronized void init(Repository repository, Session systemSession) throws RepositoryException {
        this.repo = repository;
        this.getTenantSecurityManager();
    }

    public void close() {
        SASDefaultSecurityManager secMan = this.getTenantSecurityManager();
        secMan.close();
    }

    public void dispose(String workspaceName) {
        SASDefaultSecurityManager secMan = this.getTenantSecurityManager();
        secMan.dispose(workspaceName);
    }

    public AccessManager getAccessManager(Session session, AMContext amContext) throws RepositoryException {
        SASDefaultSecurityManager secMan = this.getTenantSecurityManager();
        return secMan.getAccessManager(session, amContext);
    }

    public AuthContext getAuthContext(Credentials creds, Subject subject, String workspaceName) throws RepositoryException {
        SASDefaultSecurityManager secMan = this.getTenantSecurityManager();
        return secMan.getAuthContext(creds, subject, workspaceName);
    }

    public PrincipalManager getPrincipalManager(Session session) throws RepositoryException {
        SASDefaultSecurityManager secMan = this.getTenantSecurityManager();
        return secMan.getPrincipalManager(session);
    }

    public String getUserID(Subject subject, String workspaceName) throws RepositoryException {
        SASDefaultSecurityManager secMan = this.getTenantSecurityManager();
        return secMan.getUserID(subject, workspaceName);
    }

    public UserManager getUserManager(Session session) throws RepositoryException {
        SASDefaultSecurityManager secMan = this.getTenantSecurityManager();
        return secMan.getUserManager(session);
    }

    public PrincipalProviderRegistry getPrincipalProviderRegistry() {
        SASDefaultSecurityManager secMan = this.getTenantSecurityManager();
        return secMan.getPrincipalProviderRegistry();
    }

    public PrincipalProvider createUserPrincipalProvider(Session systemSession) throws RepositoryException {
        return this.getTenantSecurityManager().createUserPrincipalProvider(systemSession);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SASDefaultSecurityManager getTenantSecurityManager() {
        Map<Integer, SASDefaultSecurityManager> map = this.initializedSecurityManagers;
        synchronized (map) {
            SASDefaultSecurityManager secMan = this.initializedSecurityManagers.get(TenantHolder.get().getId());
            if (secMan == null) {
                secMan = new SASDefaultSecurityManager();
                try {
                    if (log.isDebugEnabled()) {
                        log.debug("Creating new security manager for tenant id = " + TenantHolder.get().getId());
                    }
                    secMan.init(this.repo, (Session)((TenantRepositoryImpl)this.repo).getSystemSession(((RepositoryImpl)this.repo).getConfig().getDefaultWorkspaceName()));
                }
                catch (RepositoryException e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
                this.initializedSecurityManagers.put(TenantHolder.get().getId(), secMan);
            }
            return secMan;
        }
    }
}

