/*
 * Decompiled with CFR 0.152.
 */
package com.sas.contentserver.security;

import com.sas.contentserver.security.SASCredentials;
import java.io.IOException;
import java.util.Arrays;
import javax.jcr.Credentials;
import javax.jcr.GuestCredentials;
import javax.jcr.LoginException;
import javax.jcr.SimpleCredentials;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.codec.binary.Base64;
import org.apache.jackrabbit.server.BasicCredentialsProvider;

public class SASCredentialsProvider
extends BasicCredentialsProvider {
    private final String defaultHeaderValue;

    public SASCredentialsProvider(String defaultHeaderValue) {
        super(defaultHeaderValue);
        this.defaultHeaderValue = defaultHeaderValue;
    }

    public Credentials getCredentials(HttpServletRequest request) throws LoginException, ServletException {
        try {
            String authHeader = request.getHeader("Authorization");
            if (authHeader != null) {
                String[] authStr = authHeader.split(" ");
                if (authStr.length >= 2 && authStr[0].equalsIgnoreCase("BASIC")) {
                    byte[] decodedBytes = Base64.decodeBase64((byte[])authStr[1].getBytes(request.getCharacterEncoding()));
                    String decAuthStr = new String(decodedBytes, request.getCharacterEncoding());
                    int pos = decAuthStr.indexOf(58);
                    String userid = decAuthStr.substring(0, pos);
                    char[] passwd = decAuthStr.substring(pos + 1).toCharArray();
                    int tenant = -1;
                    SimpleCredentials sc = new SimpleCredentials(userid, passwd);
                    Arrays.fill(passwd, '0');
                    return new SASCredentials(sc, tenant);
                }
                throw new ServletException("Unable to decode authorization.");
            }
            if (this.defaultHeaderValue == null) {
                throw new LoginException();
            }
            if ("".equals(this.defaultHeaderValue)) {
                return null;
            }
            if ("guestcredentials".equals(this.defaultHeaderValue)) {
                return new GuestCredentials();
            }
            int pos = this.defaultHeaderValue.indexOf(58);
            if (pos < 0) {
                return new SimpleCredentials(this.defaultHeaderValue, new char[0]);
            }
            return new SimpleCredentials(this.defaultHeaderValue.substring(0, pos), this.defaultHeaderValue.substring(pos + 1).toCharArray());
        }
        catch (IOException e) {
            throw new ServletException("Unable to decode authorization: " + e.toString());
        }
    }
}

