/*
 * Decompiled with CFR 0.152.
 */
package com.sas.contentserver.jcrtree;

import com.sas.contentserver.jcrtree.JCRTree;
import java.util.TreeMap;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.swing.tree.DefaultMutableTreeNode;

public class JCRTreeNode
extends DefaultMutableTreeNode {
    private static final long serialVersionUID = 8775335016831163858L;
    protected String resName;
    protected transient TreeMap<String, String> DAVprops;
    protected boolean isCollection;
    protected boolean isCheckedOut;
    protected boolean isLocked;
    protected String name;
    protected String newName;
    protected String fullName;
    protected boolean populated;
    protected boolean interim;
    protected Node JCRNode;

    public JCRTreeNode(Node n) {
        super(n);
        this.JCRNode = n;
        try {
            this.isCollection = n.hasNodes();
        }
        catch (RepositoryException e) {
            this.isCollection = false;
        }
        try {
            String relpath;
            this.fullName = n.getPath();
            String _url = this.fullName.trim();
            int ptr = _url.lastIndexOf(47);
            if (_url.charAt(_url.length() - 1) != '/') {
                if (this.isCollection) {
                    _url = _url + "/";
                }
            } else {
                ptr = _url.lastIndexOf(47, ptr - 1);
            }
            if ((relpath = _url.substring(ptr + 1)).length() == 0) {
                relpath = _url;
            }
            this.resName = relpath;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean isLeaf() {
        return !this.isCollection;
    }

    @Override
    public boolean getAllowsChildren() {
        return this.isCollection;
    }

    @Override
    public String toString() {
        return this.resName;
    }

    public void setNewName(String name) {
        this.newName = name;
        if (!this.isCollection && this.newName.endsWith("/")) {
            this.newName = this.newName.substring(0, this.newName.length() - 1);
        }
    }

    public boolean populateCollections(JCRTree tree, boolean descend) throws RepositoryException {
        boolean addedNodes = false;
        if (!this.populated) {
            if (this.interim) {
                this.removeAllChildren();
                this.interim = false;
            }
            if (!this.JCRNode.hasNodes()) {
                return addedNodes;
            }
            try {
                TreeMap<String, Node> map = new TreeMap<String, Node>();
                NodeIterator _children = this.JCRNode.getNodes();
                while (_children.hasNext()) {
                    Node child = _children.nextNode();
                    map.put(child.getPath(), child);
                }
                for (Node child : map.values()) {
                    JCRTreeNode node = new JCRTreeNode(child);
                    this.add(node);
                    addedNodes = true;
                    if (descend) continue;
                    break;
                }
            }
            catch (RepositoryException e) {
                e.printStackTrace();
            }
            if (descend || !addedNodes) {
                this.populated = true;
            } else {
                this.interim = true;
            }
        }
        return addedNodes;
    }
}

