/*
 * Decompiled with CFR 0.152.
 */
package com.sas.contentserver.j2ee.controller;

import com.sas.contentserver.commons.SpecialNameChars;
import com.sas.contentserver.j2ee.controller.NodeDTO;
import com.sas.contentserver.j2ee.controller.PrincipalDTO;
import com.sas.contentserver.security.SASDefaultAccessManager;
import com.sas.contentserver.springextensions.jcr.JcrCallback;
import com.sas.contentserver.springextensions.jcr.JcrTemplate;
import java.io.IOException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jcr.AccessDeniedException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.security.AccessControlEntry;
import javax.jcr.security.AccessControlList;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.AccessControlPolicy;
import javax.jcr.security.Privilege;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlEntry;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlList;
import org.apache.jackrabbit.api.security.principal.PrincipalIterator;
import org.apache.jackrabbit.api.security.principal.PrincipalManager;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.security.UserPrincipal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class ListUsersController {
    private final String YES_CHANGED = "YesChanged";
    private final String YES_UNCHANGED = "YesUnchanged";
    private final String NO_CHANGED = "NoChanged";
    private static Logger log = LoggerFactory.getLogger(ListUsersController.class);
    @Autowired
    private JcrTemplate jcrTemplate;

    @RequestMapping(value={"/listusers.htm"})
    public ModelAndView handleListUsers(@RequestParam(value="path") String path, Model model) throws ServletException, IOException {
        ModelMap myModel = new ModelMap();
        myModel.put((Object)"now", (Object)new Date());
        myModel.put((Object)"path", (Object)path);
        final ArrayList principals = new ArrayList();
        this.jcrTemplate.execute(new JcrCallback<Object>(){

            @Override
            public Object doInJcr(Session session) throws IOException, RepositoryException {
                Principal p;
                PrincipalManager pm = ((JackrabbitSession)session).getPrincipalManager();
                PrincipalIterator pIter = pm.getPrincipals(2);
                while (pIter.hasNext()) {
                    p = pIter.nextPrincipal();
                    principals.add(new PrincipalDTO(p.getName(), p.getName(), "group"));
                }
                pIter = pm.getPrincipals(1);
                while (pIter.hasNext()) {
                    p = pIter.nextPrincipal();
                    principals.add(new PrincipalDTO(p.getName(), p.getName(), "user"));
                }
                return null;
            }
        });
        Collections.sort(principals);
        myModel.addAttribute("principals", principals);
        return new ModelAndView("listusers", "model", (Object)myModel);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/dirperms.htm"})
    public ModelAndView handleGetDirPerms(final @RequestParam(value="path") String path, Model model) throws ServletException, IOException {
        final ModelMap myModel = new ModelMap();
        this.jcrTemplate.execute(new JcrCallback<Void>(){

            @Override
            public Void doInJcr(Session session) throws IOException, RepositoryException {
                ListUsersController.this.populateModelWithAceInfo(session, path, myModel);
                return null;
            }
        });
        return new ModelAndView("dirperms", "model", (Object)myModel);
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/dirperms.htm"})
    public ModelAndView handlePostDirPerms(final HttpServletRequest request, final @RequestParam(value="path") String path, @RequestParam(value="changeOwner") String changeOwner, Model model) throws ServletException, IOException {
        final ModelMap myModel = new ModelMap();
        try {
            final ArrayList<PrincipalDTO> changedPrincipals = new ArrayList<PrincipalDTO>();
            Enumeration parms = request.getParameterNames();
            while (parms.hasMoreElements()) {
                PrincipalDTO p1;
                int p;
                String parmName = (String)parms.nextElement();
                String parmValue = request.getParameter(parmName);
                if (parmName.endsWith("_RMV") && "T".equals(parmValue)) {
                    if (changedPrincipals.contains(parmName = parmName.substring(0, parmName.length() - 4))) continue;
                    changedPrincipals.add(new PrincipalDTO(parmName, "id", "location"));
                    continue;
                }
                if (!this.isChanged(parmValue) || (p = parmName.lastIndexOf(95)) <= 0 || changedPrincipals.contains(p1 = new PrincipalDTO(parmName = parmName.substring(0, p), "id", "location"))) continue;
                changedPrincipals.add(p1);
            }
            if (changeOwner != null && changeOwner.equals("true")) {
                final String newOwner = request.getParameter("foundprn");
                if (newOwner != null && !newOwner.equals("")) {
                    this.jcrTemplate.execute(new JcrCallback<Node>(){

                        @Override
                        public Node doInJcr(Session session) throws IOException, RepositoryException {
                            Node node = session.getNode(SpecialNameChars.encode(path));
                            if (!node.isNodeType("owner")) {
                                node.addMixin("owner");
                            }
                            node.setProperty("jcr:owner", newOwner);
                            session.save();
                            return null;
                        }
                    });
                }
            } else {
                this.jcrTemplate.execute(new JcrCallback<Node>(){

                    @Override
                    public Node doInJcr(Session session) throws IOException, RepositoryException {
                        Node node = (Node)session.getItem(SpecialNameChars.encode(path));
                        for (PrincipalDTO p : changedPrincipals) {
                            ListUsersController.this.readAndSetPermissions(request, SpecialNameChars.encode(node.getPath()), p);
                        }
                        return null;
                    }
                });
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        this.jcrTemplate.execute(new JcrCallback<Void>(){

            @Override
            public Void doInJcr(Session session) throws IOException, RepositoryException {
                ListUsersController.this.populateModelWithAceInfo(session, path, myModel);
                return null;
            }
        });
        return new ModelAndView("dirperms", "model", (Object)myModel);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/dircontents.htm"})
    public ModelAndView handleGetDirContents(final @RequestParam(value="path") String path, Model model) throws ServletException, IOException {
        ModelMap myModel = new ModelMap();
        final ArrayList nodes = new ArrayList();
        this.jcrTemplate.execute(new JcrCallback<Void>(){

            @Override
            public Void doInJcr(Session session) throws IOException, RepositoryException {
                Node parent = (Node)session.getItem(SpecialNameChars.encode(path));
                if (parent.hasNodes()) {
                    NodeIterator nIter = parent.getNodes();
                    while (nIter.hasNext()) {
                        String created = "none";
                        String modified = "none";
                        Node node = nIter.nextNode();
                        if (!node.isNodeType("nt:file") && !node.isNodeType("nt:davcollection")) continue;
                        if (node.hasProperty("jcr:created")) {
                            created = node.getProperty("jcr:created").getString();
                        }
                        Node contentNode = node;
                        if (node.isNodeType("nt:file")) {
                            contentNode = node.getNode("jcr:content");
                        }
                        if (contentNode.hasProperty("jcr:lastModified")) {
                            modified = contentNode.getProperty("jcr:lastModified").getString();
                        }
                        nodes.add(new NodeDTO(SpecialNameChars.decode(node.getName()), SpecialNameChars.decode(node.getPath()), node.getPrimaryNodeType().getName(), created, modified));
                    }
                }
                return null;
            }
        });
        Collections.sort(nodes);
        myModel.addAttribute("nodes", nodes);
        myModel.addAttribute("path", (Object)path);
        return new ModelAndView("dircontents", "model", (Object)myModel);
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/dircontents.htm"})
    public ModelAndView handlePostDirContents(final HttpServletRequest request, final @RequestParam(value="path") String path, Model model) throws ServletException, IOException {
        ModelMap myModel = new ModelMap();
        final ArrayList nodes = new ArrayList();
        this.jcrTemplate.execute(new JcrCallback<Void>(){

            @Override
            public Void doInJcr(Session session) throws IOException, RepositoryException {
                String[] deletes;
                Node parentNode = (Node)session.getItem(SpecialNameChars.encode(path));
                String folderName = SpecialNameChars.encode(request.getParameter("newfolder"));
                boolean doSave = false;
                if (folderName != null && folderName.length() > 0 && !parentNode.hasNode(folderName)) {
                    parentNode.addNode(folderName, "nt:davcollection");
                    doSave = true;
                }
                if ((deletes = request.getParameterValues("deletes")) != null && deletes.length > 0) {
                    for (String name : deletes) {
                        try {
                            parentNode.getNode(SpecialNameChars.encode(name)).remove();
                            doSave = true;
                        }
                        catch (RepositoryException repositoryException) {
                            // empty catch block
                        }
                    }
                }
                if (doSave) {
                    session.save();
                }
                NodeIterator nIter = parentNode.getNodes();
                while (nIter.hasNext()) {
                    String created = "none";
                    String modified = "none";
                    Node node = nIter.nextNode();
                    if (!node.isNodeType("nt:file") && !node.isNodeType("nt:davcollection")) continue;
                    if (node.hasProperty("jcr:created")) {
                        created = node.getProperty("jcr:created").getString();
                    }
                    Node contentNode = node;
                    if (node.isNodeType("nt:file")) {
                        contentNode = node.getNode("jcr:content");
                    }
                    if (contentNode.hasProperty("jcr:lastModified")) {
                        modified = contentNode.getProperty("jcr:lastModified").getString();
                    }
                    nodes.add(new NodeDTO(SpecialNameChars.decode(node.getName()), SpecialNameChars.decode(node.getPath()), node.getPrimaryNodeType().getName(), created, modified));
                }
                return null;
            }
        });
        Collections.sort(nodes);
        myModel.addAttribute("nodes", nodes);
        myModel.addAttribute("path", (Object)path);
        return new ModelAndView("dircontents", "model", (Object)myModel);
    }

    private void populateModelWithAceInfo(Session session, String path, ModelMap model) throws RepositoryException {
        String encodedPath = SpecialNameChars.encode(path);
        AccessControlManager acMgr = session.getAccessControlManager();
        AccessControlPolicy[] acls = acMgr.getPolicies(encodedPath);
        HashMap<Principal, List<Privilege>> privMap = new HashMap<Principal, List<Privilege>>();
        if (acls != null && acls.length > 0) {
            AccessControlList acl = (AccessControlList)acMgr.getPolicies(encodedPath)[0];
            for (AccessControlEntry ace : acl.getAccessControlEntries()) {
                JackrabbitAccessControlEntry jace = (JackrabbitAccessControlEntry)ace;
                if (log.isDebugEnabled()) {
                    ListUsersController.dump(jace);
                }
                boolean appliesToNode = true;
                String[] restrictionNames = jace.getRestrictionNames();
                if (restrictionNames.length > 0) {
                    Value glob = jace.getRestriction("rep:glob");
                    boolean bl = appliesToNode = glob != null && glob.getString() != null && glob.getString().length() == 0;
                }
                if (!appliesToNode) continue;
                ArrayList<Privilege> privileges = new ArrayList<Privilege>(Arrays.asList(jace.getPrivileges()));
                List existingPrivileges = (List)privMap.get(jace.getPrincipal());
                if (existingPrivileges != null) {
                    privileges.addAll(existingPrivileges);
                }
                privMap.put(jace.getPrincipal(), privileges);
                String principalName = jace.getPrincipal().getName();
                if (!principalName.equals("jcr:owner")) continue;
                String owner = "none";
                Node node = session.getNode(encodedPath);
                if (node.hasProperty("jcr:owner")) {
                    owner = node.getProperty("jcr:owner").getValue().getString();
                }
                model.addAttribute("owner", (Object)owner);
            }
            this.filterPrivilegeMapForSASPermissions(privMap);
        }
        model.addAttribute("privMap", privMap);
        model.addAttribute("path", (Object)path);
        model.addAttribute("nodeType", (Object)session.getNode(encodedPath).getPrimaryNodeType().getName());
    }

    private boolean isChanged(String paramValue) {
        if (paramValue == null) {
            return false;
        }
        return paramValue.equals("NoChanged") || paramValue.equals("YesChanged");
    }

    private void readAndSetPermissions(final HttpServletRequest req, final String path, final PrincipalDTO principal) throws RepositoryException {
        this.jcrTemplate.execute(new JcrCallback<Void>(){

            @Override
            public Void doInJcr(Session session) throws IOException, RepositoryException {
                SessionImpl sessionImpl = (SessionImpl)session;
                SASDefaultAccessManager acMgr = (SASDefaultAccessManager)sessionImpl.getAccessManager();
                boolean remove = ListUsersController.this.getStringParameter(req, principal.getName() + "_RMV", "F").equals("T");
                String applyOption = ListUsersController.this.getStringParameter(req, "aceapply", "SUBDIRS");
                boolean recurse = true;
                boolean changesOnly = true;
                if ("OVERWRITE".equalsIgnoreCase(applyOption)) {
                    changesOnly = false;
                }
                if ("DIRONLY".equalsIgnoreCase(applyOption)) {
                    recurse = false;
                }
                ArrayList addList = new ArrayList();
                List removeList = new ArrayList();
                if (!remove) {
                    Boolean test = ListUsersController.this.getValue(changesOnly, ListUsersController.this.getStringParameter(req, principal.getName() + "_RF", null));
                    ListUsersController.this.process(addList, removeList, test, acMgr.privilegeFromName("{http://sas.com/XmlNamespaces/DAV}read"));
                    test = ListUsersController.this.getValue(changesOnly, ListUsersController.this.getStringParameter(req, principal.getName() + "_WF", null));
                    ListUsersController.this.process(addList, removeList, test, acMgr.privilegeFromName("{http://sas.com/XmlNamespaces/DAV}write"));
                    test = ListUsersController.this.getValue(changesOnly, ListUsersController.this.getStringParameter(req, principal.getName() + "_DF", null));
                    ListUsersController.this.process(addList, removeList, test, acMgr.privilegeFromName("{http://sas.com/XmlNamespaces/DAV}delete"));
                    test = ListUsersController.this.getValue(changesOnly, ListUsersController.this.getStringParameter(req, principal.getName() + "_PF", null));
                    ListUsersController.this.process(addList, removeList, test, acMgr.privilegeFromName("{http://sas.com/XmlNamespaces/DAV}admin"));
                    test = ListUsersController.this.getValue(changesOnly, ListUsersController.this.getStringParameter(req, principal.getName() + "_IRF", null));
                    ListUsersController.this.process(addList, removeList, test, acMgr.privilegeFromName("{http://sas.com/XmlNamespaces/DAV}inherit-read"));
                    test = ListUsersController.this.getValue(changesOnly, ListUsersController.this.getStringParameter(req, principal.getName() + "_IWF", null));
                    ListUsersController.this.process(addList, removeList, test, acMgr.privilegeFromName("{http://sas.com/XmlNamespaces/DAV}inherit-write"));
                    test = ListUsersController.this.getValue(changesOnly, ListUsersController.this.getStringParameter(req, principal.getName() + "_IDF", null));
                    ListUsersController.this.process(addList, removeList, test, acMgr.privilegeFromName("{http://sas.com/XmlNamespaces/DAV}inherit-delete"));
                    test = ListUsersController.this.getValue(changesOnly, ListUsersController.this.getStringParameter(req, principal.getName() + "_IPF", null));
                    ListUsersController.this.process(addList, removeList, test, acMgr.privilegeFromName("{http://sas.com/XmlNamespaces/DAV}inherit-admin"));
                    if (log.isDebugEnabled()) {
                        log.debug("Setting permissions " + addList);
                    }
                }
                removeList = ListUsersController.this.expandAggregatePrivileges(removeList);
                UserPrincipal p = null;
                p = "addp".equals(principal.getName()) ? new UserPrincipal(ListUsersController.this.getStringParameter(req, "addprincipal", null)) : new UserPrincipal(principal.getName());
                Node node = session.getNode(SpecialNameChars.encode(path));
                ListUsersController.this.applyChanges(acMgr, (Principal)p, node, addList, removeList, remove, recurse);
                session.save();
                return null;
            }
        });
    }

    private void applyChanges(SASDefaultAccessManager acMgr, Principal p, Node node, List<Privilege> addList, List<Privilege> removeList, boolean remove, boolean recurse) throws AccessDeniedException, PathNotFoundException, RepositoryException {
        JackrabbitAccessControlList jacl = acMgr.getAclForPath(node.getPath());
        if (node.isNodeType("mix:versionable") && !node.isCheckedOut()) {
            node.checkout();
        }
        boolean found = false;
        for (AccessControlEntry ace : jacl.getAccessControlEntries()) {
            JackrabbitAccessControlEntry jace = (JackrabbitAccessControlEntry)ace;
            if (jace.getRestrictionNames().length == 0 || !p.getName().equals(ace.getPrincipal().getName())) continue;
            Privilege[] resolvedPrivileges = this.resolvePrivileges(ace.getPrivileges(), addList, removeList);
            if (!remove) {
                if (removeList.size() > 0) {
                    jacl.removeAccessControlEntry(ace);
                    if (jacl.isEmpty()) {
                        acMgr.removePolicy(node.getPath(), (AccessControlPolicy)jacl);
                    } else {
                        acMgr.setPolicy(node.getPath(), (AccessControlPolicy)jacl);
                    }
                }
                acMgr.setSASPermissions(p, node, Arrays.asList(resolvedPrivileges));
            } else {
                jacl.removeAccessControlEntry(ace);
                if (jacl.isEmpty()) {
                    acMgr.removePolicy(node.getPath(), (AccessControlPolicy)jacl);
                } else {
                    acMgr.setPolicy(node.getPath(), (AccessControlPolicy)jacl);
                }
            }
            found = true;
        }
        if (!found && !remove) {
            acMgr.setSASPermissions(p, node, addList);
        }
        if (recurse && node.isNodeType("nt:davcollection")) {
            NodeIterator nIter = node.getNodes();
            while (nIter.hasNext()) {
                Node child = nIter.nextNode();
                if (child.isNodeType("nt:davcollection")) {
                    this.applyChanges(acMgr, p, child, addList, removeList, remove, recurse);
                    continue;
                }
                if (!child.isNodeType("nt:file")) continue;
                this.applyChanges(acMgr, p, child, addList, removeList, remove, recurse);
            }
        }
    }

    private List<Privilege> expandAggregatePrivileges(List<Privilege> removeList) {
        ArrayList<Privilege> result = new ArrayList<Privilege>();
        result.addAll(removeList);
        for (Privilege p : removeList) {
            if (!p.isAggregate()) continue;
            for (Privilege p2 : this.expandAggregatePrivilege(p)) {
                if (result.contains(p2)) continue;
                result.add(p2);
            }
        }
        return result;
    }

    private List<Privilege> expandAggregatePrivilege(Privilege priv) {
        List<Privilege> result = Arrays.asList(priv.getAggregatePrivileges());
        for (Privilege p : priv.getAggregatePrivileges()) {
            if (!p.isAggregate()) continue;
            result.addAll(this.expandAggregatePrivilege(p));
        }
        return result;
    }

    private void process(List<Privilege> addList, List<Privilege> removeList, Boolean b, Privilege privilege) {
        if (b != null && b.booleanValue()) {
            addList.add(privilege);
        } else if (b != null && !b.booleanValue()) {
            removeList.add(privilege);
        }
    }

    private Privilege[] resolvePrivileges(Privilege[] origPrivileges, List<Privilege> addList, List<Privilege> removeList) {
        ArrayList<Privilege> result = new ArrayList<Privilege>(Arrays.asList(origPrivileges));
        for (Privilege p : addList) {
            if (result.contains(p)) continue;
            result.add(p);
        }
        for (Privilege p : removeList) {
            if (!result.contains(p)) continue;
            result.remove(p);
        }
        return result.toArray(new Privilege[0]);
    }

    private Boolean getFlag(String paramValue) {
        if (paramValue == null) {
            return null;
        }
        if (paramValue.equals("YesChanged") || paramValue.equals("YesUnchanged")) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public String getStringParameter(HttpServletRequest req, String name, String defValue) {
        String result = req.getParameter(name);
        if (result == null || result.equals("")) {
            result = this.getQueryParameter(req, name, defValue);
        }
        return result;
    }

    public String getQueryParameter(HttpServletRequest req, String parameter, String defValue) {
        String src = req.getQueryString();
        if (src == null) {
            return defValue;
        }
        while (src.length() > 0) {
            String value;
            String key;
            String pair;
            int separator = src.indexOf("&");
            if (separator == -1) {
                pair = src;
                src = "";
            } else {
                pair = src.substring(0, separator);
                src = src.substring(separator + 1);
            }
            int equalsign = pair.indexOf("=");
            if (equalsign == -1) {
                key = src;
                value = new String();
            } else {
                key = pair.substring(0, equalsign);
                value = pair.substring(equalsign + 1);
            }
            if (!key.equalsIgnoreCase(parameter)) continue;
            return value;
        }
        return defValue;
    }

    private Boolean getValue(boolean bOnlyChanged, String paramValue) {
        if (paramValue == null) {
            return null;
        }
        if (!bOnlyChanged || this.isChanged(paramValue)) {
            return this.getFlag(paramValue);
        }
        return null;
    }

    private void filterPrivilegeMapForSASPermissions(Map<Principal, List<Privilege>> privMap) {
        Iterator<Map.Entry<Principal, List<Privilege>>> entries = privMap.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry<Principal, List<Privilege>> entry = entries.next();
            boolean found = false;
            for (Privilege priv : entry.getValue()) {
                String name = priv.getName();
                if (name.startsWith("jcr:")) continue;
                found = true;
                break;
            }
            if (found) continue;
            entries.remove();
        }
    }

    private static void dump(JackrabbitAccessControlEntry jace) throws RepositoryException {
        StringBuffer sb = new StringBuffer();
        sb.append(jace.getPrincipal().getName() + ": [");
        Privilege[] privileges = jace.getPrivileges();
        for (int i = 0; i < privileges.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(privileges[i].getName());
        }
        sb.append("] {");
        String[] rnames = jace.getRestrictionNames();
        for (int i = 0; i < rnames.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(rnames[i] + ": " + jace.getRestriction(rnames[i]).getString());
        }
        sb.append("}");
        log.debug(sb.toString());
    }
}

