/*
 * Decompiled with CFR 0.152.
 */
package com.sas.contentserver.j2ee;

import com.sas.svcs.config.client.UrlGeneratorInterface;
import com.sas.svcs.security.authentication.validation.jasig.Cas20ProxyTicketValidator;
import javax.servlet.ServletContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jasig.cas.client.validation.Assertion;
import org.jasig.cas.client.validation.TicketValidationException;
import org.jasig.cas.client.validation.TicketValidator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.context.ServletContextAware;

public class ServiceTicketValidator
implements TicketValidator,
ServletContextAware {
    private static Logger logger = LogManager.getLogger(ServiceTicketValidator.class);
    Cas20ProxyTicketValidator validator;
    String logonUrl;
    @Autowired
    UrlGeneratorInterface urlGenerator;

    public ServiceTicketValidator(String logonUrl) {
        logger.debug("CAS Server Url: " + logonUrl);
        this.logonUrl = logonUrl;
    }

    public Assertion validate(String ticket, String service) throws TicketValidationException {
        Assertion assertion;
        try {
            logger.debug("Attempting validation for service " + service + " using ticket " + ticket);
            assertion = this.getValidator().validate(ticket, service);
        }
        catch (TicketValidationException e) {
            String internalUrl;
            logger.debug(e.getMessage());
            if (Boolean.getBoolean("sas.retry.internal.url") && (internalUrl = System.getProperty("sas.scs.svc.internal.url")) != null && internalUrl.length() > 0) {
                String externalUrl = service.substring(0, service.indexOf("/", service.indexOf("://") + 3));
                service = service.replace(externalUrl, internalUrl);
                logger.debug("Attempting validation for service " + service + " using ticket " + ticket);
                return this.getValidator().validate(ticket, service);
            }
            throw e;
        }
        catch (RuntimeException e) {
            throw new TicketValidationException("Exception while validating ticket");
        }
        return assertion;
    }

    private synchronized TicketValidator getValidator() {
        if (null == this.validator) {
            this.logonUrl = this.urlGenerator.generateInternalUrl("Logon Manager 9.4", "", "");
            logger.debug("Generated internal url: " + this.logonUrl);
            this.validator = new Cas20ProxyTicketValidator(this.logonUrl);
            this.validator.setAcceptAnyProxy(true);
        }
        return this.validator;
    }

    public void setServletContext(ServletContext servletContext) {
    }
}

