/*
 * Decompiled with CFR 0.152.
 */
package com.sas.contentserver.j2ee;

import com.sas.contentserver.core.TenantRepositoryImpl;
import com.sas.contentserver.core.config.SASRepositoryConfig;
import com.sas.contentserver.core.data.TenantGarbageCollector;
import com.sas.contentserver.j2ee.SASRepositoryStartupServletConfig;
import com.sas.contentserver.util.DistributedLock;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.Map;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.apache.jackrabbit.core.RepositoryCopier;
import org.apache.jackrabbit.core.RepositoryImpl;
import org.apache.jackrabbit.core.config.RepositoryConfig;
import org.apache.jackrabbit.j2ee.RepositoryStartupServlet;
import org.apache.jackrabbit.rmi.server.RemoteAdapterFactory;
import org.apache.jackrabbit.rmi.server.ServerAdapterFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.xml.sax.InputSource;

public class SASRepositoryStartupServlet
extends RepositoryStartupServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(SASRepositoryStartupServlet.class);
    private SASRepositoryStartupServletConfig config = null;
    private static final String SAS_DEPLOY_DIR = System.getProperty("sas.deploy.dir");
    private static final String SAS_REPOS_DIR = System.getProperty("sas.scs.repository.dir");
    private static final String SAS_INSTANCE_ID = System.getProperty("sas.appserver.instance.id");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Repository createRepository(InputSource is, File homedir) throws RepositoryException {
        DistributedLock.lock();
        try {
            RepositoryConfig config = SASRepositoryConfig.create(is, homedir.getAbsolutePath());
            TenantRepositoryImpl tenantRepositoryImpl = TenantRepositoryImpl.create(config);
            return tenantRepositoryImpl;
        }
        finally {
            DistributedLock.unlock();
        }
    }

    public ServletConfig getServletConfig() {
        if (this.config == null) {
            this.config = new SASRepositoryStartupServletConfig(super.getServletConfig());
        }
        return this.config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SuppressWarnings(value={"PT_ABSOLUTE_PATH_TRAVERSAL", "PT_RELATIVE_PATH_TRAVERSAL"}, justification="Necessary for migration packages to be built")
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (req.getRequestURI().endsWith("copy")) {
            SecurityContext sc = SecurityContextHolder.getContext();
            boolean admin = false;
            if (sc.getAuthentication() != null) {
                for (GrantedAuthority ga : sc.getAuthentication().getAuthorities()) {
                    if (!"ROLE_ADMIN".equals(ga.getAuthority())) continue;
                    admin = true;
                    break;
                }
            }
            if (!admin) {
                PrintWriter respWriter = resp.getWriter();
                respWriter.write("Status:403\n");
                respWriter.write("Backup operation not allowed for non-admin users\n");
                resp.setStatus(403);
                log.error("Backup operation not allowed for non-admin users.");
                return;
            }
            boolean isBackup = false;
            try {
                File target = null;
                String targetString = req.getParameter("target");
                if (targetString != null) {
                    target = new File(targetString);
                    target.mkdirs();
                } else {
                    String backupString = req.getParameter("backup");
                    if (backupString != null && backupString.length() > 0) {
                        if (SAS_DEPLOY_DIR == null) {
                            log.warn("No 'sas.deploy.dir' property available");
                            resp.setStatus(400);
                            return;
                        }
                        File configDir = new File(SAS_DEPLOY_DIR);
                        configDir = configDir.getParentFile().getParentFile().getParentFile().getParentFile();
                        StringBuffer sb = new StringBuffer(50);
                        sb.append(File.separatorChar);
                        sb.append("Backup");
                        sb.append(File.separatorChar);
                        sb.append("dropzone");
                        sb.append(File.separatorChar);
                        sb.append(backupString);
                        sb.append(File.separatorChar);
                        sb.append("content");
                        String s = configDir.getCanonicalPath() + sb.toString();
                        File backup = new File(s);
                        if (!s.equals(backup.getCanonicalPath())) {
                            log.warn("Inconsistent paths: '" + s + "' '" + backup.getCanonicalPath() + "'");
                            resp.setStatus(400);
                            return;
                        }
                        target = backup;
                        target.mkdirs();
                        isBackup = true;
                    } else {
                        log.warn("No value given for backup property");
                        resp.setStatus(400);
                        return;
                    }
                }
                this.doCopy(target);
                PrintWriter respWriter = resp.getWriter();
                if (isBackup) {
                    FileUtils.copyFileToDirectory((File)new File(SAS_REPOS_DIR, "repository.xml"), (File)new File(target, "Backup_RepositoryXML"));
                    resp.setContentType("text/xml");
                    respWriter.write("<?xml version=\"1.0\"?>\n<backup>\n");
                    respWriter.write("<path>" + target.getCanonicalPath() + "</path>\n");
                    respWriter.write("<instanceid>" + SAS_INSTANCE_ID + "</instanceid>\n");
                    respWriter.write("</backup>");
                } else {
                    respWriter.write("Status:200\n");
                    respWriter.write("Repository copy completed successfully.\n");
                    respWriter.write("\n");
                }
                resp.setStatus(200);
                return;
            }
            catch (Exception ex) {
                PrintWriter respWriter = resp.getWriter();
                respWriter.write("Status:500\n");
                ex.printStackTrace(respWriter);
                respWriter.write("\n");
                resp.setStatus(500);
                log.error("Exception while attempting repository copy.", (Throwable)ex);
                return;
            }
        }
        if (!req.getRequestURI().endsWith("collectDataStoreGarbage")) {
            super.doPost(req, resp);
            return;
        }
        PrintWriter respWriter = resp.getWriter();
        try (TenantGarbageCollector gc = null;){
            RepositoryConfig config = ((RepositoryImpl)this.getRepository()).getConfig();
            if (config.getDataStore() != null) {
                TenantRepositoryImpl repo = (TenantRepositoryImpl)this.getRepository();
                gc = (TenantGarbageCollector)repo.createDataStoreGarbageCollector();
                log.info("Marking all files for deletion...");
                gc.markAll();
                log.info("Removing unused files...");
                Map<Integer, Integer> cleaned = gc.sweepAll();
                respWriter.write("Status:200\n");
                respWriter.write("Garbage collection successful\n");
                int totalCleaned = 0;
                for (Integer i : cleaned.values()) {
                    totalCleaned += i.intValue();
                }
                respWriter.write("Removed " + totalCleaned + (totalCleaned == 1 ? " file" : " files") + " from the Data Store");
                respWriter.write("\n");
                resp.setStatus(200);
                return;
            }
            respWriter.write("DataStore is not configured for server");
            respWriter.write("\n");
            resp.setStatus(400);
            return;
        }
    }

    protected void doCopy(File targetFile) throws IOException, RepositoryException {
        RepositoryCopier.copy((RepositoryImpl)((RepositoryImpl)this.getRepository()), (RepositoryConfig)SASRepositoryConfig.install(targetFile));
    }

    static {
        if (SAS_INSTANCE_ID != null) {
            System.setProperty("org.apache.jackrabbit.core.cluster.node_id", SAS_INSTANCE_ID);
        }
    }

    public static class RMIRemoteFactoryDelegater
    extends RepositoryStartupServlet.RemoteFactoryDelegater {
        private static final RemoteAdapterFactory FACTORY = new ServerAdapterFactory();

        public Remote createRemoteRepository(Repository repository) throws RemoteException {
            return FACTORY.getRemoteRepository(repository);
        }
    }
}

