/*
 * Decompiled with CFR 0.152.
 */
package com.sas.contentserver.core.observation;

import com.sas.framework.commons.holders.TenantHolder;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.jackrabbit.core.observation.EventConsumer;
import org.apache.jackrabbit.core.observation.EventStateCollection;
import org.apache.jackrabbit.core.observation.ObservationDispatcher;
import org.apache.jackrabbit.core.state.ChangeLog;

public class TenantObservationDispatcher
extends ObservationDispatcher {
    private Map<Integer, ObservationDispatcher> tenantDispatchers;
    private boolean initialized = false;

    public TenantObservationDispatcher() {
        this.initializeDispatchersCache();
    }

    private synchronized void initializeDispatchersCache() {
        if (this.tenantDispatchers == null) {
            this.tenantDispatchers = new HashMap<Integer, ObservationDispatcher>();
            this.tenantDispatchers.put(TenantHolder.get().getId(), this);
            this.initialized = true;
        }
    }

    public void dispose() {
        ObservationDispatcher dispatcher = this.getTenantDispatcher();
        if (dispatcher instanceof TenantObservationDispatcher) {
            super.dispose();
        } else {
            dispatcher.dispose();
        }
    }

    public Set<EventConsumer> getAsynchronousConsumers() {
        ObservationDispatcher dispatcher = this.getTenantDispatcher();
        if (dispatcher instanceof TenantObservationDispatcher) {
            return super.getAsynchronousConsumers();
        }
        return dispatcher.getAsynchronousConsumers();
    }

    public Set<EventConsumer> getSynchronousConsumers() {
        ObservationDispatcher dispatcher = this.getTenantDispatcher();
        if (dispatcher instanceof TenantObservationDispatcher) {
            return super.getSynchronousConsumers();
        }
        return dispatcher.getSynchronousConsumers();
    }

    public void run() {
        ObservationDispatcher dispatcher = this.getTenantDispatcher();
        if (dispatcher instanceof TenantObservationDispatcher) {
            super.run();
        } else {
            dispatcher.run();
        }
    }

    public void prepareEvents(EventStateCollection events) {
        ObservationDispatcher dispatcher = this.getTenantDispatcher();
        if (dispatcher instanceof TenantObservationDispatcher) {
            super.prepareEvents(events);
        } else {
            dispatcher.prepareEvents(events);
        }
    }

    public void prepareDeleted(EventStateCollection events, ChangeLog changes) {
        ObservationDispatcher dispatcher = this.getTenantDispatcher();
        if (dispatcher instanceof TenantObservationDispatcher) {
            super.prepareDeleted(events, changes);
        } else {
            dispatcher.prepareDeleted(events, changes);
        }
    }

    public void dispatchEvents(EventStateCollection events) {
        ObservationDispatcher dispatcher = this.getTenantDispatcher();
        if (dispatcher instanceof TenantObservationDispatcher) {
            super.dispatchEvents(events);
        } else {
            dispatcher.dispatchEvents(events);
        }
    }

    public void delayIfEventQueueOverloaded() {
        ObservationDispatcher dispatcher = this.getTenantDispatcher();
        if (dispatcher instanceof TenantObservationDispatcher) {
            super.delayIfEventQueueOverloaded();
        } else {
            dispatcher.delayIfEventQueueOverloaded();
        }
    }

    public void addConsumer(EventConsumer consumer) {
        ObservationDispatcher dispatcher = this.getTenantDispatcher();
        if (dispatcher instanceof TenantObservationDispatcher) {
            super.addConsumer(consumer);
        } else {
            dispatcher.addConsumer(consumer);
        }
    }

    public void removeConsumer(EventConsumer consumer) {
        ObservationDispatcher dispatcher = this.getTenantDispatcher();
        if (dispatcher instanceof TenantObservationDispatcher) {
            super.removeConsumer(consumer);
        } else {
            dispatcher.removeConsumer(consumer);
        }
    }

    private ObservationDispatcher getTenantDispatcher() {
        ObservationDispatcher ret;
        if (!this.initialized) {
            this.initializeDispatchersCache();
        }
        if ((ret = this.tenantDispatchers.get(TenantHolder.get().getId())) == null) {
            ret = new ObservationDispatcher();
            this.tenantDispatchers.put(TenantHolder.get().getId(), ret);
        }
        return ret;
    }
}

