/*
 * Decompiled with CFR 0.152.
 */
package com.sas.contentserver.core.nodetype;

import com.sas.framework.commons.holders.TenantHolder;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.nodetype.NodeTypeRegistry;
import org.apache.jackrabbit.core.nodetype.NodeTypeRegistryListener;
import org.apache.jackrabbit.core.nodetype.virtual.VirtualNodeTypeStateManager;
import org.apache.jackrabbit.core.observation.DelegatingObservationDispatcher;
import org.apache.jackrabbit.core.virtual.VirtualItemStateProvider;
import org.apache.jackrabbit.spi.Name;

public class TenantVirtualNodeTypeStateManager
extends VirtualNodeTypeStateManager {
    private Map<Integer, VirtualNodeTypeStateManager> virtNTMans;
    private NodeTypeRegistry ntReg;
    private DelegatingObservationDispatcher obs;
    private NodeId rootNodeId;
    private NodeId parentId;

    public TenantVirtualNodeTypeStateManager(NodeTypeRegistry ntReg, DelegatingObservationDispatcher obs, NodeId rootNodeId, NodeId parentId) {
        super(ntReg, obs, rootNodeId, parentId);
        this.ntReg = ntReg;
        this.obs = obs;
        this.rootNodeId = rootNodeId;
        this.parentId = parentId;
        this.virtNTMans = new HashMap<Integer, VirtualNodeTypeStateManager>();
        this.virtNTMans.put(TenantHolder.get().getId(), this);
    }

    public synchronized VirtualItemStateProvider getVirtualItemStateProvider() {
        VirtualNodeTypeStateManager virtNTMan = this.getTenantVirtualNodeTypeStateManager();
        if (virtNTMan instanceof TenantVirtualNodeTypeStateManager) {
            return super.getVirtualItemStateProvider();
        }
        return virtNTMan.getVirtualItemStateProvider();
    }

    public void nodeTypeRegistered(Name ntName) {
        VirtualNodeTypeStateManager virtNTMan = this.getTenantVirtualNodeTypeStateManager();
        if (virtNTMan instanceof TenantVirtualNodeTypeStateManager) {
            super.nodeTypeRegistered(ntName);
        } else {
            virtNTMan.nodeTypeRegistered(ntName);
        }
    }

    public void nodeTypeReRegistered(Name ntName) {
        VirtualNodeTypeStateManager virtNTMan = this.getTenantVirtualNodeTypeStateManager();
        if (virtNTMan instanceof TenantVirtualNodeTypeStateManager) {
            super.nodeTypeReRegistered(ntName);
        } else {
            virtNTMan.nodeTypeReRegistered(ntName);
        }
    }

    public void nodeTypesUnregistered(Collection<Name> names) {
        VirtualNodeTypeStateManager virtNTMan = this.getTenantVirtualNodeTypeStateManager();
        if (virtNTMan instanceof TenantVirtualNodeTypeStateManager) {
            super.nodeTypesUnregistered(names);
        } else {
            virtNTMan.nodeTypesUnregistered(names);
        }
    }

    public void setSession(SessionImpl systemSession) {
        VirtualNodeTypeStateManager virtNTMan = this.getTenantVirtualNodeTypeStateManager();
        if (virtNTMan instanceof TenantVirtualNodeTypeStateManager) {
            super.setSession(systemSession);
        } else {
            virtNTMan.setSession(systemSession);
        }
    }

    private VirtualNodeTypeStateManager getTenantVirtualNodeTypeStateManager() {
        VirtualNodeTypeStateManager ret = this.virtNTMans.get(TenantHolder.get().getId());
        if (ret == null) {
            ret = new VirtualNodeTypeStateManager(this.ntReg, this.obs, this.rootNodeId, this.parentId);
            this.ntReg.removeListener((NodeTypeRegistryListener)ret);
        }
        return ret;
    }
}

