/*
 * Decompiled with CFR 0.152.
 */
package com.sas.contentserver.core.lock;

import com.sas.contentserver.core.lock.SASLockImpl;
import com.sas.contentserver.core.lock.SASLockManagerImpl;
import javax.jcr.RepositoryException;
import javax.jcr.lock.Lock;
import javax.jcr.lock.LockException;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.lock.LockManagerImpl;
import org.apache.jackrabbit.core.lock.XALockManager;

public class SASXALockManager
extends XALockManager {
    private LockManagerImpl lockMgr;

    public SASXALockManager(LockManagerImpl lockMgr) {
        super(lockMgr);
        this.lockMgr = lockMgr;
    }

    public Lock getLock(NodeImpl node) throws LockException, RepositoryException {
        Lock lock = super.getLock(node);
        return new SASLockImpl(lock);
    }

    public Lock[] getLocks(SessionImpl session) throws RepositoryException {
        Lock[] locks = this.getLocks(session);
        Lock[] ret = new Lock[locks.length];
        for (int i = 0; i < locks.length; ++i) {
            ret[i] = locks[i] instanceof SASLockImpl ? locks[i] : new SASLockImpl(locks[i]);
        }
        return ret;
    }

    public void unlock(NodeImpl node) throws LockException, RepositoryException {
        if (this.isInXA()) {
            this.xaEnv.unlock(node);
        } else {
            ((SASLockManagerImpl)this.lockMgr).internalUnlock(node);
        }
        ((SASLockManagerImpl)this.lockMgr).removeLockProperties(node);
    }
}

