/*
 * Decompiled with CFR 0.152.
 */
package com.sas.contentserver.core.data;

import com.sas.contentserver.core.data.TenantDbDataStore;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.ResultSet;
import org.apache.commons.io.IOUtils;
import org.apache.jackrabbit.core.data.DataIdentifier;
import org.apache.jackrabbit.core.data.DataStoreException;
import org.apache.jackrabbit.core.data.db.DbInputStream;
import org.apache.jackrabbit.core.data.db.TempFileInputStream;
import org.apache.jackrabbit.core.util.db.DbUtility;
import org.apache.jackrabbit.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TenantTeradataDbDataStore
extends TenantDbDataStore {
    private static Logger log = LoggerFactory.getLogger(TenantDbDataStore.class);

    protected void initDatabaseType() throws DataStoreException {
        this.createTableSQL = this.replaceTokens(this.createTableSQL);
        this.insertTempSQL = this.replaceTokens(this.insertTempSQL);
        this.updateDataSQL = this.replaceTokens(this.updateDataSQL);
        this.updateLastModifiedSQL = this.replaceTokens(this.updateLastModifiedSQL);
        this.updateSQL = this.replaceTokens(this.updateSQL);
        this.deleteSQL = this.replaceTokens(this.deleteSQL);
        this.deleteOlderSQL = this.replaceTokens(this.deleteOlderSQL);
        this.selectMetaSQL = this.replaceTokens(this.selectMetaSQL);
        this.selectAllSQL = this.replaceTokens(this.selectAllSQL);
        this.selectDataSQL = this.replaceTokens(this.selectDataSQL);
        this.storeStream = this.replaceTokens(this.storeStream);
        if (!("-1".equals(this.storeStream) || "tempFile".equals(this.storeStream) || "max".equals(this.storeStream))) {
            String msg = "Unsupported Stream store mechanism: " + this.storeStream + " supported are: " + "-1" + ", " + "tempFile" + ", " + "max";
            log.debug(msg);
            throw new DataStoreException(msg);
        }
    }

    private String replaceTokens(String sql) {
        String ret = Text.replace((String)sql, (String)"${table}", (String)this.tableSQL).trim();
        ret = Text.replace((String)ret, (String)"${tablePrefix}", (String)(this.tablePrefix + this.schemaObjectPrefix)).trim();
        return ret;
    }

    protected InputStream openStream(DbInputStream inputStream, DataIdentifier identifier) throws DataStoreException {
        ResultSet rs = null;
        try {
            rs = this.conHelper.query(this.selectDataSQL, new Object[]{identifier.toString()});
            if (!rs.next()) {
                throw new DataStoreException("Record not found: " + identifier);
            }
            Blob blob = rs.getBlob(2);
            InputStream stream = blob.getBinaryStream();
            if (stream == null) {
                stream = new ByteArrayInputStream(new byte[0]);
                DbUtility.close((ResultSet)rs);
            } else if (this.copyWhenReading) {
                File temp = this.moveToTempFile(stream);
                stream = new BufferedInputStream((InputStream)new TempFileInputStream(temp));
                DbUtility.close((ResultSet)rs);
            } else {
                final ResultSet rs2 = rs;
                stream = new FilterInputStream(stream){

                    @Override
                    public void close() throws IOException {
                        try {
                            this.in.close();
                        }
                        finally {
                            DbUtility.close((ResultSet)rs2);
                        }
                    }
                };
                inputStream.setResultSet(rs);
            }
            return stream;
        }
        catch (Exception e) {
            DbUtility.close(rs);
            throw this.convert("Retrieving database resource ", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File moveToTempFile(InputStream in) throws IOException {
        File temp = File.createTempFile("dbRecord", null);
        try (FileOutputStream out = new FileOutputStream(temp);){
            IOUtils.copy((InputStream)in, (OutputStream)out);
        }
        finally {
            in.close();
        }
        return temp;
    }
}

