/*
 * Decompiled with CFR 0.152.
 */
package com.sas.contentserver.core.config;

import com.sas.contentserver.core.TenantRepositoryImpl;
import com.sas.contentserver.core.config.SASRepositoryConfigurationParser;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.jackrabbit.core.config.ClusterConfig;
import org.apache.jackrabbit.core.config.ConfigurationException;
import org.apache.jackrabbit.core.config.DataSourceConfig;
import org.apache.jackrabbit.core.config.RepositoryConfig;
import org.apache.jackrabbit.core.config.RepositoryConfigurationParser;
import org.apache.jackrabbit.core.config.SecurityConfig;
import org.apache.jackrabbit.core.config.VersioningConfig;
import org.apache.jackrabbit.core.data.DataStoreFactory;
import org.apache.jackrabbit.core.fs.FileSystemFactory;
import org.apache.jackrabbit.core.query.QueryHandlerFactory;
import org.apache.jackrabbit.core.util.RepositoryLockMechanismFactory;
import org.apache.jackrabbit.core.util.db.ConnectionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class SASRepositoryConfig
extends RepositoryConfig {
    private static Logger log = LoggerFactory.getLogger(SASRepositoryConfig.class);
    private static final String REPOSITORY_XML = "repository.xml";

    public SASRepositoryConfig(String home, SecurityConfig sec, FileSystemFactory fsf, String workspaceDirectory, String workspaceConfigDirectory, String defaultWorkspace, int workspaceMaxIdleTime, Element template, VersioningConfig vc, QueryHandlerFactory qhf, ClusterConfig cc, DataStoreFactory dsf, RepositoryLockMechanismFactory rlf, DataSourceConfig dsc, ConnectionFactory cf, RepositoryConfigurationParser parser) {
        super(home, sec, fsf, workspaceDirectory, workspaceConfigDirectory, defaultWorkspace, workspaceMaxIdleTime, template, vc, qhf, cc, dsf, rlf, dsc, cf, parser);
    }

    public static RepositoryConfig create(InputSource xml, Properties variables) throws ConfigurationException {
        SASRepositoryConfigurationParser parser = new SASRepositoryConfigurationParser(variables, new ConnectionFactory());
        RepositoryConfig config = parser.parseRepositoryConfig(xml);
        config.init();
        return config;
    }

    public static RepositoryConfig create(InputStream input, String home) throws ConfigurationException {
        return SASRepositoryConfig.create(new InputSource(input), home);
    }

    public static RepositoryConfig create(File xml, File dir) throws ConfigurationException {
        if (!dir.isDirectory()) {
            throw new ConfigurationException("Repository directory " + dir + " does not exist");
        }
        if (!xml.isFile()) {
            throw new ConfigurationException("Repository configuration file " + xml + " does not exist");
        }
        return SASRepositoryConfig.create(new InputSource(xml.toURI().toString()), dir.getPath());
    }

    public static RepositoryConfig create(File dir) throws ConfigurationException {
        return SASRepositoryConfig.create(new File(dir, REPOSITORY_XML), dir);
    }

    public static RepositoryConfig create(URI uri, String home) throws ConfigurationException {
        return SASRepositoryConfig.create(new InputSource(uri.toString()), home);
    }

    public static RepositoryConfig create(InputSource xml, String home) throws ConfigurationException {
        Properties variables = new Properties(System.getProperties());
        variables.setProperty("rep.home", home);
        return SASRepositoryConfig.create(xml, variables);
    }

    public static RepositoryConfig create(String file, String home) throws ConfigurationException {
        URI uri = new File(file).toURI();
        return SASRepositoryConfig.create(new InputSource(uri.toString()), home);
    }

    public static RepositoryConfig install(File dir) throws IOException, ConfigurationException {
        return SASRepositoryConfig.install(new File(dir, REPOSITORY_XML), dir);
    }

    public static RepositoryConfig install(File xml, File dir) throws IOException, ConfigurationException {
        SASRepositoryConfig.installRepositorySkeleton(dir, xml, TenantRepositoryImpl.class.getResource(REPOSITORY_XML));
        return SASRepositoryConfig.create(xml, dir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void installRepositorySkeleton(File dir, File xml, URL resource) throws IOException {
        if (!dir.exists()) {
            log.info("Creating repository directory {}", (Object)dir);
            dir.mkdirs();
        }
        if (!xml.exists()) {
            log.info("Copying configuration from {} to {}", (Object)resource, (Object)xml);
            try (FileOutputStream output = new FileOutputStream(xml);
                 InputStream input = resource.openStream();){
                IOUtils.copy((InputStream)input, (OutputStream)output);
            }
        }
    }
}

