/*
 * Decompiled with CFR 0.152.
 */
package com.sas.contentserver.core;

import com.sas.contentserver.core.TenantRepositoryImpl;
import com.sas.framework.commons.holders.TenantHolder;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.version.VersionException;
import org.apache.jackrabbit.core.cluster.UpdateEventChannel;
import org.apache.jackrabbit.core.config.VersioningConfig;
import org.apache.jackrabbit.core.fs.FileSystem;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.id.NodeIdFactory;
import org.apache.jackrabbit.core.nodetype.NodeTypeRegistry;
import org.apache.jackrabbit.core.observation.DelegatingObservationDispatcher;
import org.apache.jackrabbit.core.observation.EventState;
import org.apache.jackrabbit.core.persistence.PersistenceManager;
import org.apache.jackrabbit.core.state.ChangeLog;
import org.apache.jackrabbit.core.state.ISMLocking;
import org.apache.jackrabbit.core.state.ItemState;
import org.apache.jackrabbit.core.state.ItemStateCacheFactory;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.core.state.SharedItemStateManager;
import org.apache.jackrabbit.core.version.InternalVersion;
import org.apache.jackrabbit.core.version.InternalVersionHistory;
import org.apache.jackrabbit.core.version.InternalVersionItem;
import org.apache.jackrabbit.core.version.InternalVersionManagerImpl;
import org.apache.jackrabbit.core.version.NodeStateEx;
import org.apache.jackrabbit.core.version.VersionHistoryInfo;
import org.apache.jackrabbit.core.virtual.VirtualItemStateProvider;
import org.apache.jackrabbit.spi.Name;

public class TenantInternalVersionManagerImpl
extends InternalVersionManagerImpl {
    private Map<Integer, InternalVersionManagerImpl> initializedVMgrs = new HashMap<Integer, InternalVersionManagerImpl>();
    private VersioningConfig vConfig;
    private FileSystem fs;
    private NodeTypeRegistry ntReg;
    private DelegatingObservationDispatcher obsMgr;
    private NodeId systemId;
    private NodeId historiesId;
    private NodeId activitiesId;
    private ItemStateCacheFactory cacheFactory;
    private ISMLocking ismLocking;
    private NodeIdFactory nodeIdFactory;
    private TenantRepositoryImpl reposImpl;

    public TenantInternalVersionManagerImpl(VersioningConfig vConfig, FileSystem fs, NodeTypeRegistry ntReg, DelegatingObservationDispatcher obsMgr, NodeId systemId, NodeId historiesId, NodeId activitiesId, ItemStateCacheFactory cacheFactory, ISMLocking ismLocking, NodeIdFactory nodeIdFactory, TenantRepositoryImpl reposImpl) throws RepositoryException {
        super(reposImpl.createPersistenceManager(vConfig.getHomeDir(), fs, vConfig.getPersistenceManagerConfig()), fs, ntReg, obsMgr, systemId, historiesId, activitiesId, cacheFactory, ismLocking, nodeIdFactory);
        this.initializedVMgrs.put(TenantHolder.get().getId(), this);
        this.vConfig = vConfig;
        this.fs = fs;
        this.ntReg = ntReg;
        this.obsMgr = obsMgr;
        this.systemId = systemId;
        this.historiesId = historiesId;
        this.activitiesId = activitiesId;
        this.cacheFactory = cacheFactory;
        this.ismLocking = ismLocking;
        this.nodeIdFactory = nodeIdFactory;
        this.reposImpl = reposImpl;
    }

    private InternalVersionManagerImpl getTenantInternalVersionManagerImpl() {
        InternalVersionManagerImpl ret = this.initializedVMgrs.get(TenantHolder.get().getId());
        if (ret == null) {
            try {
                PersistenceManager pMgr = this.reposImpl.createPersistenceManager(this.vConfig.getHomeDir(), this.fs, this.vConfig.getPersistenceManagerConfig());
                ret = new InternalVersionManagerImpl(pMgr, this.fs, this.ntReg, this.obsMgr, this.systemId, this.historiesId, this.activitiesId, this.cacheFactory, this.ismLocking, this.nodeIdFactory);
                this.initializedVMgrs.put(TenantHolder.get().getId(), ret);
            }
            catch (RepositoryException e) {
                ret = null;
            }
        }
        return ret;
    }

    public NodeId canCheckout(NodeStateEx state, NodeId activityId) throws RepositoryException {
        InternalVersionManagerImpl vMgr = this.getTenantInternalVersionManagerImpl();
        if (vMgr instanceof TenantInternalVersionManagerImpl) {
            return super.canCheckout(state, activityId);
        }
        return vMgr.canCheckout(state, activityId);
    }

    public InternalVersion checkin(Session session, NodeStateEx node, Calendar created) throws RepositoryException {
        InternalVersionManagerImpl vMgr = this.getTenantInternalVersionManagerImpl();
        if (vMgr instanceof TenantInternalVersionManagerImpl) {
            return super.checkin(session, node, created);
        }
        return vMgr.checkin(session, node, created);
    }

    public NodeId createActivity(Session session, String title) throws RepositoryException {
        InternalVersionManagerImpl vMgr = this.getTenantInternalVersionManagerImpl();
        if (vMgr instanceof TenantInternalVersionManagerImpl) {
            return super.createActivity(session, title);
        }
        return vMgr.createActivity(session, title);
    }

    public VersionHistoryInfo createVersionHistory(Session session, NodeState node, NodeId copiedFrom) throws RepositoryException {
        InternalVersionManagerImpl vMgr = this.getTenantInternalVersionManagerImpl();
        if (vMgr instanceof TenantInternalVersionManagerImpl) {
            return super.createVersionHistory(session, node, copiedFrom);
        }
        return vMgr.createVersionHistory(session, node, copiedFrom);
    }

    public void externalUpdate(ChangeLog changes, List<EventState> events, long timestamp, String userData) throws RepositoryException {
        InternalVersionManagerImpl vMgr = this.getTenantInternalVersionManagerImpl();
        if (vMgr instanceof TenantInternalVersionManagerImpl) {
            super.externalUpdate(changes, events, timestamp, userData);
        } else {
            vMgr.externalUpdate(changes, events, timestamp, userData);
        }
    }

    public InternalVersionItem getItem(NodeId id) throws RepositoryException {
        InternalVersionManagerImpl vMgr = this.getTenantInternalVersionManagerImpl();
        if (vMgr instanceof TenantInternalVersionManagerImpl) {
            return super.getItem(id);
        }
        return vMgr.getItem(id);
    }

    public NodeStateEx getNodeStateEx(NodeId parentNodeId) throws RepositoryException {
        InternalVersionManagerImpl vMgr = this.getTenantInternalVersionManagerImpl();
        if (vMgr instanceof TenantInternalVersionManagerImpl) {
            return super.getNodeStateEx(parentNodeId);
        }
        return vMgr.getNodeStateEx(parentNodeId);
    }

    public PersistenceManager getPersistenceManager() {
        InternalVersionManagerImpl vMgr = this.getTenantInternalVersionManagerImpl();
        if (vMgr instanceof TenantInternalVersionManagerImpl) {
            return super.getPersistenceManager();
        }
        return vMgr.getPersistenceManager();
    }

    public SharedItemStateManager getSharedStateMgr() {
        InternalVersionManagerImpl vMgr = this.getTenantInternalVersionManagerImpl();
        if (vMgr instanceof TenantInternalVersionManagerImpl) {
            return super.getSharedStateMgr();
        }
        return vMgr.getSharedStateMgr();
    }

    public VirtualItemStateProvider getVirtualItemStateProvider() {
        InternalVersionManagerImpl vMgr = this.getTenantInternalVersionManagerImpl();
        if (vMgr instanceof TenantInternalVersionManagerImpl) {
            return super.getVirtualItemStateProvider();
        }
        return vMgr.getVirtualItemStateProvider();
    }

    public boolean hasItem(NodeId id) {
        InternalVersionManagerImpl vMgr = this.getTenantInternalVersionManagerImpl();
        if (vMgr instanceof TenantInternalVersionManagerImpl) {
            return super.hasItem(id);
        }
        return vMgr.hasItem(id);
    }

    public boolean hasItemReferences(NodeId id) throws RepositoryException {
        InternalVersionManagerImpl vMgr = this.getTenantInternalVersionManagerImpl();
        if (vMgr instanceof TenantInternalVersionManagerImpl) {
            return super.hasItemReferences(id);
        }
        return vMgr.hasItemReferences(id);
    }

    public void itemDiscarded(InternalVersionItem item) {
        InternalVersionManagerImpl vMgr = this.getTenantInternalVersionManagerImpl();
        if (vMgr instanceof TenantInternalVersionManagerImpl) {
            super.itemDiscarded(item);
        } else {
            vMgr.itemDiscarded(item);
        }
    }

    public void itemsUpdated(Collection<InternalVersionItem> items) {
        InternalVersionManagerImpl vMgr = this.getTenantInternalVersionManagerImpl();
        if (vMgr instanceof TenantInternalVersionManagerImpl) {
            super.itemsUpdated(items);
        } else {
            vMgr.itemsUpdated(items);
        }
    }

    public void removeActivity(Session session, NodeId nodeId) throws RepositoryException {
        InternalVersionManagerImpl vMgr = this.getTenantInternalVersionManagerImpl();
        if (vMgr instanceof TenantInternalVersionManagerImpl) {
            super.removeActivity(session, nodeId);
        } else {
            vMgr.removeActivity(session, nodeId);
        }
    }

    public void removeVersion(Session session, InternalVersionHistory history, Name name) throws VersionException, RepositoryException {
        InternalVersionManagerImpl vMgr = this.getTenantInternalVersionManagerImpl();
        if (vMgr instanceof TenantInternalVersionManagerImpl) {
            super.removeVersion(session, history, name);
        } else {
            vMgr.removeVersion(session, history, name);
        }
    }

    public void setEventChannel(UpdateEventChannel eventChannel) {
        InternalVersionManagerImpl vMgr = this.getTenantInternalVersionManagerImpl();
        if (vMgr instanceof TenantInternalVersionManagerImpl) {
            super.setEventChannel(eventChannel);
        } else {
            vMgr.setEventChannel(eventChannel);
        }
    }

    public InternalVersion setVersionLabel(Session session, InternalVersionHistory history, Name version, Name label, boolean move) throws RepositoryException {
        InternalVersionManagerImpl vMgr = this.getTenantInternalVersionManagerImpl();
        if (vMgr instanceof TenantInternalVersionManagerImpl) {
            return super.setVersionLabel(session, history, version, label, move);
        }
        return vMgr.setVersionLabel(session, history, version, label, move);
    }

    public void stateDestroyed(ItemState destroyed) {
        InternalVersionManagerImpl vMgr = this.getTenantInternalVersionManagerImpl();
        if (vMgr instanceof TenantInternalVersionManagerImpl) {
            super.stateDestroyed(destroyed);
        } else {
            vMgr.stateDestroyed(destroyed);
        }
    }
}

