/*
 * Decompiled with CFR 0.152.
 */
package com.sas.contentserver.core;

import com.sas.contentserver.core.TenantRepositoryImpl;
import com.sas.contentserver.core.config.SASRepositoryConfig;
import com.sas.contentserver.core.jndi.SASRegistryHelper;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.UUID;
import javax.jcr.RepositoryException;
import org.apache.commons.io.FileUtils;
import org.apache.jackrabbit.core.RepositoryCopier;
import org.apache.jackrabbit.core.RepositoryImpl;
import org.apache.jackrabbit.core.config.ConfigurationException;
import org.apache.jackrabbit.core.config.RepositoryConfig;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.persistence.PersistenceManager;
import org.apache.jackrabbit.core.state.ChangeLog;
import org.apache.jackrabbit.core.state.ItemState;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.NoSuchItemStateException;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.spi.NameFactory;
import org.apache.jackrabbit.spi.commons.name.NameFactoryImpl;

public class JCRCopyRepository {
    public static void main(String[] args) {
        if (args.length != 2) {
            System.out.println("Usage:");
            System.out.println("  JCRCopy srcdir tgtdir");
            System.exit(8);
        }
        File source = new File(args[0]);
        File target = new File(args[1]);
        if (!source.exists()) {
            System.out.println("Source file '" + source + "' does not exist");
            System.exit(8);
        } else if (!target.exists()) {
            System.out.println("Target file '" + target + "' does not exist");
            System.exit(8);
        } else {
            try {
                JCRCopyRepository.doCopy(source, target);
            }
            catch (RepositoryException e) {
                e.printStackTrace();
                System.exit(8);
            }
            catch (IOException e) {
                e.printStackTrace();
                System.exit(8);
            }
        }
        System.exit(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doCopy(File source, File target) throws ConfigurationException, RepositoryException, FileNotFoundException, IOException {
        SASRegistryHelper.registerJNDIDataSources();
        TenantRepositoryImpl sourceRepository = null;
        TenantRepositoryImpl targetRepository = null;
        RepositoryConfig configSource = SASRepositoryConfig.create(new File(source, "repository.xml").getAbsolutePath(), source.getAbsolutePath());
        sourceRepository = TenantRepositoryImpl.create(configSource);
        RepositoryConfig configTarget = SASRepositoryConfig.install(target);
        targetRepository = TenantRepositoryImpl.create(configTarget);
        try {
            new RepositoryCopier((RepositoryImpl)sourceRepository, (RepositoryImpl)targetRepository).copy();
            JCRCopyRepository.fixup(targetRepository);
        }
        finally {
            sourceRepository.shutdown();
            targetRepository.shutdown();
        }
        File repoDir = new File(target, "repository");
        FileUtils.deleteQuietly((File)new File(repoDir, "index"));
        File[] workspaces = new File(target, "workspaces").listFiles();
        if (workspaces != null) {
            for (File workspace : workspaces) {
                FileUtils.deleteQuietly((File)new File(workspace, "index"));
            }
        }
    }

    private static void fixup(TenantRepositoryImpl targetRepository) throws RepositoryException {
        NodeId nodeId;
        TenantRepositoryImpl.TenantWorkspaceInfo wsInfo = (TenantRepositoryImpl.TenantWorkspaceInfo)targetRepository.getWorkspaceInfo("default");
        PersistenceManager pMgr = wsInfo.getPersistenceManager();
        String id = "admin";
        try {
            nodeId = new NodeId(UUID.nameUUIDFromBytes(id.toLowerCase().getBytes("UTF-8")));
        }
        catch (UnsupportedEncodingException e) {
            throw new RepositoryException("Unexpected error while building ID hash", (Throwable)e);
        }
        try {
            NodeState node = pMgr.load(nodeId);
            while (!node.getParentId().equals((Object)RepositoryImpl.ROOT_NODE_ID)) {
                node = pMgr.load(node.getParentId());
            }
            NodeState root = pMgr.load(RepositoryImpl.ROOT_NODE_ID);
            if (!root.hasChildNodeEntry(node.getNodeId())) {
                ChangeLog changes = new ChangeLog();
                NameFactory NF = NameFactoryImpl.getInstance();
                root.addChildNodeEntry(NF.create("internal", "security"), node.getNodeId());
                changes.modified((ItemState)root);
                pMgr.store(changes);
            }
        }
        catch (NoSuchItemStateException e) {
            e.printStackTrace();
        }
        catch (ItemStateException e) {
            e.printStackTrace();
        }
    }
}

