/*
 * Decompiled with CFR 0.152.
 */
package com.sas.contentserver.commons;

public class SpecialNameChars {
    private static final char[] oldChars = new char[]{'[', ']', '\'', '\"', '*', '\u3000'};
    private static final char[] newChars = new char[]{'\uf05b', '\uf05d', '\uf027', '\uf022', '\uf042', '\uf020'};

    public static String encode(String name) {
        if (name == null || name.length() == 0) {
            return name;
        }
        if (SpecialNameChars.hasOldChars(name)) {
            for (int i = 0; i < newChars.length; ++i) {
                name = name.replace(oldChars[i], newChars[i]);
            }
        }
        return name;
    }

    public static String decode(String name) {
        if (name == null || name.length() == 0) {
            return name;
        }
        if (SpecialNameChars.hasNewChars(name)) {
            for (int i = 0; i < newChars.length; ++i) {
                name = name.replace(newChars[i], oldChars[i]);
            }
        }
        return name;
    }

    private static final boolean hasOldChars(String s) {
        for (int i = 0; i < oldChars.length; ++i) {
            if (s.indexOf(oldChars[i]) == -1) continue;
            return true;
        }
        return false;
    }

    private static final boolean hasNewChars(String s) {
        for (int i = 0; i < newChars.length; ++i) {
            if (s.indexOf(newChars[i]) == -1) continue;
            return true;
        }
        return false;
    }
}

