/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.reportrepository.proxy;

import com.sas.svcs.commons.webservice.client.ProxyHelper;
import com.sas.svcs.commons.webservice.client.SecurityTokenServiceClient;
import com.sas.svcs.commons.webservice.client.ServiceRegistryClient;
import com.sas.svcs.reportrepository.client.RepositoryFactoryServiceInterface;
import com.sas.svcs.reportrepository.client.domain.ClearCacheRepositoryFactoryServiceInterfaceRequestType;
import com.sas.svcs.reportrepository.client.domain.ExceptionType;
import com.sas.svcs.reportrepository.client.domain.GetCacheStatusRepositoryFactoryServiceInterfaceRequestType;
import com.sas.svcs.reportrepository.client.domain.GetCacheStatusRepositoryFactoryServiceInterfaceResponseType;
import com.sas.svcs.reportrepository.client.domain.GetReportRepositoriesRepositoryFactoryServiceInterfaceRequestType;
import com.sas.svcs.reportrepository.client.domain.GetReportRepositoryRepositoryFactoryServiceInterfaceRequestType;
import com.sas.svcs.reportrepository.client.domain.GetReportRepositoryRepositoryFactoryServiceInterfaceResponseType;
import com.sas.svcs.reportrepository.client.domain.ObjectFactory;
import com.sas.svcs.reportrepository.client.domain.ReposNameListType;
import com.sas.svcs.reportrepository.client.domain.RepositoryExceptionHolder;
import java.io.Serializable;
import java.util.List;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;

public class RepositoryFactoryServiceInterfaceProxy
implements Serializable,
RepositoryFactoryServiceInterface {
    private static final long serialVersionUID = 1L;
    private String url;
    private SecurityTokenServiceClient stsClient;

    public RepositoryFactoryServiceInterfaceProxy(String serviceRegistryUrl) {
        ServiceRegistryClient srClient = new ServiceRegistryClient(serviceRegistryUrl);
        srClient.obtainServices();
        this.url = srClient.getServiceURL("ReportRepositoryService");
    }

    public RepositoryFactoryServiceInterfaceProxy(String serviceUrl, SecurityTokenServiceClient stsClient) {
        this.url = serviceUrl;
        this.stsClient = stsClient;
    }

    public void setStsClient(SecurityTokenServiceClient stsClient) {
        this.stsClient = stsClient;
    }

    public void setServiceUrl(String serviceUrl) {
        this.url = serviceUrl;
    }

    public void clearCache() {
        String action = "http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2/RepositoryFactoryServiceInterface/clearCache";
        ClearCacheRepositoryFactoryServiceInterfaceRequestType arg = new ObjectFactory().createClearCacheRepositoryFactoryServiceInterfaceRequestType();
        JAXBElement argDoc = new ObjectFactory().createClearCacheRepositoryFactoryServiceInterfaceRequest(arg);
        ProxyHelper helper = new ProxyHelper("jaxbMarshaller", "com.sas.svcs.reportrepository.client.domain");
        helper.setSecurityTokenServiceClient(this.stsClient);
        helper.setSecurityPolicy("com/sas/svcs/commons/webservice/client/security/securityPolicyDigestClient.xml");
        Object retDoc = helper.call(this.url, action, (Object)argDoc);
        if (helper.getFault() != null) {
            if (helper.getFault() instanceof RuntimeException) {
                throw new RuntimeException(((RuntimeException)helper.getFault()).getMessage());
            }
            throw new RuntimeException("Unknown Exception thrown: " + helper.getFault().toString());
        }
    }

    public String getCacheStatus() {
        String action = "http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2/RepositoryFactoryServiceInterface/getCacheStatus";
        GetCacheStatusRepositoryFactoryServiceInterfaceRequestType arg = new ObjectFactory().createGetCacheStatusRepositoryFactoryServiceInterfaceRequestType();
        JAXBElement argDoc = new ObjectFactory().createGetCacheStatusRepositoryFactoryServiceInterfaceRequest(arg);
        ProxyHelper helper = new ProxyHelper("jaxbMarshaller", "com.sas.svcs.reportrepository.client.domain");
        helper.setSecurityTokenServiceClient(this.stsClient);
        helper.setSecurityPolicy("com/sas/svcs/commons/webservice/client/security/securityPolicyDigestClient.xml");
        Object retDoc = helper.call(this.url, action, (Object)argDoc);
        if (helper.getFault() == null) {
            JAXBElement retDocType = (JAXBElement)retDoc;
            GetCacheStatusRepositoryFactoryServiceInterfaceResponseType retType = (GetCacheStatusRepositoryFactoryServiceInterfaceResponseType)retDocType.getValue();
            String retArg = retType.getCacheStatus();
            return retArg;
        }
        if (helper.getFault() instanceof RuntimeException) {
            throw new RuntimeException(((RuntimeException)helper.getFault()).getMessage());
        }
        throw new RuntimeException("Unknown Exception thrown: " + helper.getFault().toString());
    }

    public String getReportRepository(String pathUrl) throws RepositoryExceptionHolder {
        String action = "http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2/RepositoryFactoryServiceInterface/getReportRepository";
        GetReportRepositoryRepositoryFactoryServiceInterfaceRequestType arg = new ObjectFactory().createGetReportRepositoryRepositoryFactoryServiceInterfaceRequestType();
        arg.setPathUrl(pathUrl);
        JAXBElement argDoc = new ObjectFactory().createGetReportRepositoryRepositoryFactoryServiceInterfaceRequest(arg);
        ProxyHelper helper = new ProxyHelper("jaxbMarshaller", "com.sas.svcs.reportrepository.client.domain");
        helper.setSecurityTokenServiceClient(this.stsClient);
        helper.setSecurityPolicy("com/sas/svcs/commons/webservice/client/security/securityPolicyDigestClient.xml");
        Object retDoc = helper.call(this.url, action, (Object)argDoc);
        if (helper.getFault() == null) {
            JAXBElement retDocType = (JAXBElement)retDoc;
            GetReportRepositoryRepositoryFactoryServiceInterfaceResponseType retType = (GetReportRepositoryRepositoryFactoryServiceInterfaceResponseType)retDocType.getValue();
            String retArg = retType.getReposName();
            return retArg;
        }
        if (helper.getFault() instanceof JAXBElement && ((JAXBElement)helper.getFault()).getName().equals(new QName("http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2", "RepositoryException"))) {
            JAXBElement exDoc = (JAXBElement)helper.getFault();
            ExceptionType ex = (ExceptionType)exDoc.getValue();
            RepositoryExceptionHolder e = new RepositoryExceptionHolder();
            e.setExceptionType(ex);
            throw e;
        }
        if (helper.getFault() instanceof RuntimeException) {
            throw new RuntimeException(((RuntimeException)helper.getFault()).getMessage());
        }
        throw new RuntimeException("Unknown Exception thrown: " + helper.getFault().toString());
    }

    public List getReportRepositories() throws RepositoryExceptionHolder {
        String action = "http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2/RepositoryFactoryServiceInterface/getReportRepositories";
        GetReportRepositoriesRepositoryFactoryServiceInterfaceRequestType arg = new ObjectFactory().createGetReportRepositoriesRepositoryFactoryServiceInterfaceRequestType();
        JAXBElement argDoc = new ObjectFactory().createGetReportRepositoriesRepositoryFactoryServiceInterfaceRequest(arg);
        ProxyHelper helper = new ProxyHelper("jaxbMarshaller", "com.sas.svcs.reportrepository.client.domain");
        helper.setSecurityTokenServiceClient(this.stsClient);
        helper.setSecurityPolicy("com/sas/svcs/commons/webservice/client/security/securityPolicyDigestClient.xml");
        Object retDoc = helper.call(this.url, action, (Object)argDoc);
        if (helper.getFault() == null) {
            JAXBElement retDocType = (JAXBElement)retDoc;
            ReposNameListType retType = (ReposNameListType)retDocType.getValue();
            List retArg = retType.getReposName();
            return retArg;
        }
        if (helper.getFault() instanceof JAXBElement && ((JAXBElement)helper.getFault()).getName().equals(new QName("http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2", "RepositoryException"))) {
            JAXBElement exDoc = (JAXBElement)helper.getFault();
            ExceptionType ex = (ExceptionType)exDoc.getValue();
            RepositoryExceptionHolder e = new RepositoryExceptionHolder();
            e.setExceptionType(ex);
            throw e;
        }
        if (helper.getFault() instanceof RuntimeException) {
            throw new RuntimeException(((RuntimeException)helper.getFault()).getMessage());
        }
        throw new RuntimeException("Unknown Exception thrown: " + helper.getFault().toString());
    }
}

