/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.reportrepository.proxy;

import com.sas.svcs.commons.webservice.client.ProxyHelper;
import com.sas.svcs.commons.webservice.client.SecurityTokenServiceClient;
import com.sas.svcs.commons.webservice.client.ServiceRegistryClient;
import com.sas.svcs.reportrepository.client.CacheSetServiceInterface;
import com.sas.svcs.reportrepository.client.domain.CacheNameListType;
import com.sas.svcs.reportrepository.client.domain.CreateCacheCacheSetServiceInterfaceRequestType;
import com.sas.svcs.reportrepository.client.domain.ExceptionType;
import com.sas.svcs.reportrepository.client.domain.ExistsCacheCacheSetServiceInterfaceRequestType;
import com.sas.svcs.reportrepository.client.domain.ExistsCacheCacheSetServiceInterfaceResponseType;
import com.sas.svcs.reportrepository.client.domain.ListCachesCacheSetServiceInterfaceRequestType;
import com.sas.svcs.reportrepository.client.domain.ObjectFactory;
import com.sas.svcs.reportrepository.client.domain.RepositoryDuplicateNameExceptionHolder;
import com.sas.svcs.reportrepository.client.domain.RepositoryExceptionHolder;
import com.sas.svcs.reportrepository.client.domain.RepositoryIllegalNameExceptionHolder;
import com.sas.svcs.reportrepository.client.domain.RepositoryLockedExceptionHolder;
import java.io.Serializable;
import java.util.List;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;

public class CacheSetServiceInterfaceProxy
implements Serializable,
CacheSetServiceInterface {
    private static final long serialVersionUID = 1L;
    private String url;
    private SecurityTokenServiceClient stsClient;

    public CacheSetServiceInterfaceProxy(String serviceRegistryUrl) {
        ServiceRegistryClient srClient = new ServiceRegistryClient(serviceRegistryUrl);
        srClient.obtainServices();
        this.url = srClient.getServiceURL("ReportRepositoryService");
    }

    public CacheSetServiceInterfaceProxy(String serviceUrl, SecurityTokenServiceClient stsClient) {
        this.url = serviceUrl;
        this.stsClient = stsClient;
    }

    public void setStsClient(SecurityTokenServiceClient stsClient) {
        this.stsClient = stsClient;
    }

    public void setServiceUrl(String serviceUrl) {
        this.url = serviceUrl;
    }

    public void createCache(String entryPathUrl, String cacheName) throws RepositoryIllegalNameExceptionHolder, RepositoryLockedExceptionHolder, RepositoryDuplicateNameExceptionHolder, RepositoryExceptionHolder {
        String action = "http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2/CacheSetServiceInterface/createCache";
        CreateCacheCacheSetServiceInterfaceRequestType arg = new ObjectFactory().createCreateCacheCacheSetServiceInterfaceRequestType();
        arg.setEntryPathUrl(entryPathUrl);
        arg.setCacheName(cacheName);
        JAXBElement argDoc = new ObjectFactory().createCreateCacheCacheSetServiceInterfaceRequest(arg);
        ProxyHelper helper = new ProxyHelper("jaxbMarshaller", "com.sas.svcs.reportrepository.client.domain");
        helper.setSecurityTokenServiceClient(this.stsClient);
        helper.setSecurityPolicy("com/sas/svcs/commons/webservice/client/security/securityPolicyDigestClient.xml");
        Object retDoc = helper.call(this.url, action, (Object)argDoc);
        if (helper.getFault() != null) {
            if (helper.getFault() instanceof JAXBElement && ((JAXBElement)helper.getFault()).getName().equals(new QName("http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2", "RepositoryIllegalNameException"))) {
                JAXBElement exDoc = (JAXBElement)helper.getFault();
                ExceptionType ex = (ExceptionType)exDoc.getValue();
                RepositoryIllegalNameExceptionHolder e = new RepositoryIllegalNameExceptionHolder();
                e.setExceptionType(ex);
                throw e;
            }
            if (helper.getFault() instanceof JAXBElement && ((JAXBElement)helper.getFault()).getName().equals(new QName("http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2", "RepositoryLockedException"))) {
                JAXBElement exDoc = (JAXBElement)helper.getFault();
                ExceptionType ex = (ExceptionType)exDoc.getValue();
                RepositoryLockedExceptionHolder e = new RepositoryLockedExceptionHolder();
                e.setExceptionType(ex);
                throw e;
            }
            if (helper.getFault() instanceof JAXBElement && ((JAXBElement)helper.getFault()).getName().equals(new QName("http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2", "RepositoryDuplicateNameException"))) {
                JAXBElement exDoc = (JAXBElement)helper.getFault();
                ExceptionType ex = (ExceptionType)exDoc.getValue();
                RepositoryDuplicateNameExceptionHolder e = new RepositoryDuplicateNameExceptionHolder();
                e.setExceptionType(ex);
                throw e;
            }
            if (helper.getFault() instanceof JAXBElement && ((JAXBElement)helper.getFault()).getName().equals(new QName("http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2", "RepositoryException"))) {
                JAXBElement exDoc = (JAXBElement)helper.getFault();
                ExceptionType ex = (ExceptionType)exDoc.getValue();
                RepositoryExceptionHolder e = new RepositoryExceptionHolder();
                e.setExceptionType(ex);
                throw e;
            }
            if (helper.getFault() instanceof RuntimeException) {
                throw new RuntimeException(((RuntimeException)helper.getFault()).getMessage());
            }
            throw new RuntimeException("Unknown Exception thrown: " + helper.getFault().toString());
        }
    }

    public List listCaches(String entryPathUrl) throws RepositoryExceptionHolder {
        String action = "http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2/CacheSetServiceInterface/listCaches";
        ListCachesCacheSetServiceInterfaceRequestType arg = new ObjectFactory().createListCachesCacheSetServiceInterfaceRequestType();
        arg.setEntryPathUrl(entryPathUrl);
        JAXBElement argDoc = new ObjectFactory().createListCachesCacheSetServiceInterfaceRequest(arg);
        ProxyHelper helper = new ProxyHelper("jaxbMarshaller", "com.sas.svcs.reportrepository.client.domain");
        helper.setSecurityTokenServiceClient(this.stsClient);
        helper.setSecurityPolicy("com/sas/svcs/commons/webservice/client/security/securityPolicyDigestClient.xml");
        Object retDoc = helper.call(this.url, action, (Object)argDoc);
        if (helper.getFault() == null) {
            JAXBElement retDocType = (JAXBElement)retDoc;
            CacheNameListType retType = (CacheNameListType)retDocType.getValue();
            List retArg = retType.getCacheName();
            return retArg;
        }
        if (helper.getFault() instanceof JAXBElement && ((JAXBElement)helper.getFault()).getName().equals(new QName("http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2", "RepositoryException"))) {
            JAXBElement exDoc = (JAXBElement)helper.getFault();
            ExceptionType ex = (ExceptionType)exDoc.getValue();
            RepositoryExceptionHolder e = new RepositoryExceptionHolder();
            e.setExceptionType(ex);
            throw e;
        }
        if (helper.getFault() instanceof RuntimeException) {
            throw new RuntimeException(((RuntimeException)helper.getFault()).getMessage());
        }
        throw new RuntimeException("Unknown Exception thrown: " + helper.getFault().toString());
    }

    public boolean existsCache(String entryPathUrl, String cacheName) throws RepositoryExceptionHolder {
        String action = "http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2/CacheSetServiceInterface/existsCache";
        ExistsCacheCacheSetServiceInterfaceRequestType arg = new ObjectFactory().createExistsCacheCacheSetServiceInterfaceRequestType();
        arg.setEntryPathUrl(entryPathUrl);
        arg.setCacheName(cacheName);
        JAXBElement argDoc = new ObjectFactory().createExistsCacheCacheSetServiceInterfaceRequest(arg);
        ProxyHelper helper = new ProxyHelper("jaxbMarshaller", "com.sas.svcs.reportrepository.client.domain");
        helper.setSecurityTokenServiceClient(this.stsClient);
        helper.setSecurityPolicy("com/sas/svcs/commons/webservice/client/security/securityPolicyDigestClient.xml");
        Object retDoc = helper.call(this.url, action, (Object)argDoc);
        if (helper.getFault() == null) {
            JAXBElement retDocType = (JAXBElement)retDoc;
            ExistsCacheCacheSetServiceInterfaceResponseType retType = (ExistsCacheCacheSetServiceInterfaceResponseType)retDocType.getValue();
            boolean retArg = retType.isCacheNameExists();
            return retArg;
        }
        if (helper.getFault() instanceof JAXBElement && ((JAXBElement)helper.getFault()).getName().equals(new QName("http://www.sas.com/xml/schema/sas-svcs/reportrepository-9.2", "RepositoryException"))) {
            JAXBElement exDoc = (JAXBElement)helper.getFault();
            ExceptionType ex = (ExceptionType)exDoc.getValue();
            RepositoryExceptionHolder e = new RepositoryExceptionHolder();
            e.setExceptionType(ex);
            throw e;
        }
        if (helper.getFault() instanceof RuntimeException) {
            throw new RuntimeException(((RuntimeException)helper.getFault()).getMessage());
        }
        throw new RuntimeException("Unknown Exception thrown: " + helper.getFault().toString());
    }
}

