/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.util;

import com.sas.services.util.WaitPolicy;

public class Waiter {
    private WaitPolicy.TYPE _type;
    private int _initialWait;
    private int _waitIncrement;
    private int _minimumWait;
    private int _maximumWait;
    private long _totalWait;
    private long _totalTimeWaited;
    private long _nextWait;

    public Waiter(WaitPolicy waitPolicy) {
        this._type = waitPolicy.getType();
        this._initialWait = waitPolicy.getInitialWait();
        this._waitIncrement = waitPolicy.getWaitIncrement();
        this._minimumWait = waitPolicy.getMinimumWait();
        this._maximumWait = waitPolicy.getMaximumWait();
        this._totalWait = waitPolicy.getTotalWait();
        this._totalTimeWaited = 0L;
        this._nextWait = this._initialWait;
    }

    public boolean sleep() throws InterruptedException {
        if (this._type == WaitPolicy.TYPE.NONE) {
            return false;
        }
        if (this._type == WaitPolicy.TYPE.FINITE) {
            if (this._totalTimeWaited >= this._totalWait) {
                return false;
            }
            if (this._totalTimeWaited + this._nextWait > this._totalWait) {
                this._nextWait = this._totalWait - this._totalTimeWaited;
            }
        }
        Thread.sleep(this._nextWait);
        this._totalTimeWaited += this._nextWait;
        this._nextWait += (long)this._waitIncrement;
        if (this._nextWait > (long)this._maximumWait) {
            this._nextWait = this._maximumWait;
        }
        if (this._nextWait < (long)this._minimumWait) {
            this._nextWait = this._minimumWait;
        }
        return true;
    }

    public long getTotalTimeWaited() {
        return this._totalTimeWaited;
    }
}

