/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.util;

import com.sas.services.ServiceException;
import com.sas.services.util.RB;
import com.sas.text.Message;

public class WaitPolicy {
    public static final String INITIAL_WAIT_KEY = "InitialWait";
    public static final int INITIAL_WAIT_VALUE_N = 1000;
    public static final String INITIAL_WAIT_VALUE_S = "1000";
    public static final String WAIT_INCREMENT_KEY = "WaitIncrement";
    public static final int WAIT_INCREMENT_VALUE_N = 1000;
    public static final String WAIT_INCREMENT_VALUE_S = "1000";
    public static final String MINIMUM_WAIT_KEY = "MinimumWait";
    public static final int MINIMUM_WAIT_VALUE_N = 1000;
    public static final String MINIMUM_WAIT_VALUE_S = "1000";
    public static final String MAXIMUM_WAIT_KEY = "MaximumWait";
    public static final int MAXIMUM_WAIT_VALUE_N = 15000;
    public static final String MAXIMUM_WAIT_VALUE_S = "15000";
    public static final String TOTAL_WAIT_KEY = "TotalWait";
    public static final long TOTAL_WAIT_VALUE_N = 900000L;
    public static final String TOTAL_WAIT_VALUE_S = "900000";
    private TYPE _type;
    private int _initialWait;
    private int _waitIncrement;
    private int _minimumWait;
    private int _maximumWait;
    private long _totalWait;

    public WaitPolicy(TYPE type) throws ServiceException {
        this(type, 1000, 1000, 1000, 15000, 900000L);
    }

    public WaitPolicy(TYPE type, int initialWait, int waitIncrement, int minimumWait, int maximumWait, long totalWait) throws ServiceException {
        this._type = type;
        if (this._type == TYPE.NONE) {
            return;
        }
        if (initialWait <= 0) {
            throw new ServiceException(Message.format((String)RB.getStringResource("WaitPolicy.PosIntReqd.ex.fmt.txt"), (Object)"initialWait", (Object)Integer.toString(initialWait)));
        }
        this._initialWait = initialWait;
        this._waitIncrement = waitIncrement;
        if (minimumWait <= 0) {
            throw new ServiceException(Message.format((String)RB.getStringResource("WaitPolicy.PosIntReqd.ex.fmt.txt"), (Object)"minimumWait", (Object)Integer.toString(minimumWait)));
        }
        this._minimumWait = minimumWait;
        if (maximumWait <= 0) {
            throw new ServiceException(Message.format((String)RB.getStringResource("WaitPolicy.PosIntReqd.ex.fmt.txt"), (Object)"maximumWait", (Object)Integer.toString(maximumWait)));
        }
        this._maximumWait = maximumWait;
        if (maximumWait < minimumWait) {
            throw new ServiceException(Message.format((String)RB.getStringResource("WaitPolicy.MaxLessThanMin.ex.fmt.txt"), (Object)Integer.toString(maximumWait), (Object)Integer.toString(minimumWait)));
        }
        if (initialWait < minimumWait) {
            throw new ServiceException(Message.format((String)RB.getStringResource("WaitPolicy.InitLessMin.ex.fmt.txt"), (Object)Integer.toString(initialWait), (Object)Integer.toString(minimumWait)));
        }
        if (initialWait > maximumWait) {
            throw new ServiceException(Message.format((String)RB.getStringResource("WaitPolicy.InitGrtrMax.ex.fmt.txt"), (Object)Integer.toString(initialWait), (Object)Integer.toString(maximumWait)));
        }
        if (type == TYPE.FINITE) {
            if (totalWait <= 0L) {
                throw new ServiceException(Message.format((String)RB.getStringResource("WaitPolicy.PosLongReqd.ex.fmt.txt"), (Object)"totalWait", (Object)Long.toString(totalWait)));
            }
            this._totalWait = totalWait;
        }
    }

    public TYPE getType() {
        return this._type;
    }

    public int getInitialWait() {
        return this._initialWait;
    }

    public int getWaitIncrement() {
        return this._waitIncrement;
    }

    public int getMinimumWait() {
        return this._minimumWait;
    }

    public int getMaximumWait() {
        return this._maximumWait;
    }

    public long getTotalWait() {
        return this._totalWait;
    }

    public static WaitPolicy getDefaultWaitPolicy(TYPE type, String prefix) throws ServiceException {
        long totalWait;
        int maximumWait;
        int minimumWait;
        int waitIncrement;
        int initialWait;
        if (type == TYPE.NONE) {
            return new WaitPolicy(type);
        }
        prefix = prefix == null || prefix.length() == 0 ? "" : prefix + ".";
        String key = prefix + INITIAL_WAIT_KEY;
        String propVal = System.getProperty(key, "1000");
        try {
            initialWait = Integer.parseInt(propVal);
        }
        catch (Exception e) {
            throw new ServiceException(e, Message.format((String)RB.getStringResource("WaitPolicy.PosIntReqd.ex.fmt.txt"), (Object)key, (Object)propVal));
        }
        key = prefix + WAIT_INCREMENT_KEY;
        propVal = System.getProperty(key, "1000");
        try {
            waitIncrement = Integer.parseInt(propVal);
        }
        catch (Exception e) {
            throw new ServiceException(e, Message.format((String)RB.getStringResource("WaitPolicy.IntReqd.ex.fmt.txt"), (Object)key, (Object)propVal));
        }
        key = prefix + MINIMUM_WAIT_KEY;
        propVal = System.getProperty(key, "1000");
        try {
            minimumWait = Integer.parseInt(propVal);
        }
        catch (Exception e) {
            throw new ServiceException(e, Message.format((String)RB.getStringResource("WaitPolicy.PosIntReqd.ex.fmt.txt"), (Object)key, (Object)propVal));
        }
        key = prefix + MAXIMUM_WAIT_KEY;
        propVal = System.getProperty(key, MAXIMUM_WAIT_VALUE_S);
        try {
            maximumWait = Integer.parseInt(propVal);
        }
        catch (Exception e) {
            throw new ServiceException(e, Message.format((String)RB.getStringResource("WaitPolicy.PosIntReqd.ex.fmt.txt"), (Object)key, (Object)propVal));
        }
        if (type == TYPE.FINITE) {
            key = prefix + TOTAL_WAIT_KEY;
            propVal = System.getProperty(key, TOTAL_WAIT_VALUE_S);
            try {
                totalWait = Long.parseLong(propVal);
            }
            catch (Exception e) {
                throw new ServiceException(e, Message.format((String)RB.getStringResource("WaitPolicy.PosLongReqd.ex.fmt.txt"), (Object)key, (Object)propVal));
            }
        } else {
            totalWait = 900000L;
        }
        return new WaitPolicy(type, initialWait, waitIncrement, minimumWait, maximumWait, totalWait);
    }

    public static enum TYPE {
        NONE,
        FINITE,
        INFINITE;

    }
}

