/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.util;

import com.sas.codepolicy.SASScope;
import com.sas.services.util.RB;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SASScope
public class ResourceFinder {
    Logger logger = LogManager.getLogger((String)"com.sas.services.util.ResourceFinder");

    public URL[] findResourcesInClassPath(ClassLoader cl, String name) {
        long start = System.currentTimeMillis();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Starting search of class loader for: " + name);
        }
        ArrayList<URL> urlList = new ArrayList<URL>(10);
        URL[] clUrls = null;
        clUrls = this.getURLsFromURLClassLoader(cl);
        if (clUrls == null) {
            clUrls = this.getURLsUsingGetPaths(cl);
        }
        if (clUrls == null) {
            clUrls = this.getURLsUsingGetClassPath(cl);
        }
        if (clUrls != null) {
            for (int i = 0; i < clUrls.length; ++i) {
                URL nextUrl = clUrls[i];
                String file = nextUrl.getFile();
                if (file.endsWith("/")) {
                    String path = nextUrl.getPath();
                    URL[] theseUrls = this.findResourcesInFile(new File(path), name);
                    if (theseUrls == null) continue;
                    for (int j = 0; j < theseUrls.length; ++j) {
                        urlList.add(theseUrls[j]);
                    }
                    continue;
                }
                URL[] theseUrls = this.findResourcesInJar(nextUrl, name);
                if (theseUrls == null) continue;
                for (int j = 0; j < theseUrls.length; ++j) {
                    urlList.add(theseUrls[j]);
                }
            }
        } else {
            this.logger.warn(RB.getStringResource("ResourceFinder.nopath.ex.txt"));
        }
        long end = System.currentTimeMillis();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Finding resources took: " + (end - start) + " milliseconds.");
        }
        URL[] urls = null;
        urls = new URL[urlList.size()];
        urlList.toArray(urls);
        return urls;
    }

    private URL[] getURLsFromURLClassLoader(ClassLoader cl) {
        if (cl instanceof URLClassLoader) {
            URL[] urls = ((URLClassLoader)cl).getURLs();
            if (this.logger.isDebugEnabled()) {
                for (int i = 0; i < urls.length; ++i) {
                    this.logger.debug("classpath URL: " + urls[i].toString());
                }
            }
            return ((URLClassLoader)cl).getURLs();
        }
        return null;
    }

    private URL[] getURLsUsingGetPaths(ClassLoader cl) {
        URL[] clUrls = null;
        try {
            Method method = cl.getClass().getMethod("getPaths", null);
            try {
                String[] paths = (String[])method.invoke((Object)cl, (Object[])null);
                clUrls = new URL[paths.length];
                for (int i = 0; i < paths.length; ++i) {
                    File file = new File(paths[i]);
                    clUrls[i] = file.toURL();
                }
            }
            catch (MalformedURLException ex) {
                ex.printStackTrace(System.out);
            }
            catch (IllegalAccessException ex) {
                ex.printStackTrace(System.out);
            }
            catch (InvocationTargetException ex) {
                Throwable t = ex.getCause();
                t.printStackTrace(System.out);
            }
        }
        catch (NoSuchMethodException method) {
            // empty catch block
        }
        if (this.logger.isDebugEnabled() && clUrls != null) {
            for (int i = 0; i < clUrls.length; ++i) {
                this.logger.debug("classpath URL: " + clUrls[i].toString());
            }
        }
        return clUrls;
    }

    private URL[] getURLsUsingGetClassPath(ClassLoader cl) {
        URL[] clUrls = null;
        try {
            Method method = cl.getClass().getMethod("getClassPath", null);
            try {
                String pathString = (String)method.invoke((Object)cl, (Object[])null);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("classpath = " + pathString);
                }
                StringTokenizer st = new StringTokenizer(pathString, ";", false);
                clUrls = new URL[st.countTokens()];
                int i = 0;
                while (st.hasMoreTokens()) {
                    String nextToken = st.nextToken();
                    if (nextToken.indexOf("extract") <= -1) continue;
                    File file = new File(nextToken);
                    String path = file.getParent();
                    File[] kids = (file = new File(path)).listFiles();
                    if (kids != null) {
                        clUrls = new URL[kids.length];
                        for (i = 0; i < kids.length; ++i) {
                            clUrls[i] = kids[i].toURL();
                        }
                    }
                    break;
                }
            }
            catch (MalformedURLException exc) {
                exc.printStackTrace(System.out);
            }
            catch (IllegalAccessException exc) {
                exc.printStackTrace(System.out);
            }
            catch (InvocationTargetException exc) {
                Throwable t = exc.getCause();
                t.printStackTrace(System.out);
            }
        }
        catch (NoSuchMethodException method) {
            // empty catch block
        }
        if (this.logger.isDebugEnabled() && clUrls != null) {
            for (int i = 0; i < clUrls.length; ++i) {
                this.logger.debug("classpath URL: " + clUrls[i].toString());
            }
        }
        return clUrls;
    }

    public URL[] findResourcesInFile(File path, String name) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Beginning search of " + path + " for " + name);
        }
        Pattern pattern = Pattern.compile(name);
        return this.patternFindFile(path, pattern);
    }

    private URL[] patternFindFile(File path, Pattern name) {
        URL[] urls = null;
        ArrayList<URL> urlList = new ArrayList<URL>(10);
        if (path.isDirectory()) {
            File[] children = path.listFiles();
            for (int i = 0; i < children.length; ++i) {
                Matcher m;
                File nextChild = children[i];
                if (nextChild.isDirectory()) {
                    URL[] theseUrls = this.patternFindFile(nextChild, name);
                    if (theseUrls == null) continue;
                    for (int j = 0; j < theseUrls.length; ++j) {
                        urlList.add(theseUrls[j]);
                    }
                    continue;
                }
                String childName = nextChild.getName();
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Testing: " + childName);
                }
                if (!(m = name.matcher(childName)).matches()) continue;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Found match " + nextChild);
                }
                try {
                    urlList.add(nextChild.toURL());
                    continue;
                }
                catch (MalformedURLException ex) {
                    ex.printStackTrace(System.out);
                }
            }
        }
        if (urlList.size() > 0) {
            urls = new URL[urlList.size()];
            urlList.toArray(urls);
        }
        return urls;
    }

    public URL[] findResourcesInJar(URL jarUrl, String name) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Beginning search of " + jarUrl + " for " + name);
        }
        Pattern pattern = Pattern.compile(name);
        return this.patternFindJar(jarUrl, pattern);
    }

    private URL[] patternFindJar(URL jarUrl, Pattern name) {
        URL[] urls = null;
        ArrayList<URL> urlList = new ArrayList<URL>(10);
        try {
            URL context = new URL("jar:" + jarUrl.toString() + "!/");
            String filename = URLDecoder.decode(jarUrl.getFile(), "UTF-8");
            JarFile jf = null;
            try {
                jf = new JarFile(filename);
            }
            catch (ZipException ex) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Exception trying to process file: " + jarUrl);
                }
                return null;
            }
            Enumeration<JarEntry> enu = jf.entries();
            while (enu.hasMoreElements()) {
                ZipEntry entry = enu.nextElement();
                String entryName = entry.getName();
                Matcher m = name.matcher(entryName);
                if (!m.matches()) continue;
                URL newURL = new URL(context, entry.getName());
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Found match: " + newURL);
                }
                urlList.add(newURL);
            }
        }
        catch (MalformedURLException ex) {
            ex.printStackTrace(System.out);
        }
        catch (IOException ex) {
            ex.printStackTrace(System.out);
        }
        if (urlList.size() > 0) {
            urls = new URL[urlList.size()];
            urlList.toArray(urls);
        }
        return urls;
    }
}

