/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.util;

import com.sas.codepolicy.SASScope;
import com.sas.services.security.LoginCallbackHandler;
import com.sas.services.user.SimpleUserIdentity;
import com.sas.services.util.RB;
import com.sas.text.Message;
import java.util.HashMap;
import java.util.ResourceBundle;
import javax.management.remote.JMXAuthenticator;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;

@SASScope
public class JMXOMRAuthenticator
implements JMXAuthenticator {
    @Override
    public Subject authenticate(Object credentials) {
        int idx;
        String msg;
        Subject subject = null;
        if (credentials == null) {
            msg = RB.getStringResource("JMXOMRAuthenticator.requiredCredentials.ex.txt");
            this.failure(msg);
        }
        if (!(credentials instanceof String[])) {
            msg = RB.getStringResource("JMXOMRAuthenticator.requiredCredentials2.ex.txt");
            this.failure(msg);
        }
        String[] credentialsArray = (String[])credentials;
        String username = credentialsArray[0].trim();
        String password = credentialsArray[1];
        String domain = null;
        if (username.startsWith("[@") && (idx = username.indexOf(93)) != -1) {
            domain = username.substring(2, idx).trim();
            username = username.substring(idx + 1, username.length()).trim();
        }
        SimpleUserIdentity ident = new SimpleUserIdentity(username, password, domain);
        LoginCallbackHandler handler = new LoginCallbackHandler(null, ident, new HashMap());
        LoginContext lc = null;
        try {
            lc = new LoginContext("PFS", handler);
            lc.login();
        }
        catch (LoginException le) {
            String msg2 = le.getMessage();
            this.failure(msg2);
        }
        subject = lc.getSubject();
        return subject;
    }

    private void failure(String msg) throws SecurityException {
        String failure = Message.format((ResourceBundle)RB.getResources(), (String)"JMXOMRAuthenticator.authenticate.failed.ex.fmt.txt", (Object)msg);
        throw new SecurityException(failure);
    }
}

