/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.util;

import com.sas.codepolicy.SASScope;
import com.sas.services.util.ExceptionCallbackInterface;
import com.sas.services.util.ExceptionListenerInterface;
import java.util.HashSet;
import java.util.Set;

@SASScope
public class ExceptionCallback
implements ExceptionCallbackInterface {
    private Set _exceptionListeners = null;

    @Override
    public void addExceptionListener(ExceptionListenerInterface l) {
        if (l == null) {
            return;
        }
        if (this._exceptionListeners == null) {
            this._exceptionListeners = new HashSet();
        }
        this._exceptionListeners.add(l);
    }

    @Override
    public void removeExceptionListener(ExceptionListenerInterface l) {
        if (l == null || this._exceptionListeners == null) {
            return;
        }
        this._exceptionListeners.remove(l);
    }

    @Override
    public void sendException(Exception e) {
        if (this._exceptionListeners == null || this._exceptionListeners.size() == 0) {
            e.printStackTrace();
            return;
        }
        for (ExceptionListenerInterface l : this._exceptionListeners) {
            l.exceptionOccurred(e, this);
        }
    }
}

