/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.user;

import com.sas.meta.SASOMI.IOMI;
import com.sas.metadata.remote.MdCallbackCancelledException;
import com.sas.metadata.remote.MdCredential;
import com.sas.metadata.remote.MdException;
import com.sas.net.ssl.SSLRMISocketFactories;
import com.sas.services.ServiceAttributeInterface;
import com.sas.services.ServiceException;
import com.sas.services.connection.Cluster;
import com.sas.services.connection.ConnectionFactoryConfiguration;
import com.sas.services.connection.ConnectionFactoryException;
import com.sas.services.connection.ConnectionFactoryInterface;
import com.sas.services.connection.ConnectionFactoryManager;
import com.sas.services.connection.ConnectionInterface;
import com.sas.services.connection.ConnectionResources;
import com.sas.services.connection.Credential;
import com.sas.services.connection.InvalidCredentialsException;
import com.sas.services.connection.ManualConnectionFactoryConfiguration;
import com.sas.services.connection.MetadataClusterUtil;
import com.sas.services.connection.PasswordCredential;
import com.sas.services.connection.SecurityPackageCredential;
import com.sas.services.connection.TrustedPeerCredential;
import com.sas.services.deployment.Environment;
import com.sas.services.discovery.DiscoveryService;
import com.sas.services.discovery.LocalDiscoveryServiceInterface;
import com.sas.services.discovery.ServiceComponentAttribute;
import com.sas.services.discovery.ServiceTemplate;
import com.sas.services.information.Filter;
import com.sas.services.information.FilterComponent;
import com.sas.services.information.InformationServiceInterface;
import com.sas.services.information.MetadataServerInterface;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.OMIServer;
import com.sas.services.information.RepositoryDef;
import com.sas.services.information.RepositoryGroup;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.ServerDef;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.IdentityInterface;
import com.sas.services.information.metadata.IdentityMembershipInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.PersonInterface;
import com.sas.services.information.metadata.SoftwareComponentInterface;
import com.sas.services.security.ApplicationAuthorization;
import com.sas.services.security.AuthenticationServiceInterface;
import com.sas.services.security.LoginCallbackHandler;
import com.sas.services.security.RemoteCallbackHandler;
import com.sas.services.security.RemoteDomainCallback;
import com.sas.services.security.RemoteNameCallback;
import com.sas.services.security.RemotePasswordCallback;
import com.sas.services.security.login.OMILoginModule;
import com.sas.services.security.login.OMIServerPrincipal;
import com.sas.services.security.login.PFSCredential;
import com.sas.services.security.login.PFSPrincipalInterface;
import com.sas.services.security.login.PFSRolePrincipal;
import com.sas.services.session.SessionContextInterface;
import com.sas.services.user.CallbackCancelledException;
import com.sas.services.user.CredentialPermission;
import com.sas.services.user.GeneratedUserIdentity;
import com.sas.services.user.GlobalProfile;
import com.sas.services.user.GlobalProfileInterface;
import com.sas.services.user.IdentityChangeEvent;
import com.sas.services.user.NonPersonAuthenticationException;
import com.sas.services.user.Profile;
import com.sas.services.user.ProfileDomain;
import com.sas.services.user.ProfileInterface;
import com.sas.services.user.RB;
import com.sas.services.user.SimpleUserIdentity;
import com.sas.services.user.UserContextInterface;
import com.sas.services.user.UserIdentityInterface;
import com.sas.services.user.UserIdentityListener;
import com.sas.services.user.UserServiceInterface;
import com.sas.text.Message;
import com.sas.util.ChainedException;
import com.sas.util.SasPasswordEncodingException;
import com.sas.util.SasPasswordString;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.dgc.VMID;
import java.rmi.server.UnicastRemoteObject;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Permission;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.omg.CORBA.StringHolder;

public class UserContext
extends UnicastRemoteObject
implements UserContextInterface,
Serializable {
    private static final long serialVersionUID = 898273214558577385L;
    private final String MONITOR_LABEL_TYPE;
    private final String MONITOR_LABEL_STATUS;
    private final String MONITOR_LABEL_UID;
    private final String MONITOR_LABEL_DOMAIN;
    private final String MONITOR_LABEL_CLIENT;
    private final String MONITOR_LABEL_APP;
    private final String MONITOR_LABEL_MESSAGE;
    private final String MONITOR_VALUE_LOGOUT;
    private final String MONITOR_VALUE_SUCCESS;
    private static final String LOGGING_CONTEXT = "com.sas.services.user.UserContext";
    private static final String EX_MSG_CONNECTIONABORT = "connection abort";
    private static final String EX_MSG_EOFEXCEPTION = "EOFException";
    private static final String EX_MSG_SOCKETEXCEPTION = "SocketException";
    private static final int REPOSITORY_LIST_INIT = 5;
    private static final int SERVER_LIST_INIT = 5;
    private static final int LOGLISTINIT = 8;
    private static UserServiceInterface _userService = null;
    private static final String PROFILE_GLOBAL = "global";
    private static final int SHARED_RESOURCE_MAP_INIT = 2;
    private static long contextNum = 0L;
    public static final String MIDTIERINTERNAL_DOMAIN = "MidtierInternal";
    private ConnectionInterface cx;
    private final int[] cxGate;
    private final List<WeakReference<GeneratedUserIdentity>> _generatedCredentials;
    private List<Throwable> _exceptions;
    private String _name;
    private String _key;
    private IdentityInterface _person;
    private final List<UserIdentityInterface> _identities;
    private final List<UserIdentityListener> _identityListeners;
    private ProfileInterface _profile;
    private List<RepositoryInterface> _repositories;
    private final List<ServerInterface> _servers;
    private LoginContext _loginContext;
    private LoginCallbackHandler _handler;
    private RemoteCallbackHandler _challenger;
    private SessionContextInterface _session;
    private Logger _logger;
    private boolean _isDestroyed;
    private String _uniqueId;
    private String _description;
    private long _authTime;
    private final Map<String, Object> _sharedResources;
    private final long _myContextNum;
    private Subject _mySubject;
    private String _authReposName;
    private String _authServerName;
    private String _loginConfigAppName;
    private String _idpMechanism;
    private String _userFQID;
    private Map<String, RepositoryGroup> _reposGroups;
    private String _clientSource;
    private String _appSource;
    private List<String> _roleList;
    private List<String> _groupList;
    private final Map<String, List<ApplicationAuthorization>> _actionMap;
    private List<String> _domainList;
    private boolean _gotAllDomains;
    private final Object challengeMutex;
    private String _resolvedId;
    private boolean _isInternalUser;
    private Locale _locale;
    private List<IdentityMembershipInterface> memberships;
    private boolean _iSetApplicationName;
    private static final int IDENTITIES_LIST_INIT = 4;
    private static final int EXCEPTION_LIST_INIT = 2;
    private static final String TOSTRING_PREFIX = "UserContext: ";
    private static final String clientApplicationNameClassName = "com.sas.framework.commons.holders.ClientApplicationNameHolder";
    private static Class<?> clientApplicationNameClass = null;
    private static Method clientApplicationNameSetMethod = null;
    private static Method clientApplicationNameClearMethod = null;

    public static InformationServiceInterface getInformationService() throws ServiceException {
        InformationServiceInterface informationService = null;
        try {
            informationService = (InformationServiceInterface)DiscoveryService.defaultInstance().findService(new ServiceTemplate(new Class[]{InformationServiceInterface.class}, null));
        }
        catch (ServiceException t) {
            informationService = null;
        }
        catch (RemoteException t) {
            informationService = null;
        }
        if (informationService == null) {
            throw new ServiceException(RB.getStringResource("UserContext.nostprserv.ex.txt"));
        }
        return informationService;
    }

    static long getNextContextNum() {
        return contextNum++;
    }

    static void setUserService(UserServiceInterface userService) {
        if (_userService == null || userService == null) {
            _userService = userService;
        }
    }

    public static UserServiceInterface getUserService() throws ServiceException {
        return UserContext.getUserService(null);
    }

    public static UserServiceInterface getUserService(String serviceId) throws ServiceException {
        if (_userService != null) {
            return _userService;
        }
        UserServiceInterface userService = null;
        ServiceAttributeInterface[] serviceAttributes = null;
        Class[] desiredServiceCapabilities = new Class[]{UserServiceInterface.class};
        LocalDiscoveryServiceInterface discoveryService = DiscoveryService.defaultInstance();
        if (serviceId != null) {
            serviceAttributes = new ServiceAttributeInterface[]{new ServiceComponentAttribute(null, null, serviceId)};
        }
        ServiceTemplate serviceTemplate = new ServiceTemplate(desiredServiceCapabilities, serviceAttributes);
        try {
            userService = (UserServiceInterface)discoveryService.findService(serviceTemplate);
        }
        catch (ServiceException t) {
            userService = null;
        }
        catch (RemoteException t) {
            userService = null;
        }
        if (userService == null) {
            throw new ServiceException(RB.getStringResource("UserContext.nostprserv.ex.txt"));
        }
        return userService;
    }

    public UserContext(Subject subject) throws RemoteException {
        block2: {
            this();
            try {
                this.initializeFromSubject(subject);
            }
            catch (ServiceException svcex) {
                if (this._logger == null) break block2;
                this._logger.error(RB.getStringResource("UserContext.initerror.txt"));
            }
        }
    }

    public UserContext() throws RemoteException {
        super(SSLRMISocketFactories.getInstance().getPortForClass(0, UserContext.class), SSLRMISocketFactories.getInstance().getRMIClientSocketFactoryForClass(UserContext.class), SSLRMISocketFactories.getInstance().getRMIServerSocketFactoryForClass(UserContext.class));
        this.MONITOR_LABEL_TYPE = RB.getStringResource("UserService.monitorlabeltype.txt");
        this.MONITOR_LABEL_STATUS = RB.getStringResource("UserService.monitorlabelstatus.txt");
        this.MONITOR_LABEL_UID = RB.getStringResource("UserService.monitorlabeluid.txt");
        this.MONITOR_LABEL_DOMAIN = RB.getStringResource("UserService.monitorlabeldomain.txt");
        this.MONITOR_LABEL_CLIENT = RB.getStringResource("UserService.monitorlabelclient.txt");
        this.MONITOR_LABEL_APP = RB.getStringResource("UserService.monitorlabelapp.txt");
        this.MONITOR_LABEL_MESSAGE = RB.getStringResource("UserService.monitorlabelmessage.txt");
        this.MONITOR_VALUE_LOGOUT = RB.getStringResource("UserService.monitorvaluelogout.txt");
        this.MONITOR_VALUE_SUCCESS = RB.getStringResource("UserService.monitorvaluesuccess.txt");
        this.cx = null;
        this.cxGate = new int[0];
        this._generatedCredentials = new ArrayList<WeakReference<GeneratedUserIdentity>>(5);
        this._identities = new ArrayList<UserIdentityInterface>(5);
        this._identityListeners = new ArrayList<UserIdentityListener>(5);
        this._loginContext = null;
        this._isDestroyed = false;
        this._uniqueId = null;
        this._description = null;
        this._sharedResources = new HashMap<String, Object>(2);
        this._authServerName = null;
        this._reposGroups = new HashMap<String, RepositoryGroup>(16);
        this._clientSource = null;
        this._appSource = null;
        this._roleList = new ArrayList<String>(8);
        this._groupList = null;
        this._actionMap = new HashMap<String, List<ApplicationAuthorization>>();
        this._domainList = new ArrayList<String>(8);
        this._gotAllDomains = false;
        this.challengeMutex = new Object();
        this._resolvedId = null;
        this._isInternalUser = false;
        this._locale = null;
        this.memberships = null;
        this._iSetApplicationName = false;
        this._myContextNum = UserContext.getNextContextNum();
        this._exceptions = null;
        this._name = null;
        this._key = null;
        this._session = null;
        try {
            UserServiceInterface userService = UserContext.getUserService();
            ProfileDomain pd = userService.getProfileDefinition(PROFILE_GLOBAL);
            if (pd == null) {
                if (this._logger != null && this._logger.isInfoEnabled()) {
                    this._logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"UserService.noprofileconfig.ex.fmt.txt", (Object)PROFILE_GLOBAL));
                }
                this._profile = new GlobalProfile(PROFILE_GLOBAL);
            } else {
                String classString = pd.getClassName();
                ClassLoader cl = this.getClass().getClassLoader();
                Class<?> profileClass = cl.loadClass(classString);
                Class[] args = new Class[]{classString.getClass()};
                Constructor<?> ctor = profileClass.getConstructor(args);
                Object[] parms = new Object[]{PROFILE_GLOBAL};
                this._profile = (ProfileInterface)ctor.newInstance(parms);
            }
        }
        catch (ServiceException sex) {
            this._profile = new GlobalProfile(PROFILE_GLOBAL);
        }
        catch (ClassNotFoundException cnfe) {
            cnfe.printStackTrace(System.out);
            this._profile = new GlobalProfile(PROFILE_GLOBAL);
        }
        catch (NoSuchMethodException nsme) {
            nsme.printStackTrace(System.out);
            this._profile = new GlobalProfile(PROFILE_GLOBAL);
        }
        catch (InstantiationException ie) {
            ie.printStackTrace(System.out);
            this._profile = new GlobalProfile(PROFILE_GLOBAL);
        }
        catch (RemoteException rex) {
            this._profile = null;
        }
        catch (InvocationTargetException ex) {
            this._profile = new GlobalProfile(PROFILE_GLOBAL);
        }
        catch (IllegalAccessException ex) {
            this._profile = new GlobalProfile(PROFILE_GLOBAL);
        }
        this._repositories = new ArrayList<RepositoryInterface>(5);
        this._servers = new ArrayList<ServerInterface>(5);
        this._handler = new LoginCallbackHandler(this, null, null);
        this._logger = LogManager.getLogger((String)LOGGING_CONTEXT);
        if (this._logger.isDebugEnabled()) {
            this._logger.debug("Creating UserContext: " + this.hashCode());
        }
    }

    public UserContext(String name) throws RemoteException {
        this();
        this._name = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void destroy() throws RemoteException {
        if (this._isDestroyed) {
            return;
        }
        long start = System.currentTimeMillis();
        if (this._authServerName != null) {
            try {
                String serviceid = (String)this.getSharedResource("USERSERVICEID");
                UserServiceInterface usi = UserContext.getUserService(serviceid);
                if (usi != null) {
                    usi.userDestroyed(this);
                }
            }
            catch (ServiceException serviceid) {
                // empty catch block
            }
        }
        _userService = null;
        this._isDestroyed = true;
        String uid = null;
        String domain = null;
        if (this._identities.size() > 0) {
            UserIdentityInterface ident = this._identities.get(0);
            uid = (String)ident.getPrincipal();
            domain = ident.getDomain();
        }
        String guid = this.getUniqueId();
        Logger destroyLogger = LogManager.getLogger((String)"com.sas.services.user.UserContext.destroy");
        if (destroyLogger.isInfoEnabled()) {
            destroyLogger.info(Message.format((ResourceBundle)RB.getResources(), (String)"UserContext.destroy.fmt.txt", (Object)this._name, (Object)Long.toString(this._myContextNum)));
        }
        if (this._profile != null) {
            this._profile.destroy();
            this._profile = null;
        }
        Object object = this._servers;
        // MONITORENTER : object
        Iterator<Remote> itor = this._servers.iterator();
        while (itor.hasNext()) {
            try {
                ServerInterface si = itor.next();
                si.destroy();
            }
            catch (RemoteException ex) {
                if (this._logger == null) continue;
                this._logger.error(ex.getMessage(), (Throwable)ex);
            }
            catch (ServiceException ex) {
                if (this._logger == null) continue;
                this._logger.error(ex.getMessage(), (Throwable)((Object)ex));
            }
        }
        this._servers.clear();
        // MONITOREXIT : object
        object = this._repositories;
        // MONITORENTER : object
        itor = this._repositories.iterator();
        while (itor.hasNext()) {
            try {
                RepositoryInterface ri = (RepositoryInterface)itor.next();
                ri.close();
            }
            catch (RemoteException t) {
                if (this._logger != null) {
                    this._logger.error("", (Throwable)t);
                    continue;
                }
                t.printStackTrace(System.out);
            }
        }
        this._repositories.clear();
        this._repositories = null;
        // MONITOREXIT : object
        this._person = null;
        object = this._roleList;
        // MONITORENTER : object
        this._roleList.clear();
        // MONITOREXIT : object
        if (this._groupList != null) {
            object = this._groupList;
            // MONITORENTER : object
            this._groupList.clear();
            // MONITOREXIT : object
        }
        object = this._actionMap;
        // MONITORENTER : object
        this._actionMap.clear();
        // MONITOREXIT : object
        object = this._identities;
        // MONITORENTER : object
        this._identities.clear();
        // MONITOREXIT : object
        if (this._generatedCredentials != null && this._generatedCredentials.size() > 0) {
            object = this.cxGate;
            // MONITORENTER : this.cxGate
            Iterator<WeakReference<GeneratedUserIdentity>> it = this._generatedCredentials.iterator();
            while (it.hasNext()) {
                WeakReference<GeneratedUserIdentity> wr = it.next();
                if (wr.get() == null) {
                    it.remove();
                    continue;
                }
                GeneratedUserIdentity gi = (GeneratedUserIdentity)wr.get();
                gi.setUser(null);
                it.remove();
            }
            // MONITOREXIT : object
        }
        if (this.cx != null) {
            this.cx.close();
            this.cx = null;
        }
        try {
            if (this._loginContext != null) {
                this._loginContext.logout();
            }
        }
        catch (LoginException le) {
            if (this._logger != null) {
                this._logger.error("", (Throwable)le);
            }
            le.printStackTrace(System.out);
        }
        this._session = null;
        this._challenger = null;
        this._loginContext = null;
        this._mySubject = null;
        this._profile = null;
        if (this._handler != null) {
            this._handler.setContext(null);
            this._handler = null;
        }
        try {
            UserContext.unexportObject(this, true);
        }
        catch (NoSuchObjectException le) {
            // empty catch block
        }
        long end = System.currentTimeMillis();
        Logger timingLogger = LogManager.getLogger((String)"com.sas.services.user.UserContext.timing");
        if (timingLogger != null && timingLogger.isDebugEnabled()) {
            timingLogger.debug("UserContext destruction took " + (end - start) + " milliseconds");
        }
        if (this._logger.isDebugEnabled()) {
            this._logger.debug("Destroying UserContext: " + this.hashCode());
        }
        this._logger = null;
    }

    @Override
    public String getName() throws RemoteException {
        if (this._name != null) {
            return this._name;
        }
        IdentityInterface person = this.getPerson();
        if (person != null) {
            this._name = person.getName();
        }
        return this._name;
    }

    @Override
    public String getPersonFQID() throws RemoteException {
        return this._userFQID;
    }

    @Override
    public String getDescription() throws RemoteException {
        if (this._description != null && this._description.length() > 0) {
            return this._description;
        }
        IdentityInterface person = this.getPerson();
        if (person != null) {
            this._description = person.getDescription();
            return this._description;
        }
        return "";
    }

    @Override
    public final String getAppSource() throws RemoteException {
        return this._appSource;
    }

    @Override
    public final String getClientSource() throws RemoteException {
        return this._clientSource;
    }

    @Override
    public void setAppSource(String source) throws RemoteException {
        this._appSource = source;
    }

    @Override
    public void setClientSource(String source) throws RemoteException {
        this._clientSource = source;
    }

    @Override
    public void setSessionContext(SessionContextInterface session) throws RemoteException {
        this._session = session;
    }

    @Override
    public SessionContextInterface getSessionContext() throws RemoteException {
        return this._session;
    }

    @Override
    public void setName(String name) throws RemoteException {
        if (this._name != null && this._name.length() != 0) {
            throw new IllegalStateException();
        }
        this._name = name;
    }

    @Override
    public String getKey() throws RemoteException {
        if (this._key == null) {
            this._key = this._session != null ? this._session.getEntityKey() : this.getUniqueId();
        }
        return this._key;
    }

    @Override
    public void setKey(String key) throws RemoteException {
        if (this._key != null) {
            return;
        }
        this._key = key;
    }

    @Override
    public String getIDPropagation() throws ServiceException, RemoteException {
        return this._idpMechanism;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addIdentity(UserIdentityInterface identity) throws RemoteException {
        List<UserIdentityInterface> list = this._identities;
        synchronized (list) {
            if (!this._identities.contains(identity)) {
                this._identities.add(identity);
                this.notifyIdentityListeners(identity, IdentityChangeEvent.Type.ADD);
            }
        }
    }

    @Override
    public void addUserIdentityListener(UserIdentityListener listener) {
        this._identityListeners.add(listener);
    }

    private void notifyIdentityListeners(UserIdentityInterface identity, IdentityChangeEvent.Type type) {
        this.notifyIdentityListeners(Collections.singletonList(identity), type);
    }

    private void notifyIdentityListeners(List<UserIdentityInterface> identities, IdentityChangeEvent.Type type) {
        IdentityChangeEvent event = new IdentityChangeEvent(identities, type);
        for (UserIdentityListener listener : this._identityListeners) {
            try {
                listener.identitiesChanged(event);
            }
            catch (Throwable t) {
                this._logger.debug("Exception occurred trying to notify listener: " + listener, t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeIdentity(UserIdentityInterface identity) {
        if (identity instanceof SimpleUserIdentity && ((SimpleUserIdentity)identity).isSticky()) {
            return;
        }
        Object object = this._identities;
        synchronized (object) {
            if (this._identities.contains(identity)) {
                this._identities.remove(identity);
                this.notifyIdentityListeners(identity, IdentityChangeEvent.Type.REMOVE);
            }
        }
        object = this.cxGate;
        synchronized (this.cxGate) {
            Iterator<WeakReference<GeneratedUserIdentity>> it = this._generatedCredentials.iterator();
            while (it.hasNext()) {
                WeakReference<GeneratedUserIdentity> wr = it.next();
                if (wr.get() == null) {
                    it.remove();
                    continue;
                }
                if (!wr.get().equals(identity)) continue;
                it.remove();
            }
            if (this._generatedCredentials.size() == 0 && this.cx != null) {
                this.cx.close();
                this.cx = null;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getIdentities() throws RemoteException {
        Object readCred;
        Subject theSubject;
        try {
            this.getUserCredentials(this.getAuthServer());
        }
        catch (ServiceException ex) {
            throw new RuntimeException(ex.getMessage(), (Throwable)((Object)ex));
        }
        List list = null;
        boolean readCredOk = false;
        if (this._logger != null && this._logger.isDebugEnabled()) {
            this._logger.debug(RB.getStringResource("UserContext.credreq.msg.txt"));
        }
        AccessControlContext acc = AccessController.getContext();
        if (this._mySubject != null && acc != null && (theSubject = Subject.getSubject(acc)) != null && theSubject.equals(this._mySubject)) {
            readCredOk = true;
        }
        if (!readCredOk) {
            readCred = new CredentialPermission("readCredential");
            SecurityManager security = System.getSecurityManager();
            if (security != null) {
                security.checkPermission((Permission)readCred);
            }
        }
        readCred = this._identities;
        synchronized (readCred) {
            try {
                list = this.makeIdentityList();
            }
            catch (ServiceException sex) {
                throw new RuntimeException(sex.getMessage());
            }
        }
        if (this._logger != null && this._logger.isDebugEnabled()) {
            for (UserIdentityInterface ident : list) {
                this._logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"UserContext.cred.fmt.txt", (Object)ident.getDomain(), (Object)ident.getPrincipal(), (Object)"*******"));
            }
        }
        return list;
    }

    private List makeIdentityList() throws ServiceException, RemoteException {
        ArrayList<UserIdentityInterface> results = new ArrayList<UserIdentityInterface>(4);
        for (UserIdentityInterface ui : this._identities) {
            if (ui != null && (ui.getCredential() == null || ((String)ui.getCredential()).length() == 0) && ((SimpleUserIdentity)ui).isPrimary()) {
                UserIdentityInterface gi = this.generateCredential((String)ui.getPrincipal(), ui.getDomain());
                if (gi != null) {
                    results.add(gi);
                    continue;
                }
                if (ui.getCredential() == null || ((String)ui.getCredential()).trim().length() <= 0) continue;
                results.add(ui);
                continue;
            }
            if (ui.getCredential() == null || ((String)ui.getCredential()).trim().length() <= 0) continue;
            results.add(ui);
        }
        return results;
    }

    @Override
    public UserIdentityInterface getIdentityByDomain(String domain) throws RemoteException {
        try {
            return this.getIdentityByDomain(domain, false);
        }
        catch (ServiceException ex) {
            return null;
        }
    }

    @Override
    public UserIdentityInterface getIdentityByDomain(String domain, boolean issueChallenge) throws RemoteException, ServiceException {
        return this.getIdentityByDomain(domain, issueChallenge, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UserIdentityInterface getIdentityByDomain(String domain, boolean issueChallenge, String prompt) throws RemoteException, ServiceException {
        UserIdentityInterface result;
        block32: {
            Object[] ids;
            Subject theSubject;
            if (this._logger != null && this._logger.isDebugEnabled()) {
                this._logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"UserContext.credreqdom.fmt.txt", (Object)domain));
            }
            if (domain == null) {
                return null;
            }
            boolean subjectOK = false;
            AccessControlContext acc = AccessController.getContext();
            if (this._mySubject != null && acc != null && (theSubject = Subject.getSubject(acc)) != null && theSubject.equals(this._mySubject)) {
                subjectOK = true;
            }
            if (!subjectOK) {
                CredentialPermission readCred = new CredentialPermission("readCredential");
                SecurityManager security = System.getSecurityManager();
                if (security != null) {
                    security.checkPermission(readCred);
                }
            }
            this.getUserCredentialsForDomain(domain);
            result = null;
            List<UserIdentityInterface> list = this._identities;
            synchronized (list) {
                ids = this._identities.toArray();
            }
            for (int i = 0; i < ids.length; ++i) {
                UserIdentityInterface ui;
                UserIdentityInterface id = (UserIdentityInterface)ids[i];
                if (!domain.equalsIgnoreCase(id.getDomain())) continue;
                if ((id.getCredential() == null || ((String)id.getCredential()).length() == 0) && ((SimpleUserIdentity)id).isPrimary() && (ui = this.generateCredential((String)id.getPrincipal(), domain)) != null) {
                    id = ui;
                }
                if (id.getCredential() == null || ((String)id.getCredential()).trim().length() <= 0) continue;
                result = id;
                break;
            }
            if (result == null && issueChallenge) {
                UserServiceInterface usi = null;
                try {
                    usi = UserContext.getUserService();
                    if (usi == null) break block32;
                    RemoteCallbackHandler handler = this._challenger;
                    if (handler == null) {
                        handler = usi.getChallengeCallbackHandler();
                    }
                    if (handler == null && this._logger != null && this._logger.isDebugEnabled()) {
                        this._logger.debug(RB.getStringResource("UserContext.nocred.msg.txt"));
                    }
                    if (handler == null) break block32;
                    Object object = this.challengeMutex;
                    synchronized (object) {
                        for (int i = 0; i < ids.length; ++i) {
                            Object cred;
                            UserIdentityInterface id = (UserIdentityInterface)ids[i];
                            if (!domain.equalsIgnoreCase(id.getDomain()) || (cred = id.getCredential()) == null || cred.toString().trim().length() <= 0) continue;
                            result = id;
                            break;
                        }
                        if (result == null) {
                            Callback[] callbacks = new Callback[3];
                            callbacks[0] = new RemoteDomainCallback(domain);
                            String promptString = prompt == null ? Message.format((ResourceBundle)RB.getResources(), (String)"UserContext.usernameprmpt.ex.fmt", (Object)domain) : prompt;
                            callbacks[1] = new RemoteNameCallback(promptString);
                            promptString = prompt == null ? Message.format((ResourceBundle)RB.getResources(), (String)"UserContext.passwordprmpt.ex.fmt", (Object)domain) : prompt;
                            callbacks[2] = new RemotePasswordCallback(prompt, false);
                            String userid = null;
                            String password = null;
                            char[] pwArray = null;
                            try {
                                handler.handle(callbacks);
                                userid = ((RemoteNameCallback)callbacks[1]).getName();
                                pwArray = ((RemotePasswordCallback)callbacks[2]).getPassword();
                            }
                            catch (UnsupportedCallbackException ex) {
                                callbacks = new Callback[2];
                                promptString = prompt == null ? Message.format((ResourceBundle)RB.getResources(), (String)"UserContext.usernameprmpt.ex.fmt", (Object)domain) : prompt;
                                callbacks[0] = new RemoteNameCallback(promptString);
                                promptString = prompt == null ? Message.format((ResourceBundle)RB.getResources(), (String)"UserContext.passwordprmpt.ex.fmt", (Object)domain) : prompt;
                                callbacks[1] = new RemotePasswordCallback(prompt, false);
                                handler.handle(callbacks);
                                userid = ((RemoteNameCallback)callbacks[0]).getName();
                                pwArray = ((RemotePasswordCallback)callbacks[1]).getPassword();
                            }
                            String string = password = pwArray == null ? "" : new String(pwArray);
                            if (userid == null || userid.trim().length() == 0 || password == null || password.trim().length() == 0) {
                                result = null;
                            } else {
                                result = usi.newUserIdentity(userid, password, domain, "simple");
                                List<UserIdentityInterface> list2 = this._identities;
                                synchronized (list2) {
                                    if (!this._identities.contains(result)) {
                                        this._identities.add(result);
                                        this.notifyIdentityListeners(result, IdentityChangeEvent.Type.ADD);
                                    }
                                }
                            }
                        }
                    }
                }
                catch (IOException ex) {
                    throw new CallbackCancelledException(ex, ex.getMessage());
                }
                catch (UnsupportedCallbackException ex) {
                    throw new ServiceException(ex, ex.getMessage());
                }
            }
        }
        if (this._logger != null && this._logger.isDebugEnabled()) {
            if (result == null) {
                this._logger.debug(RB.getStringResource("UserContext.nocred.msg.txt"));
            } else {
                this._logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"UserContext.cred.fmt.txt", (Object)result.getDomain(), (Object)result.getPrincipal(), (Object)"*******"));
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private synchronized UserIdentityInterface generateCredential(String userid, String domain) throws ServiceException, RemoteException {
        try {
            String envKey = "ENVIRONMENT";
            Environment environment = (Environment)this.getSharedResource(envKey);
            String loginConfigAppName = this.getLoginConfigAppName();
            List<AppConfigurationEntry> entries = environment.getAppConfigurationEntry(loginConfigAppName);
            StringHolder qualUserNameHolder = null;
            StringHolder genrPasswordHolder = null;
            GeneratedUserIdentity result = null;
            int numEntries = entries != null ? entries.size() : 0;
            int i = 0;
            while (i < numEntries) {
                block22: {
                    Object cred;
                    String aliasDomain;
                    String mapDomain;
                    Map map;
                    block24: {
                        String trustedpw;
                        String trustedUser;
                        block23: {
                            AppConfigurationEntry entry = entries.get(i);
                            map = entry.getOptions();
                            map = LoginCallbackHandler.getDelegateOptionMap(map);
                            mapDomain = (String)map.get("domain");
                            aliasDomain = (String)map.get("aliasdomain");
                            ArrayList<String> aliasDomains = new ArrayList<String>();
                            if (null != aliasDomain) {
                                String[] domains = aliasDomain.split(",");
                                aliasDomains.addAll(Arrays.asList(domains));
                            }
                            if ((mapDomain == null || !mapDomain.equalsIgnoreCase(domain)) && (aliasDomains == null || !aliasDomains.contains(domain))) break block22;
                            trustedUser = (String)map.get("trusteduser");
                            trustedpw = (String)map.get("trustedpw");
                            String trustedIDP = (String)map.get("trustedidpropagation");
                            trustedIDP = OMILoginModule.normalizeIDPropagation((String)trustedIDP);
                            cred = null;
                            if (trustedIDP == null) break block23;
                            cred = trustedIDP.equals("sspi") ? SecurityPackageCredential.getInstance() : TrustedPeerCredential.getInstance();
                            break block24;
                        }
                        if (trustedUser == null || trustedpw == null) break block22;
                        cred = new PasswordCredential(trustedUser, trustedpw);
                    }
                    MetadataServerInterface mserver = null;
                    if (this._authServerName != null) {
                        mserver = (MetadataServerInterface)this.getAuthServer();
                    }
                    if (mserver != null && mserver.isConnected() && (mserver.getDomain().equalsIgnoreCase(mapDomain) || mserver.getDomain().equalsIgnoreCase(aliasDomain))) {
                        UserIdentityInterface ident = null;
                        try {
                            ident = mserver.generatePassword(null);
                            ident.setDomain(domain);
                        }
                        catch (RemoteException ex) {
                            ident = null;
                        }
                        catch (ServiceException ex) {
                            ident = null;
                        }
                        if (ident != null) {
                            return ident;
                        }
                    }
                    int[] nArray = this.cxGate;
                    // MONITORENTER : this.cxGate
                    if (this.cx == null) {
                        HashMap<String, String> clusterOptions = new HashMap<String, String>();
                        if (Boolean.parseBoolean((String)map.get("encrypt"))) {
                            clusterOptions.put("encrypt", "true");
                        }
                        if (map.containsKey("sspisecuritypackagelist")) {
                            clusterOptions.put("sspipackagelist", (String)map.get("sspisecuritypackagelist"));
                        }
                        if (map.containsKey("sspispn")) {
                            clusterOptions.put("sspispn", (String)map.get("sspispn"));
                        }
                        Cluster cluster = MetadataClusterUtil.createCluster((String)((String)map.get("host")), (String)((String)map.get("port")), clusterOptions);
                        ManualConnectionFactoryConfiguration cxfConfig = new ManualConnectionFactoryConfiguration(cluster);
                        ConnectionFactoryInterface cxf = null;
                        ConnectionFactoryManager cxfManager = new ConnectionFactoryManager();
                        cxfManager.setConnectionResources((ConnectionResources)environment);
                        cxf = cxfManager.getFactory((ConnectionFactoryConfiguration)cxfConfig);
                        this.cx = cxf.getConnection((Credential)cred);
                    }
                    qualUserNameHolder = new StringHolder();
                    genrPasswordHolder = new StringHolder();
                    try {
                        this.cx.generatePassword(userid, qualUserNameHolder, genrPasswordHolder);
                        result = new GeneratedUserIdentity(qualUserNameHolder.value, genrPasswordHolder.value, domain, this);
                        this._generatedCredentials.add(new WeakReference<GeneratedUserIdentity>(result));
                        // MONITOREXIT : nArray
                        return result;
                    }
                    catch (Throwable t) {
                        if (this.isConnectionException(t)) {
                            this.cx = null;
                            // MONITOREXIT : nArray
                            return this.generateCredential(userid, domain);
                        }
                        // MONITOREXIT : nArray
                    }
                }
                ++i;
            }
            return null;
        }
        catch (InvalidCredentialsException ex) {
            throw new ServiceException(ex, RB.getStringResource("UserContext.badtrustpw.ex.txt"));
        }
        catch (ConnectionFactoryException t) {
            throw new ServiceException(t, t.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getIdentitiesByDomain(String domain, boolean issueChallenge, String challengePrompt) throws RemoteException, ServiceException {
        UserIdentityInterface id;
        Object[] ids;
        Object security;
        Subject theSubject;
        ArrayList<UserIdentityInterface> result = new ArrayList<UserIdentityInterface>(4);
        this.getUserCredentialsForDomain(domain);
        if (this._logger != null && this._logger.isDebugEnabled()) {
            this._logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"UserContext.credreqdomall.fmt.txt", (Object)domain));
        }
        if (domain == null) {
            return null;
        }
        boolean subjectOK = false;
        AccessControlContext acc = AccessController.getContext();
        if (this._mySubject != null && acc != null && (theSubject = Subject.getSubject(acc)) != null && theSubject.equals(this._mySubject)) {
            subjectOK = true;
        }
        if (!subjectOK) {
            CredentialPermission readCred = new CredentialPermission("readCredential");
            security = System.getSecurityManager();
            if (security != null) {
                ((SecurityManager)security).checkPermission(readCred);
            }
        }
        security = this._identities;
        synchronized (security) {
            ids = this._identities.toArray();
        }
        for (int i = 0; i < ids.length; ++i) {
            UserIdentityInterface gid;
            UserIdentityInterface id2 = (UserIdentityInterface)ids[i];
            if (!domain.equalsIgnoreCase(id2.getDomain())) continue;
            if (id2 != null && (id2.getCredential() == null || ((String)id2.getCredential()).length() == 0) && ((SimpleUserIdentity)id2).isPrimary() && (gid = this.generateCredential((String)id2.getPrincipal(), domain)) != null) {
                id2 = gid;
            }
            if (id2 == null || id2.getCredential() == null || ((String)id2.getCredential()).trim().length() <= 0) continue;
            result.add(id2);
        }
        if (result.size() == 0 && issueChallenge && (id = this.getIdentityByDomain(domain, issueChallenge, challengePrompt)) != null && id.getCredential() != null && ((String)id.getCredential()).trim().length() > 0) {
            result.add(id);
        }
        if (this._logger != null && this._logger.isDebugEnabled()) {
            for (UserIdentityInterface ident : result) {
                this._logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"UserContext.cred.fmt.txt", (Object)ident.getDomain(), (Object)ident.getPrincipal(), (Object)"*******"));
            }
        }
        return result;
    }

    @Override
    public void addRepositoryGroup(RepositoryGroup group) throws ServiceException, RemoteException {
        if (group == null) {
            return;
        }
        String groupName = group.getName();
        if (groupName == null || groupName.trim().length() == 0) {
            throw new ServiceException(RB.getStringResource("UserContext.badgroupname.txt"));
        }
        RepositoryGroup existingGroup = this._reposGroups.get(groupName);
        if (existingGroup != null) {
            throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"UserContext.groupexists.fmt.txt", (Object)groupName));
        }
        this._reposGroups.put(groupName, group);
    }

    @Override
    public void removeRepositoryGroup(RepositoryGroup group) throws ServiceException, RemoteException {
        if (group == null) {
            return;
        }
        String groupName = group.getName();
        this._reposGroups.remove(groupName);
    }

    @Override
    public RepositoryGroup getRepositoryGroup(String name) throws ServiceException, RemoteException {
        if (name == null) {
            return null;
        }
        RepositoryGroup result = this._reposGroups.get(name);
        return result;
    }

    @Override
    public ProfileInterface getProfile() throws RemoteException {
        return this._profile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addServer(ServerInterface server) throws ServiceException, RemoteException {
        List<ServerInterface> list = this._servers;
        synchronized (list) {
            this._servers.add(server);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeServer(ServerInterface server) throws ServiceException, RemoteException {
        List<ServerInterface> list = this._servers;
        synchronized (list) {
            this._servers.remove(server);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServerInterface getServer(String name) throws ServiceException, RemoteException {
        List<ServerInterface> list = this._servers;
        synchronized (list) {
            for (ServerInterface server : this._servers) {
                if (!server.getName().equals(name)) continue;
                return server;
            }
        }
        return null;
    }

    @Override
    public List getServers() throws RemoteException {
        return new ArrayList<ServerInterface>(this._servers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addRepository(Object repository) throws RemoteException {
        List<RepositoryInterface> list = this._repositories;
        synchronized (list) {
            this._repositories.add((RepositoryInterface)repository);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeRepository(Object repository) throws RemoteException {
        List<RepositoryInterface> list = this._repositories;
        synchronized (list) {
            this._repositories.remove(repository);
        }
    }

    @Override
    public RepositoryInterface getRepository(String name) throws ServiceException, RemoteException {
        RepositoryInterface ri;
        if (name == null) {
            return null;
        }
        int index = name.indexOf(46);
        if (index > 0) {
            String servername = name.substring(0, index);
            String reposname = name.substring(index + 1);
            ServerInterface si = this.getServer(servername);
            if (si != null && (ri = si.getRepository(reposname)) != null) {
                return ri;
            }
        }
        Iterator<RepositoryInterface> it = this._repositories.iterator();
        while (it.hasNext()) {
            RepositoryInterface ri2 = it.next();
            try {
                String riName = ri2.getISName();
                if (riName == null || !riName.equals(name)) continue;
                return ri2;
            }
            catch (IllegalStateException isex) {
                it.remove();
            }
        }
        List servers = this.getServers();
        for (ServerInterface si : servers) {
            ri = si.getRepository(name);
            if (ri == null) continue;
            return ri;
        }
        try {
            RepositoryDef theDef = null;
            InformationServiceInterface isi = UserContext.getInformationService();
            List defs = isi.getReposDefs();
            for (RepositoryDef nextDef : defs) {
                if (!nextDef.getName().equals(name)) continue;
                theDef = nextDef;
                break;
            }
            if (theDef != null) {
                RepositoryInterface ri3 = isi.connect((UserContextInterface)this, theDef);
                return ri3;
            }
        }
        catch (ServiceException serviceException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public String getAuthRepositoryName() throws ServiceException, RemoteException {
        return this._authReposName;
    }

    @Override
    public RepositoryInterface getAuthRepository() throws ServiceException, RemoteException {
        return this.getRepository(this._authReposName);
    }

    @Override
    public ServerInterface getAuthServer() throws ServiceException, RemoteException {
        ServerInterface server;
        if (this._authServerName == null) {
            if (this._logger != null) {
                Exception ex = new Exception(RB.getStringResource("UserContext.authsvrnmnull.txt"));
                this._logger.error(RB.getStringResource("UserContext.authsvrnmnull.txt"), (Throwable)ex);
            }
            if (this._servers != null && this._servers.size() > 0) {
                return this._servers.get(0);
            }
        }
        if ((server = this.getServer(this._authServerName)) == null) {
            if (this._logger != null) {
                this._logger.error(Message.format((ResourceBundle)RB.getResources(), (String)"UserContext.authsvrmissng.fmt.txt", (Object)this._authServerName));
            }
            if (this._servers != null && this._servers.size() > 0) {
                server = this._servers.get(0);
            }
        }
        if (server == null && this._logger != null) {
            this._logger.error(RB.getStringResource("UserContext.noservers.txt"));
        }
        return server;
    }

    @Override
    public String getAuthServerName() throws ServiceException, RemoteException {
        return this._authServerName;
    }

    @Override
    public List getRepositories() throws RemoteException {
        ArrayList<RepositoryInterface> result = new ArrayList<RepositoryInterface>(this._repositories);
        for (ServerInterface si : this._servers) {
            try {
                List reposList = si.getRepositories(false);
                result.addAll(reposList);
            }
            catch (ServiceException serviceException) {}
        }
        return result;
    }

    @Override
    public void refreshRepositoryData() throws ServiceException, RemoteException {
        for (ServerInterface si : this._servers) {
            try {
                if (this._logger != null && this._logger.isDebugEnabled()) {
                    this._logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"UserContext.refreshServer.fmt.txt", (Object)si.getName()));
                }
                si.refreshAllData();
            }
            catch (ServiceException ex) {
                ChainedException.printStackTrace((Throwable)((Object)ex), (PrintStream)System.out, (boolean)true);
            }
        }
        for (RepositoryInterface ri : this._repositories) {
            if (ri instanceof OMIRepositoryInterface) continue;
            if (this._logger != null && this._logger.isDebugEnabled()) {
                this._logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"UserContext.refreshServer.fmt.txt", (Object)ri.getUrl()));
            }
            ri.refreshAllData();
        }
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof UserContextInterface)) {
            return false;
        }
        try {
            UserContextInterface uci = (UserContextInterface)o;
            return uci.getUniqueId().equals(this.getUniqueId());
        }
        catch (RemoteException rex) {
            return false;
        }
    }

    @Override
    public Set getPrincipals() throws RemoteException {
        if (this._mySubject == null) {
            return null;
        }
        return new LinkedHashSet<Principal>(this._mySubject.getPrincipals());
    }

    @Override
    public Set getPublicCredentials() throws RemoteException {
        if (this._mySubject == null) {
            return null;
        }
        return new LinkedHashSet<Object>(this._mySubject.getPublicCredentials());
    }

    @Override
    public Set getPrivateCredentials() throws RemoteException {
        if (this._mySubject == null) {
            return null;
        }
        return new LinkedHashSet<Object>(this._mySubject.getPrivateCredentials());
    }

    @Override
    public LoginCallbackHandler getLoginCallback() throws RemoteException {
        return this._handler;
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean authenticate() throws RemoteException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [25[CATCHBLOCK]], but top level block is 12[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean authenticate(UserIdentityInterface ident, Map options) throws RemoteException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 9 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initializeFromSubject(Subject subject) throws RemoteException, ServiceException {
        boolean foundServerPrincipal = false;
        this._authTime = new Date().getTime();
        long startTime = System.currentTimeMillis();
        GetCredentialPrivilegedAction action = new GetCredentialPrivilegedAction(subject);
        try {
            AccessController.doPrivileged(action);
        }
        catch (PrivilegedActionException pae) {
            Throwable t = pae.getCause();
            if (t instanceof RemoteException) {
                throw (RemoteException)t;
            }
            if (t instanceof SecurityException) {
                throw (SecurityException)t;
            }
            throw new ServiceException(t, t.getMessage());
        }
        long endTime = System.currentTimeMillis();
        Logger timingLogger = LogManager.getLogger((String)"com.sas.services.user.UserContext.timing");
        if (timingLogger.isDebugEnabled()) {
            timingLogger.debug("processing credentials took: " + (endTime - startTime) + " milliseconds.");
        }
        SSPISecurityParams sspiParams = this.getSSPIParams();
        try {
            this.setClientApplicationName(this._appSource);
            for (Principal next : subject.getPrincipals()) {
                String roleName;
                if (!(next instanceof PFSPrincipalInterface)) continue;
                PFSPrincipalInterface p = (PFSPrincipalInterface)next;
                String password = null;
                if (p instanceof OMIServerPrincipal && !p.isProcessed()) {
                    String userid;
                    SimpleUserIdentity primaryIdentity = null;
                    for (SimpleUserIdentity simpleUserIdentity : this._identities) {
                        if (!simpleUserIdentity.isPrimary()) continue;
                        primaryIdentity = simpleUserIdentity;
                        break;
                    }
                    OMIServerPrincipal oMIServerPrincipal = (OMIServerPrincipal)p;
                    UserServiceInterface usi = UserContext.getUserService();
                    boolean allowGroupLogins = usi.getGroupLoginEnabled();
                    password = oMIServerPrincipal.getPassword();
                    if (!"Person".equals(oMIServerPrincipal.getUserType()) && !allowGroupLogins) {
                        throw new NonPersonAuthenticationException(RB.getStringResource("UserContext.onlyAPerson.ex.txt"));
                    }
                    ServerDef theDef = this.getServerDef(oMIServerPrincipal);
                    if (theDef == null) {
                        theDef = new ServerDef("METASERVER", "omi", oMIServerPrincipal.getHost(), String.valueOf(oMIServerPrincipal.getPort()));
                        String domain = oMIServerPrincipal.getDomain();
                        theDef.setDomain(domain);
                    }
                    if (theDef.getDomain().equals(sspiParams.getIdpDomain()) && sspiParams.getIdpMechanism() != null) {
                        if (password == null) {
                            this._idpMechanism = sspiParams.getIdpMechanism();
                            theDef.addAdvancedOptions("idpropagation", sspiParams.getIdpMechanism());
                        }
                        if (sspiParams.getSspiSecurityPackageList() != null) {
                            theDef.addAdvancedOptions("securitypackagelist", sspiParams.getSspiSecurityPackageList());
                        }
                        if (sspiParams.getSspiSPN() != null) {
                            theDef.addAdvancedOptions("spn", sspiParams.getSspiSPN());
                        }
                    }
                    this._resolvedId = userid = oMIServerPrincipal.getUserId();
                    if (primaryIdentity != null && userid != null) {
                        primaryIdentity.setResolvedUserName(userid);
                    }
                    this._userFQID = oMIServerPrincipal.get_userFQID();
                    if (this._name == null) {
                        String ospname;
                        this._name = ospname = oMIServerPrincipal.getUserName();
                    }
                    this._description = oMIServerPrincipal.getDescription();
                    IOMI iomi = oMIServerPrincipal.getIOMI();
                    Cluster cluster = oMIServerPrincipal.getMetadataCluster();
                    ServerInterface server = null;
                    if (iomi != null) {
                        server = new OMIServer();
                        if (cluster != null) {
                            server.connect(iomi, theDef, this, cluster);
                        } else {
                            server.connect(iomi, theDef, this);
                        }
                        this.addServer(server);
                    } else {
                        InformationServiceInterface informationService = UserContext.getInformationService();
                        startTime = System.currentTimeMillis();
                        server = cluster != null ? informationService.connect(this, theDef, cluster) : informationService.connect((UserContextInterface)this, theDef);
                        endTime = System.currentTimeMillis();
                        if (timingLogger.isDebugEnabled()) {
                            this._logger.debug("Connecting to repository " + theDef.getProtocol() + "://" + theDef.getHost() + ':' + theDef.getPort() + " took " + (endTime - startTime) + " milliseconds");
                        }
                    }
                    if (this._authServerName == null) {
                        this._authServerName = server.getName();
                        this.setPerson(server.getIdentity());
                    }
                    p.setProcessed();
                    foundServerPrincipal = true;
                }
                if (!(p instanceof PFSRolePrincipal) || this._roleList.contains(roleName = p.getName())) continue;
                this._roleList.add(roleName);
            }
            if (!foundServerPrincipal) {
                throw new ServiceException("No principal was found to initialize the Information Service connection.");
            }
            this._mySubject = subject;
            ServiceException autoException = null;
            InformationServiceInterface isi = UserContext.getInformationService();
            try {
                isi.connectAuto(this);
            }
            catch (ServiceException ex) {
                autoException = ex;
            }
            ProfileDomain pd = new ProfileDomain("", "", "", GlobalProfile.class.getName());
            RepositoryInterface ri = this.getProfileRepos();
            if (ri != null) {
                this._authReposName = ri.getISName();
                if (this._person instanceof PersonInterface) {
                    this.loadUserProfile(ri, pd);
                }
            }
            if (autoException != null) {
                throw autoException;
            }
        }
        finally {
            this.clearClientApplicationName();
        }
    }

    private void getUserCredentials(ServerInterface server) throws ServiceException, RemoteException {
        if (this._gotAllDomains) {
            return;
        }
        if (server == null) {
            return;
        }
        long start = System.currentTimeMillis();
        RepositoryInterface ri = server.getFoundationRepository();
        if (ri == null) {
            return;
        }
        Filter filter = new Filter();
        filter.setType("AuthenticationDomain");
        List domains = ri.search(filter);
        for (MetadataInterface mi : domains) {
            String nextDomain = mi.getName();
            if (nextDomain == null || nextDomain.trim().length() <= 0) continue;
            this.getUserCredentialsForDomain(nextDomain);
        }
        long end = System.currentTimeMillis();
        Logger timingLogger = LogManager.getLogger((String)"com.sas.services.user.UserContext.timing");
        if (timingLogger.isDebugEnabled()) {
            this._logger.debug("Getting user credentials took: " + (end - start) + " milliseconds");
        }
        this._gotAllDomains = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getUserCredentialsForDomain(String domain) throws ServiceException, RemoteException {
        if (domain == null || domain.trim().length() == 0) {
            return;
        }
        if (MIDTIERINTERNAL_DOMAIN.equalsIgnoreCase(domain)) {
            return;
        }
        List<String> list = this._domainList;
        synchronized (list) {
            if (this._domainList.contains(domain)) {
                return;
            }
        }
        if (this._authServerName == null) {
            return;
        }
        ServerInterface metaServer = this.getAuthServer();
        if (metaServer == null || !metaServer.isConnected()) {
            return;
        }
        long start = System.currentTimeMillis();
        try {
            List idents = ((MetadataServerInterface)metaServer).getLoginsForAuthDomain(domain);
            List<UserIdentityInterface> list2 = this._identities;
            synchronized (list2) {
                this._identities.addAll(idents);
            }
        }
        catch (ServiceException idents) {
            // empty catch block
        }
        long end = System.currentTimeMillis();
        List<String> list3 = this._domainList;
        synchronized (list3) {
            this._domainList.add(domain);
        }
        Logger timingLogger = LogManager.getLogger((String)"com.sas.services.user.UserContext.timing");
        if (timingLogger.isDebugEnabled()) {
            timingLogger.debug("Getting user credentials took: " + (end - start) + " milliseconds");
        }
    }

    @Override
    public void addException(Exception exception) throws RemoteException {
        if (this._exceptions == null) {
            this._exceptions = new ArrayList<Throwable>(2);
        }
        this._exceptions.add(exception);
    }

    @Override
    public void clearExceptions() throws RemoteException {
        this._exceptions.clear();
        this._exceptions = null;
    }

    @Override
    public Exception[] getExceptions() throws RemoteException {
        if (this._exceptions == null) {
            return null;
        }
        Exception[] exceptions = new Exception[this._exceptions.size()];
        int exceptionsSize = this._exceptions.size();
        for (int i = 0; i < exceptionsSize; ++i) {
            exceptions[i] = (Exception)this._exceptions.get(i);
        }
        return exceptions;
    }

    @Override
    public void setChallengeCallbackHandler(RemoteCallbackHandler handler) throws RemoteException {
        this._challenger = handler;
    }

    @Override
    public RemoteCallbackHandler getChallengeCallbackHandler() throws RemoteException {
        return this._challenger;
    }

    @Override
    public IdentityInterface getPerson() throws RemoteException {
        if (this._person != null && !this._person.isDestroyed()) {
            return this._person;
        }
        try {
            ServerInterface server = this.getAuthServer();
            if (server != null) {
                this.setPerson(server.getIdentity());
                return this._person;
            }
        }
        catch (ServiceException ex) {
            throw new RuntimeException(ex.getMessage(), (Throwable)((Object)ex));
        }
        return null;
    }

    @Override
    public void setPerson(IdentityInterface identity) throws RemoteException, IllegalStateException {
        if (identity == null) {
            return;
        }
        if (this._person != null && this._person.equals(identity)) {
            return;
        }
        if (this._person != null && !this._person.isDestroyed()) {
            throw new IllegalStateException();
        }
        this._person = identity;
    }

    @Override
    public String getUniqueId() throws RemoteException {
        if (this._uniqueId != null) {
            return this._uniqueId;
        }
        this._uniqueId = new VMID().toString() + ':' + this.hashCode();
        return this._uniqueId;
    }

    @Override
    public boolean isDestroyed() throws RemoteException {
        return this._isDestroyed;
    }

    @Override
    public long getLoginTime() throws RemoteException {
        return this._authTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getSharedResource(String key) throws RemoteException {
        Map<String, Object> map = this._sharedResources;
        synchronized (map) {
            return this._sharedResources.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object putSharedResource(String key, Object value) throws RemoteException {
        Map<String, Object> map = this._sharedResources;
        synchronized (map) {
            return this._sharedResources.put(key, value);
        }
    }

    @Override
    public String toString() {
        Date date = new Date(this._authTime);
        String uid = "";
        if (this._identities != null && this._identities.size() > 0) {
            uid = (String)this._identities.get(0).getPrincipal();
        }
        return TOSTRING_PREFIX + this._name + (uid == null ? "" : '(' + uid + ')') + "  " + date;
    }

    private void loadUserProfile(RepositoryInterface rep, ProfileDomain pd) throws ServiceException, RemoteException {
        String userName = this.getName();
        if (rep != null) {
            IdentityInterface identity = rep.getIdentity();
            Profile profile = (Profile)this.getProfile();
            profile.setLoadParameters(identity, this, rep, pd);
        } else {
            this._exceptions.add((Throwable)((Object)new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"UserService.profres.ex.fmt", (Object)userName, (Object)pd.getUrl(), (Object)PROFILE_GLOBAL))));
        }
    }

    private RepositoryInterface getProfileRepos() throws RemoteException, ServiceException {
        PersonInterface person;
        ServerInterface si;
        String userId = null;
        if (this._userFQID != null) {
            userId = this._userFQID;
        } else if (!this._name.equalsIgnoreCase("unknown") && (si = this.getAuthServer()) != null && (person = si.getPerson()) != null) {
            userId = person.getReposId();
        }
        if (userId != null) {
            int index = userId.indexOf(46);
            String reposId = "A0000001." + userId.substring(0, index);
            for (ServerInterface si2 : this._servers) {
                String reposName = si2.getRepositoryName(reposId);
                if (reposName == null) continue;
                return si2.getRepository(reposName);
            }
            for (RepositoryInterface ri : this._repositories) {
                if (!ri.getUrl().startsWith("omi") || !((OMIRepositoryInterface)ri).getDefaultRepositoryId().equalsIgnoreCase(reposId)) continue;
                return ri;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] toByteArray() throws RemoteException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeLong(this._authTime);
            oos.writeObject(this._appSource);
            oos.writeObject(this._clientSource);
            List<Object> list = this._domainList;
            synchronized (list) {
                oos.writeObject(this._domainList);
            }
            oos.writeBoolean(this._gotAllDomains);
            oos.writeObject(this._idpMechanism);
            oos.writeBoolean(this._isInternalUser);
            oos.writeObject(this._loginConfigAppName);
            oos.writeObject(this._name);
            oos.writeObject(this._reposGroups);
            oos.writeObject(this._resolvedId);
            oos.writeObject(this._roleList);
            oos.writeObject(this._groupList);
            oos.writeObject(this._userFQID);
            oos.writeObject(this._key);
            oos.writeObject(this._uniqueId);
            list = this._identities;
            synchronized (list) {
                oos.writeObject(this._identities);
            }
            oos.writeInt(this._servers.size());
            for (ServerInterface si : this._servers) {
                oos.writeObject(si.getClass().getName());
                oos.writeObject(si.getName());
                byte[] siData = ((OMIServer)si).toByteArray(false);
                oos.writeObject(siData);
            }
            oos.writeObject(this._authServerName);
            oos.writeInt(this._repositories.size());
            for (RepositoryInterface ri : this._repositories) {
                if (ri.getUrl().toLowerCase().startsWith("omi")) continue;
                oos.writeObject(ri.getClass().getName());
                oos.writeObject(ri.getISName());
                byte[] riData = ri.toByteArray();
                oos.writeObject(riData);
            }
            ServerInterface authServer = this.getAuthServer();
            GeneratedUserIdentity ident = new GeneratedUserIdentity("user", "password", "blah", null);
            oos.writeObject(ident);
            oos.flush();
            byte[] blobArray = baos.toByteArray();
            return blobArray;
        }
        catch (ServiceException ex) {
            return null;
        }
        catch (IOException ex) {
            return null;
        }
    }

    void fromByteArray(byte[] data) throws ServiceException, RemoteException {
        long start = System.currentTimeMillis();
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        try {
            RepositoryInterface ri;
            ObjectInputStream ois = new ObjectInputStream(bais);
            long authTime = ois.readLong();
            this._appSource = (String)ois.readObject();
            this._clientSource = (String)ois.readObject();
            this._domainList = (List)ois.readObject();
            this._gotAllDomains = ois.readBoolean();
            this._idpMechanism = (String)ois.readObject();
            this._isInternalUser = ois.readBoolean();
            this._loginConfigAppName = (String)ois.readObject();
            this._name = (String)ois.readObject();
            this._reposGroups = (Map)ois.readObject();
            this._resolvedId = (String)ois.readObject();
            this._roleList = (List)ois.readObject();
            this._groupList = (List)ois.readObject();
            this._userFQID = (String)ois.readObject();
            String key = (String)ois.readObject();
            String uniqueId = (String)ois.readObject();
            List idents = (List)ois.readObject();
            int serverSize = ois.readInt();
            this.setClientApplicationName(this._appSource);
            for (int i = 0; i < serverSize; ++i) {
                String serverClass = (String)ois.readObject();
                String serverName = (String)ois.readObject();
                byte[] serverData = (byte[])ois.readObject();
                if (this.getServer(serverName) != null) continue;
                ServerInterface si = this.makeServer(serverClass);
                si.fromByteArray(this, serverData);
                this.addServer(si);
                if (this._person != null) continue;
                this._person = si.getPerson();
            }
            this._authServerName = (String)ois.readObject();
            int reposSize = ois.readInt();
            for (int i = 0; i < reposSize; ++i) {
                String reposClass = (String)ois.readObject();
                String reposISName = (String)ois.readObject();
                byte[] riData = (byte[])ois.readObject();
                RepositoryInterface ri2 = this.makeRepository(reposClass);
                ri2.fromByteArry(this, riData);
                this.addRepository(ri2);
            }
            UserIdentityInterface ident = (UserIdentityInterface)ois.readObject();
            this._identities.clear();
            for (SimpleUserIdentity sui : idents) {
                if (this._identities.contains(sui)) continue;
                this._identities.add(sui);
            }
            this._key = key;
            this._authTime = authTime;
            Logger createLogger = LogManager.getLogger((String)"com.sas.services.user.UserContext.create");
            if (createLogger.isDebugEnabled()) {
                createLogger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"UserContext.create.fmt.txt", (Object)Long.toString(this._myContextNum), (Object)this._name));
            }
            if ((ri = this.getProfileRepos()) != null) {
                UserServiceInterface us = UserContext.getUserService();
                ProfileDomain pd = us.getProfileDefinition(PROFILE_GLOBAL);
                this.loadUserProfile(ri, pd);
            }
        }
        catch (ClassNotFoundException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        catch (IOException ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        finally {
            this.clearClientApplicationName();
        }
        long end = System.currentTimeMillis();
        Logger timingLogger = LogManager.getLogger((String)"com.sas.services.user.UserContext.timing");
        if (timingLogger.isDebugEnabled()) {
            this._logger.debug("UserContext creation from byte array took: " + (end - start) + " milliseconds.");
        }
    }

    private RepositoryInterface makeRepository(String reposClassName) throws ServiceException, RemoteException {
        RepositoryInterface ri = null;
        try {
            ClassLoader cl = this.getClass().getClassLoader();
            Class<?> reposClass = cl.loadClass(reposClassName);
            Constructor<?> ctor = reposClass.getConstructor(null);
            if (ctor == null) {
                throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"UserService.noctrdef.ex.fmt.txt", (Object)reposClassName));
            }
            ri = (RepositoryInterface)ctor.newInstance(null);
            ri.setUserContext(this);
            return ri;
        }
        catch (ClassNotFoundException cnfe) {
            throw new ServiceException(cnfe, Message.format((ResourceBundle)RB.getResources(), (String)"UserService.clsntfnd.ex.fmt.txt", (Object)reposClassName));
        }
        catch (NoSuchMethodException nsme) {
            throw new ServiceException(nsme, Message.format((ResourceBundle)RB.getResources(), (String)"UserService.noctrdef.ex.fmt.txt", (Object)reposClassName));
        }
        catch (InstantiationException e) {
            throw new ServiceException(e, RB.getStringResource("UserService.prflstrerr.ex.msg.txt"));
        }
        catch (InvocationTargetException e) {
            throw new ServiceException(e, RB.getStringResource("UserService.prflstrerr.ex.msg.txt"));
        }
        catch (IllegalAccessException e) {
            throw new ServiceException(e, RB.getStringResource("UserService.prflstrerr.ex.msg.txt"));
        }
    }

    private ServerInterface makeServer(String serverClassName) throws ServiceException, RemoteException {
        ServerInterface si = null;
        try {
            ClassLoader cl = this.getClass().getClassLoader();
            Class<?> reposClass = cl.loadClass(serverClassName);
            Constructor<?> ctor = reposClass.getConstructor(null);
            if (ctor == null) {
                throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"UserService.noctrdef.ex.fmt.txt", (Object)serverClassName));
            }
            si = (ServerInterface)ctor.newInstance(null);
            return si;
        }
        catch (ClassNotFoundException cnfe) {
            throw new ServiceException(cnfe, Message.format((ResourceBundle)RB.getResources(), (String)"UserService.clsntfnd.ex.fmt.txt", (Object)serverClassName));
        }
        catch (NoSuchMethodException nsme) {
            throw new ServiceException(nsme, Message.format((ResourceBundle)RB.getResources(), (String)"UserService.noctrdef.ex.fmt.txt", (Object)serverClassName));
        }
        catch (InstantiationException e) {
            throw new ServiceException(e, RB.getStringResource("UserService.prflstrerr.ex.msg.txt"));
        }
        catch (InvocationTargetException e) {
            throw new ServiceException(e, RB.getStringResource("UserService.prflstrerr.ex.msg.txt"));
        }
        catch (IllegalAccessException e) {
            throw new ServiceException(e, RB.getStringResource("UserService.prflstrerr.ex.msg.txt"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getLoginConfigAppName() throws ServiceException, RemoteException {
        int[] nArray = this.cxGate;
        synchronized (this.cxGate) {
            if (this._loginConfigAppName == null) {
                LocalDiscoveryServiceInterface discoService = DiscoveryService.defaultInstance();
                Class[] authServiceClassArr = new Class[]{AuthenticationServiceInterface.class};
                ServiceTemplate authServiceTemplate = new ServiceTemplate(authServiceClassArr);
                AuthenticationServiceInterface authService = (AuthenticationServiceInterface)discoService.findService(authServiceTemplate);
                this._loginConfigAppName = authService.getLoginConfigAppName();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this._loginConfigAppName;
        }
    }

    @Override
    public List getRoles() throws ServiceException, RemoteException {
        return new ArrayList<String>(this._roleList);
    }

    @Override
    public boolean isInAnyRole(List roleList) throws ServiceException, RemoteException {
        boolean result = false;
        Iterator it = roleList.iterator();
        while (it.hasNext()) {
            if (!this._roleList.contains(it.next())) continue;
            result = true;
        }
        return result;
    }

    @Override
    public boolean isInRole(String role) throws ServiceException, RemoteException {
        return this._roleList.contains(role);
    }

    @Override
    public List getActions(String appName) throws ServiceException, RemoteException {
        return this.getActions(appName, true);
    }

    @Override
    public List getActions(String appName, boolean onlyGrantedActions) throws ServiceException, RemoteException {
        if (appName == null) {
            return Collections.emptyList();
        }
        ArrayList<ApplicationAuthorization> actionAuths = new ArrayList<ApplicationAuthorization>();
        List actionAuthsAll = null;
        if (this._actionMap.containsKey(appName)) {
            actionAuthsAll = this._actionMap.get(appName);
        } else {
            ServerInterface authServer = this.getAuthServer();
            RepositoryInterface repository = authServer.getFoundationRepository();
            if (repository == null) {
                return actionAuths;
            }
            Filter filter = new Filter();
            FilterComponent fc1 = new FilterComponent("Name", 0, appName);
            FilterComponent fc2 = new FilterComponent("PublicType", 0, "Application");
            fc1.setAggregation(0);
            fc1.addComponent(fc2);
            filter.setFilterComponent(fc1);
            filter.setType("SoftwareComponent");
            filter.addProtocol("omi");
            List softwareComponents = repository.search(filter);
            if (softwareComponents.size() > 0) {
                SoftwareComponentInterface softwareComponent = (SoftwareComponentInterface)softwareComponents.get(0);
                MetadataServerInterface metadataServer = (MetadataServerInterface)authServer;
                actionAuthsAll = metadataServer.getApplicationActionsAuthorizations(softwareComponent);
                this._actionMap.put(appName, actionAuthsAll);
            }
        }
        if (actionAuthsAll != null) {
            for (ApplicationAuthorization actionAuth : actionAuthsAll) {
                if (onlyGrantedActions && !actionAuth.isGranted()) continue;
                actionAuths.add(actionAuth);
            }
        }
        return actionAuths;
    }

    @Override
    public Map<String, ApplicationAuthorization> getGrantedApplicationActions(String ... applicationName) throws ServiceException, RemoteException {
        if (applicationName.length == 0) {
            return Collections.emptyMap();
        }
        HashMap<String, ApplicationAuthorization> grantedActions = new HashMap();
        for (String name : applicationName) {
            List actions = this.getActions(name, true);
            for (ApplicationAuthorization action : actions) {
                if (grantedActions.containsKey(action.getActionIdentifier())) continue;
                grantedActions.put(action.getActionIdentifier(), action);
            }
        }
        grantedActions = Collections.unmodifiableMap(grantedActions);
        return grantedActions;
    }

    @Override
    public boolean hasCapability(String appName, String action) throws ServiceException, RemoteException {
        boolean hasCapability = false;
        if (appName == null || action == null) {
            return false;
        }
        List actionAuths = this.getActions(appName, true);
        for (ApplicationAuthorization actionAuth : actionAuths) {
            if (!actionAuth.getActionIdentifier().equals(action)) continue;
            hasCapability = true;
            break;
        }
        return hasCapability;
    }

    @Override
    public boolean isInGroup(String group) throws ServiceException, RemoteException {
        this.initializeGroups();
        return this._groupList.contains(group);
    }

    @Override
    public boolean isInAnyGroup(List groupList) throws ServiceException, RemoteException {
        this.initializeGroups();
        boolean result = false;
        Iterator it = groupList.iterator();
        while (it.hasNext()) {
            if (!this._groupList.contains(it.next())) continue;
            result = true;
        }
        return result;
    }

    @Override
    public List getGroups() throws ServiceException, RemoteException {
        this.initializeGroups();
        return new ArrayList<String>(this._groupList);
    }

    private void initializeGroups() throws ServiceException, RemoteException {
        if (this.memberships == null) {
            this.memberships = this._person != null ? this._person.getIdentityMembershipLevels() : new ArrayList<IdentityMembershipInterface>();
        }
        if (this._groupList == null) {
            this._groupList = new ArrayList<String>();
            for (IdentityMembershipInterface membership : this.memberships) {
                this._groupList.add(membership.getIdentity().getName());
            }
        }
    }

    private LoginContext createLoginContext(String loginConfigAppName) throws RemoteException, LoginException {
        LoginContext loginContext = null;
        String envKey = "ENVIRONMENT";
        Environment environment = (Environment)this.getSharedResource(envKey);
        List<AppConfigurationEntry> entryLst = environment.getAppConfigurationEntry(loginConfigAppName);
        if (entryLst == null) {
            throw new LoginException(Message.format((ResourceBundle)RB.getResources(), (String)"UserContext.nojaas.fmt.txt", (Object)loginConfigAppName));
        }
        int entryLstL = entryLst.size();
        AppConfigurationEntry[] entryArr = new AppConfigurationEntry[entryLstL];
        entryArr = entryLst.toArray(entryArr);
        MyConfiguration myConfig = new MyConfiguration(loginConfigAppName, entryArr);
        loginContext = new LoginContext(loginConfigAppName, null, this._handler, myConfig);
        return loginContext;
    }

    public MdCredential requestCredentials(String authDomain, boolean issueChallenge, String prompt) throws RemoteException, MdException {
        MdCredential result;
        block4: {
            result = null;
            try {
                UserIdentityInterface uI = this.getIdentityByDomain(authDomain, issueChallenge, prompt);
                if (uI == null) {
                    return null;
                }
                result = new MdCredential(uI.getPrincipal().toString(), uI.getCredential().toString());
            }
            catch (CallbackCancelledException ex) {
                throw new MdCallbackCancelledException(ex.getMessage());
            }
            catch (ServiceException ex) {
                if (this._logger == null || !this._logger.isInfoEnabled()) break block4;
                this._logger.info(ex.getMessage(), (Throwable)((Object)ex));
            }
        }
        return result;
    }

    public List requestCredentialList(String authDomain, boolean issueChallenge, String prompt) throws RemoteException, MdException {
        ArrayList<MdCredential> result;
        block6: {
            result = null;
            try {
                List identList = this.getIdentitiesByDomain(authDomain, issueChallenge, prompt);
                if (identList == null || identList.size() == 0) {
                    return null;
                }
                if (result == null) {
                    result = new ArrayList<MdCredential>();
                }
                for (UserIdentityInterface uI : identList) {
                    result.add(new MdCredential(uI.getPrincipal().toString(), uI.getCredential().toString()));
                }
            }
            catch (CallbackCancelledException ex) {
                throw new MdCallbackCancelledException(ex.getMessage());
            }
            catch (ServiceException ex) {
                if (this._logger == null || !this._logger.isInfoEnabled()) break block6;
                this._logger.info(ex.getMessage(), (Throwable)((Object)ex));
            }
        }
        return result;
    }

    @Override
    public final String getResolvedUserId() throws ServiceException, RemoteException {
        return this._resolvedId;
    }

    @Override
    public final boolean isInternalUser() throws ServiceException, RemoteException {
        return this._isInternalUser;
    }

    @Override
    public Locale getLocale() throws ServiceException, RemoteException {
        if (this._person == null) {
            if (this._locale != null) {
                return this._locale;
            }
            return Locale.getDefault();
        }
        GlobalProfileInterface gp = (GlobalProfileInterface)this.getProfile();
        if (gp != null) {
            try {
                Locale mylocale = gp.getLocale();
                if (mylocale != null) {
                    return mylocale;
                }
            }
            catch (ServiceException serviceException) {
                // empty catch block
            }
        }
        if (this._locale != null) {
            return this._locale;
        }
        return Locale.getDefault();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enableLocalAdminMode(String authDomain) throws ServiceException, RemoteException {
        List<String> list = this._domainList;
        synchronized (list) {
            this._domainList.remove(authDomain);
        }
        this.getUserCredentialsForDomain(authDomain);
        Iterator<UserIdentityInterface> it = this._identities.iterator();
        while (it.hasNext()) {
            try {
                SimpleUserIdentity ident = (SimpleUserIdentity)it.next();
                if (!ident.isPrimary()) continue;
                ident.setSticky(true);
                break;
            }
            catch (ClassCastException classCastException) {
            }
        }
    }

    @Override
    public void setLocale(Locale locale) throws ServiceException, RemoteException {
        if (this._person == null) {
            this._locale = locale;
            return;
        }
        boolean localeSet = false;
        try {
            String profileClassName;
            GlobalProfileInterface gp = (GlobalProfileInterface)this.getProfile();
            ProfileInterface sasProfile = gp.getProfile("SAS");
            if (sasProfile != null && "com.sas.preferences.SASProfile".equals(profileClassName = sasProfile.getClass().getName())) {
                Method method = sasProfile.getClass().getMethod("setClientLocale", Locale.class);
                method.setAccessible(true);
                method.invoke((Object)sasProfile, locale);
                localeSet = true;
            }
            if (!localeSet) {
                gp.setLocale(locale);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this._locale = locale;
    }

    private SSPISecurityParams getSSPIParams() throws RemoteException {
        SSPISecurityParams result = new SSPISecurityParams();
        try {
            result.setLoginConfigAppName(this.getLoginConfigAppName());
        }
        catch (ServiceException se) {
            IllegalStateException ise = new IllegalStateException();
            ise.initCause((Throwable)((Object)se));
            throw ise;
        }
        String envKey = "ENVIRONMENT";
        Environment environment = (Environment)this.getSharedResource(envKey);
        List<AppConfigurationEntry> entries = environment.getAppConfigurationEntry(result.getLoginConfigAppName());
        int numEntries = entries != null ? entries.size() : 0;
        for (int i = 0; i < numEntries; ++i) {
            AppConfigurationEntry entry = entries.get(i);
            Map map = entry.getOptions();
            if (!OMILoginModule.isIDPropagation((Map)(map = LoginCallbackHandler.getDelegateOptionMap(map)))) continue;
            String idp = (String)map.get("idpropagation");
            result.setIdpMechanism(OMILoginModule.normalizeIDPropagation((String)idp));
            result.setIdpDomain((String)map.get("domain"));
            result.setSspiSecurityPackageList((String)map.get("sspisecuritypackagelist"));
            result.setSspiSPN((String)map.get("sspispn"));
            break;
        }
        return result;
    }

    private ServerDef getServerDef(OMIServerPrincipal osp) throws ServiceException, RemoteException {
        InformationServiceInterface isi = UserContext.getInformationService();
        ServerDef theDef = null;
        List defs = isi.getServerDefs();
        for (ServerDef serverDef : defs) {
            if (!serverDef.getHost().equalsIgnoreCase(osp.getHost()) || Integer.parseInt(serverDef.getPort()) != osp.getPort() || !serverDef.getDomain().equalsIgnoreCase(osp.getDomain()) || !serverDef.getProtocol().equals(osp.getProtocol())) continue;
            theDef = serverDef;
        }
        return theDef;
    }

    private boolean isConnectionException(Throwable ex) {
        String mexMessage = ex.getMessage();
        return mexMessage != null && (mexMessage.indexOf(EX_MSG_EOFEXCEPTION) > -1 || mexMessage.indexOf(EX_MSG_SOCKETEXCEPTION) > -1 || mexMessage.indexOf(EX_MSG_CONNECTIONABORT) > -1) || this.ioExceptionInChain(ex);
    }

    private boolean ioExceptionInChain(Throwable ex) {
        while (ex != null) {
            if (ex instanceof IOException) {
                return true;
            }
            Throwable t = ex.getCause();
            if (t == ex) break;
            ex = t;
        }
        return false;
    }

    private void setClientApplicationName(String applicationName) {
        if (applicationName == null || applicationName.length() == 0) {
            return;
        }
        try {
            if (clientApplicationNameClass == null) {
                clientApplicationNameClass = Class.forName(clientApplicationNameClassName);
            }
            if (clientApplicationNameSetMethod == null) {
                clientApplicationNameSetMethod = clientApplicationNameClass.getMethod("set", String.class);
            }
            clientApplicationNameSetMethod.invoke(clientApplicationNameClass, applicationName);
            this._iSetApplicationName = true;
        }
        catch (IllegalAccessException ex) {
            this._logger.warn(ex.getMessage(), (Throwable)ex);
        }
        catch (InvocationTargetException ex) {
            this._logger.warn(ex.getMessage(), (Throwable)ex);
        }
        catch (ClassNotFoundException cnfe) {
            this._logger.warn(cnfe.getMessage(), (Throwable)cnfe);
        }
        catch (NoSuchMethodException nsme) {
            String msg = "set(String) method not found on com.sas.framework.commons.holders.ClientApplicationNameHolder";
            this._logger.warn(msg, (Throwable)nsme);
        }
    }

    private void clearClientApplicationName() {
        Object clearMethod = null;
        if (!this._iSetApplicationName) {
            return;
        }
        try {
            if (clientApplicationNameClass == null) {
                clientApplicationNameClass = Class.forName(clientApplicationNameClassName);
            }
            if (clientApplicationNameClearMethod == null) {
                clientApplicationNameClearMethod = clientApplicationNameClass.getMethod("clear", new Class[0]);
            }
            clientApplicationNameClearMethod.invoke(clientApplicationNameClass, new Object[0]);
            this._iSetApplicationName = false;
        }
        catch (IllegalAccessException ex) {
            this._logger.warn(ex.getMessage(), (Throwable)ex);
        }
        catch (InvocationTargetException ex) {
            this._logger.warn(ex.getMessage(), (Throwable)ex);
        }
        catch (ClassNotFoundException cnfe) {
            this._logger.warn(cnfe.getMessage(), (Throwable)cnfe);
        }
        catch (NoSuchMethodException nsme) {
            String msg = "clear() method not found on com.sas.framework.commons.holders.ClientApplicationNameHolder";
            this._logger.warn(msg, (Throwable)nsme);
        }
    }

    class SSPISecurityParams {
        private String idpMechanism = null;
        private String idpDomain = null;
        private String sspiSecurityPackageList = null;
        private String sspiSPN = null;
        private String loginConfigAppName = null;

        public String getIdpMechanism() {
            return this.idpMechanism;
        }

        public void setIdpMechanism(String idpMechanism) {
            this.idpMechanism = idpMechanism;
        }

        public String getIdpDomain() {
            return this.idpDomain;
        }

        public void setIdpDomain(String idpDomain) {
            this.idpDomain = idpDomain;
        }

        public String getSspiSecurityPackageList() {
            return this.sspiSecurityPackageList;
        }

        public void setSspiSecurityPackageList(String sspiSecurityPackageList) {
            this.sspiSecurityPackageList = sspiSecurityPackageList;
        }

        public String getSspiSPN() {
            return this.sspiSPN;
        }

        public void setSspiSPN(String sspiSPN) {
            this.sspiSPN = sspiSPN;
        }

        public String getLoginConfigAppName() {
            return this.loginConfigAppName;
        }

        public void setLoginConfigAppName(String loginConfigAppName) {
            this.loginConfigAppName = loginConfigAppName;
        }
    }

    class GetCredentialPrivilegedAction
    implements PrivilegedExceptionAction {
        Subject theSubject = null;

        public GetCredentialPrivilegedAction(Subject subject) {
            this.theSubject = subject;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object run() throws Exception {
            boolean first = true;
            Iterator<Object> credIt = this.theSubject.getPrivateCredentials().iterator();
            while (credIt.hasNext()) {
                try {
                    PFSCredential pc = (PFSCredential)credIt.next();
                    String pw = null;
                    try {
                        pw = SasPasswordString.decode((String)pc.getPassword());
                    }
                    catch (SasPasswordEncodingException spee) {
                        pw = pc.getPassword();
                    }
                    SimpleUserIdentity sui = new SimpleUserIdentity(pc.getUserId(), pw, pc.getDomain(), first);
                    first = false;
                    UserContext.this.addIdentity(sui);
                    List list = UserContext.this._domainList;
                    synchronized (list) {
                        if (pc.getPassword() != null && pc.getPassword().trim().length() > 0) {
                            UserContext.this._domainList.add(pc.getDomain());
                        }
                    }
                }
                catch (ClassCastException classCastException) {
                }
            }
            return null;
        }
    }

    private static class MyConfiguration
    extends Configuration {
        private static final String _other = "other";
        private final String _name;
        private final AppConfigurationEntry[] _appConfigurationEntry;

        private MyConfiguration(String name, AppConfigurationEntry[] appConfigurationEntry) {
            this._name = name;
            this._appConfigurationEntry = appConfigurationEntry;
        }

        @Override
        public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
            return this._name.equals(name) || _other.equals(name) ? this._appConfigurationEntry : null;
        }

        @Override
        public void refresh() {
        }
    }
}

