/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.user;

import com.sas.codepolicy.SASScope;
import com.sas.net.ssl.SSLRMISocketFactories;
import com.sas.services.ServiceException;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.user.ProfileDomain;
import com.sas.services.user.ProfileInterface;
import com.sas.services.user.ProfileStoreInterface;
import com.sas.services.user.RB;
import com.sas.services.user.UserContext;
import com.sas.services.user.UserContextInterface;
import com.sas.services.user.UserServiceInterface;
import com.sas.services.user.omi.OMIProfileStore;
import com.sas.text.Message;
import java.lang.reflect.Constructor;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SASScope(value="ALL")
public class Profile
extends UnicastRemoteObject
implements ProfileInterface {
    private static final long serialVersionUID = -2242693492676311250L;
    private static final int SUBPROFILE_MAP_INIT = 8;
    private static final int ATTRIBUTE_MAP_INIT = 48;
    private static final int EMPTY_LIST_INIT = 1;
    private static final int PATH_BUFFER_INIT = 64;
    @SASScope
    protected UserContextInterface _userContext;
    @SASScope
    protected ProfileInterface _parent;
    @SASScope
    protected HashMap _subProfiles;
    @SASScope
    protected HashMap _attributes;
    @SASScope
    protected String _application;
    @SASScope
    protected ProfileStoreInterface _backEnd;
    @SASScope
    protected boolean _isLoaded;
    @SASScope
    protected boolean _isLoading;
    @SASScope
    protected boolean _needsReload;
    @SASScope
    protected boolean _isDirty;
    @SASScope
    protected long _refreshCycle = -1L;
    @SASScope
    protected long _lastRefresh;

    protected Profile() throws RemoteException {
        this("");
    }

    public Profile(String application) throws RemoteException {
        this(application, Profile.class);
    }

    protected Profile(String application, Class subClass) throws RemoteException {
        this(subClass);
        this._isLoaded = false;
        this._isLoading = false;
        this._subProfiles = new HashMap(8);
        this._attributes = new HashMap(48);
        this._application = application;
        this._isDirty = false;
        this._needsReload = false;
    }

    protected Profile(Class theClass) throws RemoteException {
        super(SSLRMISocketFactories.getInstance().getPortForClass(0, theClass), SSLRMISocketFactories.getInstance().getRMIClientSocketFactoryForClass(theClass), SSLRMISocketFactories.getInstance().getRMIServerSocketFactoryForClass(theClass));
    }

    @Override
    public void setRefreshCycle(long refreshInMillis) throws RemoteException {
        this._refreshCycle = refreshInMillis;
        for (ProfileInterface subPro : this._subProfiles.values()) {
            subPro.setRefreshCycle(refreshInMillis);
        }
    }

    @Override
    public boolean isLoaded() throws RemoteException {
        return this._isLoaded;
    }

    @Override
    public String getApplication() throws RemoteException {
        return this._application;
    }

    @Override
    public UserContextInterface getUserContext() throws RemoteException {
        return this._userContext;
    }

    @Override
    public Map getAllAttributes(String application) throws RemoteException, ServiceException {
        this.stateCheck();
        if (application == null || application.length() == 0) {
            return new HashMap(this._attributes);
        }
        int index = application.indexOf("/");
        String prokey = null;
        String remainder = null;
        if (index < 0) {
            prokey = application;
        } else {
            prokey = application.substring(0, index);
            remainder = application.substring(index + 1);
        }
        ProfileInterface pro = this.getMyProfile(prokey, true);
        if (pro == null) {
            throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"Profile.noprofapp.ex.fmt", (Object)prokey));
        }
        return pro.getAllAttributes(remainder);
    }

    @Override
    public String getAttribute(String application, String key) throws RemoteException, ServiceException {
        this.stateCheck();
        if (application == null || application.length() == 0) {
            List l = this.getAttribute(key);
            if (l == null || l.size() == 0) {
                return null;
            }
            return (String)l.get(0);
        }
        int index = application.indexOf("/");
        String prokey = null;
        String remainder = null;
        if (index < 0) {
            prokey = application;
        } else {
            prokey = application.substring(0, index);
            remainder = application.substring(index + 1);
        }
        ProfileInterface pro = this.getMyProfile(prokey, true);
        if (pro == null) {
            throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"Profile.noprofapp.ex.fmt", (Object)prokey));
        }
        String result = pro.getAttribute(remainder, key);
        if (result == null) {
            List rlist = this.getAttribute(key);
            if (rlist == null || rlist.size() == 0) {
                return null;
            }
            Object o = rlist.get(0);
            if (o instanceof String) {
                return (String)o;
            }
            return o.toString();
        }
        return result;
    }

    @Override
    public List getAttributes(String application, String key) throws RemoteException, ServiceException {
        this.stateCheck();
        if (application == null || application.length() == 0) {
            return this.getAttribute(key);
        }
        int index = application.indexOf("/");
        String prokey = null;
        String remainder = null;
        if (index < 0) {
            prokey = application;
        } else {
            prokey = application.substring(0, index);
            remainder = application.substring(index + 1);
        }
        if (prokey.equals("*")) {
            ArrayList list = new ArrayList(48);
            if (remainder == null) {
                list.addAll(this.getAttribute(key));
            }
            if (list == null) {
                list = new ArrayList(48);
            }
            for (ProfileInterface pro : this._subProfiles.values()) {
                List sublist = pro.getAttributes(remainder, key);
                list.addAll(sublist);
            }
            return list;
        }
        ProfileInterface p = this.getMyProfile(prokey, true);
        if (p == null) {
            throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"Profile.noprofapp.ex.fmt", (Object)prokey));
        }
        return p.getAttributes(remainder, key);
    }

    protected List getAttribute(String key) throws RemoteException {
        try {
            this.stateCheck();
        }
        catch (ServiceException serviceException) {
            // empty catch block
        }
        ArrayList list = (ArrayList)this._attributes.get(key);
        if (list == null) {
            list = new ArrayList(1);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized ProfileInterface getMyProfile(String application, boolean create) throws ServiceException, RemoteException {
        ProfileInterface p = null;
        if (this._subProfiles == null || this._backEnd == null || this._userContext == null) {
            return null;
        }
        p = (ProfileInterface)this._subProfiles.get(application);
        if (p == null && this._backEnd != null && (p = this._backEnd.loadSubprofile(application)) != null) {
            p.setParentProfile(this);
            this._subProfiles.put(application, p);
        }
        if (p == null && create) {
            UserContextInterface userContextInterface = this._userContext;
            synchronized (userContextInterface) {
                try {
                    UserServiceInterface usi = UserContext.getUserService();
                    ProfileDomain pd = usi.getProfileDefinition(application);
                    if (pd == null) {
                        pd = usi.getProfileDefinition("default");
                    }
                    if (pd == null) {
                        p = new Profile(application);
                    } else {
                        try {
                            ClassLoader cl = this.getClass().getClassLoader();
                            Class<?> objectClass = cl.loadClass(pd.getClassName());
                            Constructor<?> ctor = null;
                            Class[] ctorArgs = new Class[]{String.class};
                            ctor = objectClass.getConstructor(ctorArgs);
                            if (ctor != null) {
                                Object[] ctorParms = new Object[]{application};
                                p = (ProfileInterface)ctor.newInstance(ctorParms);
                            }
                        }
                        catch (Throwable t) {
                            p = new Profile(application);
                        }
                    }
                    if (p != null) {
                        this.createSubprofile(p);
                        this.addProfile(application, p, false);
                    }
                }
                catch (Throwable t) {
                    throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"Profile.noprofapp.ex.fmt", (Object)application));
                }
            }
        }
        if (p == null) {
            throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"Profile.noprofapp.ex.fmt", (Object)application));
        }
        return p;
    }

    @Override
    public ProfileInterface getProfile(String application) throws RemoteException, ServiceException {
        this.stateCheck();
        if (application == null) {
            return this;
        }
        if (application.length() == 0) {
            return this;
        }
        return this.getProfile(application, false);
    }

    @Override
    public ProfileInterface getProfile(String application, boolean create) throws RemoteException, ServiceException {
        this.stateCheck();
        if (application == null) {
            return this;
        }
        if (application.length() == 0) {
            return this;
        }
        int index = application.indexOf("/");
        String key = null;
        String remainder = null;
        if (index < 0) {
            key = application;
        } else {
            key = application.substring(0, index);
            remainder = application.substring(index + 1);
        }
        ProfileInterface p = this.getMyProfile(key, create);
        return p == null ? null : p.getProfile(remainder);
    }

    @Override
    public void setAttribute(String application, String key, String value) throws RemoteException, ServiceException {
        this.stateCheck();
        if (application == null || application.length() == 0) {
            this.setAttribute(key, value);
            return;
        }
        ProfileInterface p = this.getProfile(application);
        p.setAttribute(null, key, value);
    }

    protected void setAttribute(String key, String value) throws RemoteException {
        Object o;
        if (value != null && (value = value.trim()).length() == 0) {
            value = null;
        }
        if ((o = this._attributes.get(key)) == null) {
            if (value == null) {
                return;
            }
            ArrayList<String> list = new ArrayList<String>(48);
            list.add(value);
            this._attributes.put(key, list);
        } else {
            if (value == null) {
                this._attributes.remove(key);
                this._isDirty = true;
                return;
            }
            List list = (List)o;
            list.clear();
            list.add(value);
        }
        this._isDirty = true;
    }

    @Override
    public void removeAttribute(String application, String key) throws RemoteException, ServiceException {
        if (application == null || application.length() == 0) {
            this.removeAttribute(key);
            return;
        }
        ProfileInterface p = this.getProfile(application);
        p.removeAttribute(null, key);
    }

    protected void removeAttribute(String key) throws RemoteException {
        Object o = this._attributes.get(key);
        if (o == null) {
            return;
        }
        this._attributes.remove(key);
        this._isDirty = true;
    }

    @Override
    public void addAttribute(String application, String key, String value) throws RemoteException, ServiceException {
        this.stateCheck();
        if (application == null || application.length() == 0) {
            this.addAttribute(key, value);
            return;
        }
        ProfileInterface p = this.getProfile(application);
        if (p == null) {
            throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"Profile.noprofapp.ex.fmt", (Object)application));
        }
        p.addAttribute(null, key, value);
    }

    protected void addAttribute(String key, String value) throws RemoteException {
        if (value != null) {
            if ((value = value.trim()).length() == 0) {
                return;
            }
        } else {
            return;
        }
        Object o = this._attributes.get(key);
        if (o == null) {
            ArrayList<String> list = new ArrayList<String>(48);
            list.add(value);
            this._attributes.put(key, list);
        } else {
            List list = (List)o;
            list.add(value);
        }
        this._isDirty = true;
    }

    @Override
    public void setParentProfile(ProfileInterface parent) throws ServiceException, RemoteException {
        if (this._parent != null) {
            throw new IllegalStateException();
        }
        this._parent = parent;
    }

    @Override
    public ProfileInterface getParentProfile() throws ServiceException, RemoteException {
        return this._parent;
    }

    @Override
    public ProfileInterface getRootProfile() throws ServiceException, RemoteException {
        ProfileInterface pro = this;
        while (pro.getParentProfile() != null) {
            pro = pro.getParentProfile();
        }
        return pro;
    }

    @Override
    public String getPathFromRoot() throws ServiceException, RemoteException {
        StringBuffer buffer = new StringBuffer(64);
        ProfileInterface pro = this;
        while (pro.getParentProfile() != null) {
            buffer.insert(0, pro.getApplication() + (buffer.length() > 0 ? "/" : ""));
            pro = pro.getParentProfile();
        }
        return buffer.toString();
    }

    @Override
    public void createSubprofile(ProfileInterface profile) throws ServiceException, RemoteException {
        if (this._backEnd == null) {
            throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"Profile.nobackend.ex.fmt.txt", (Object)this._application));
        }
        if (this._backEnd.getRepositoryEntity() == null) {
            throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"Profile.noanchor.ex.fmt.txt", (Object)this._application));
        }
        String appName = profile.getApplication();
        ProfileInterface p = (ProfileInterface)this._subProfiles.get(appName);
        if (p != null) {
            throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"Profile.dupsubprof.ex.fmt.txt", (Object)appName, (Object)this.getApplication()));
        }
        this.stateCheck();
        profile.create(this._backEnd.getRepositoryEntity(), this._userContext, this._backEnd.getRepository(), null);
        this._subProfiles.put(appName, profile);
    }

    @Override
    public void addProfile(String application, ProfileInterface profile, boolean force) throws RemoteException, ServiceException {
        this.stateCheck();
        if (application == null) {
            throw new ServiceException(RB.getStringResource("Profile.nonullapp.ex.txt"));
        }
        if (application.length() == 0) {
            throw new ServiceException(RB.getStringResource("Profile.nozeroapp.ex.txt"));
        }
        int index = application.indexOf("/");
        if (index < 0) {
            ProfileInterface currentProfile = this.getMyProfile(application, true);
            if (currentProfile != null && !currentProfile.equals(profile)) {
                throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"Profile.dupsubprof.ex.fmt.txt", (Object)application, (Object)this.getApplication()));
            }
            this._subProfiles.put(application, profile);
            profile.setParentProfile(this);
        } else {
            String key = application.substring(0, index);
            String remainder = application.substring(index + 1);
            ProfileInterface p = this.getMyProfile(key, true);
            if (p == null) {
                if (!force) {
                    throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"Profile.noprofapp.ex.fmt", (Object)key));
                }
                p = new Profile(key);
                ProfileInterface currentProfile = this.getMyProfile(key, true);
                if (currentProfile != null && !currentProfile.equals(profile)) {
                    throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"Profile.dupsubprof.ex.fmt.txt", (Object)application, (Object)this.getApplication()));
                }
                this._subProfiles.put(key, p);
                p.setParentProfile(this);
            }
            p.addProfile(remainder, profile, force);
        }
    }

    @Override
    public void deleteProfile(String application) throws ServiceException, RemoteException {
        if (application == null || application.length() == 0) {
            if (this._parent != null) {
                this._parent.removeProfile(this._application);
            }
            this._backEnd.delete();
            return;
        }
        ProfileInterface theProfile = this.getProfile(application);
        theProfile.deleteProfile(null);
    }

    @Override
    public boolean removeProfile(String application) throws RemoteException, ServiceException {
        this.stateCheck();
        if (application == null) {
            throw new ServiceException(RB.getStringResource("Profile.nonullappr.ex.txt"));
        }
        if (application.length() == 0) {
            throw new ServiceException(RB.getStringResource("Profile.nozeroappr.ex.txt"));
        }
        int index = application.indexOf("/");
        if (index < 0) {
            return this._subProfiles.remove(application) != null;
        }
        String key = application.substring(0, index);
        String remainder = application.substring(index + 1);
        ProfileInterface p = (ProfileInterface)this._subProfiles.get(key);
        return p == null ? false : p.removeProfile(remainder);
    }

    @Override
    public Set keySet() throws RemoteException {
        try {
            this.stateCheck();
        }
        catch (ServiceException serviceException) {
            // empty catch block
        }
        return this._attributes.keySet();
    }

    @Override
    public Collection values() throws RemoteException {
        try {
            this.stateCheck();
        }
        catch (ServiceException serviceException) {
            // empty catch block
        }
        return this._attributes.values();
    }

    @Override
    public void persist(String application, boolean recursive) throws RemoteException, ServiceException {
        if (application == null || application.length() == 0) {
            if (this._backEnd != null) {
                if (this._isDirty) {
                    this._backEnd.persist();
                }
            } else {
                throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"Profile.nobackend.ex.fmt.txt", (Object)this._application));
            }
            if (recursive) {
                for (ProfileInterface pro : this._subProfiles.values()) {
                    pro.persist(null, recursive);
                }
            }
        } else {
            ProfileInterface p = this.getProfile(application);
            p.persist(null, recursive);
        }
        this._isDirty = false;
    }

    private void stateCheck() throws ServiceException, RemoteException {
        if (this._application == null && this._attributes == null && this._backEnd == null && this._parent == null) {
            throw new IllegalStateException(RB.getStringResource("UserContext.isdestroyed.msg.txt"));
        }
        if (this._isLoading) {
            return;
        }
        if (!this.isLoaded()) {
            this._isLoading = true;
            try {
                this.load();
            }
            finally {
                this._isLoading = false;
            }
            return;
        }
        if (this.needReload()) {
            this.reload();
        }
    }

    @Override
    public void refresh() throws ServiceException, RemoteException {
        if (this._backEnd == null) {
            throw new ServiceException();
        }
        this._needsReload = true;
        for (ProfileInterface pro : this._subProfiles.values()) {
            pro.refresh();
        }
    }

    protected boolean needReload() throws ServiceException, RemoteException {
        if (this._backEnd == null) {
            return false;
        }
        if (this._needsReload) {
            return true;
        }
        return this._refreshCycle >= 0L && this._lastRefresh + this._refreshCycle < System.currentTimeMillis();
    }

    protected void reload() throws ServiceException, RemoteException {
        if (this._backEnd == null) {
            return;
        }
        this._needsReload = false;
        this._attributes = new HashMap(48);
        this._isLoading = true;
        try {
            this._backEnd.refresh();
        }
        finally {
            this._isLoading = false;
        }
        this._lastRefresh = System.currentTimeMillis();
    }

    @Override
    public void setLoadParameters(MetadataInterface root, UserContextInterface user, RepositoryInterface repos, ProfileDomain pd) throws RemoteException, ServiceException {
        this._userContext = user;
        this.makeBackEnd(root, repos);
    }

    private void makeBackEnd(MetadataInterface root, RepositoryInterface repos) throws ServiceException {
        this._backEnd = new OMIProfileStore(root, this, repos);
    }

    @Override
    public void load(MetadataInterface root, UserContextInterface user, RepositoryInterface repos, ProfileDomain pd) throws RemoteException, ServiceException {
        this.setLoadParameters(root, user, repos, pd);
        this.load();
    }

    private void load() throws RemoteException, ServiceException {
        this._attributes.clear();
        if (this._backEnd == null) {
            throw new ServiceException(RB.getStringResource("Profile.nobackend.ex.txt"));
        }
        try {
            this._backEnd.load();
        }
        catch (Throwable t) {
            this._backEnd = null;
            if (t instanceof ServiceException) {
                throw (ServiceException)((Object)t);
            }
            throw new ServiceException(t, RB.getStringResource("Profile.loaderr.ex.txt") + ":  " + t.getMessage());
        }
        this._isLoaded = true;
        this._isDirty = false;
        this._lastRefresh = System.currentTimeMillis();
    }

    @Override
    public void create(MetadataInterface root, UserContextInterface user, RepositoryInterface repos, ProfileDomain pd) throws RemoteException, ServiceException {
        this._userContext = user;
        this.makeBackEnd(root, repos);
        try {
            this._backEnd.create();
        }
        catch (Throwable t) {
            throw new ServiceException(t, RB.getStringResource("Profile.loaderr.ex.txt"));
        }
    }

    @Override
    public void setLocale(String application, Locale locale) throws ServiceException, RemoteException {
        String localeString = locale == null ? null : locale.toString();
        this.setAttribute(application, "locale", localeString);
    }

    @Override
    public Locale getLocale(String application) throws ServiceException, RemoteException {
        String localeString = this.getAttribute(application, "locale");
        return this.attribute2Locale(localeString);
    }

    protected Locale attribute2Locale(String localeString) throws RemoteException {
        if (localeString == null) {
            return null;
        }
        Locale locale = null;
        StringTokenizer st = new StringTokenizer(localeString, "_");
        int tokenCount = st.countTokens();
        String[] tokens = new String[tokenCount];
        for (int i = 0; i < tokenCount; ++i) {
            tokens[i] = st.nextToken();
        }
        switch (tokenCount) {
            case 1: {
                locale = new Locale(tokens[0], "");
                break;
            }
            case 2: {
                locale = new Locale(tokens[0], tokens[1]);
                break;
            }
            case 3: {
                locale = new Locale(tokens[0], tokens[1], tokens[2]);
                break;
            }
            case 4: {
                locale = new Locale(tokens[0], tokens[1], tokens[2] + '_' + tokens[3]);
            }
        }
        return locale;
    }

    @Override
    public void destroy() throws RemoteException {
        block6: {
            if (this._subProfiles != null) {
                for (ProfileInterface pro : this._subProfiles.values()) {
                    pro.destroy();
                }
                this._subProfiles.clear();
                this._subProfiles = null;
            }
            if (this._attributes != null) {
                this._attributes.clear();
                this._attributes = null;
            }
            if (this._backEnd != null) {
                this._backEnd.destroy();
                this._backEnd = null;
            }
            this._application = null;
            this._parent = null;
            try {
                UnicastRemoteObject.unexportObject(this, true);
            }
            catch (Exception e) {
                Logger logger = LogManager.getLogger((String)"com.sas.services.user.Profile");
                if (!logger.isDebugEnabled()) break block6;
                logger.debug("Object export failed");
            }
        }
        this._userContext = null;
    }
}

