/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.session;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.services.InitializationException;
import com.sas.services.QuiesceException;
import com.sas.services.ServiceException;
import com.sas.services.ServiceProxy;
import com.sas.services.session.SessionContextInterface;
import com.sas.services.session.SessionServiceInterface;
import com.sas.services.user.UserContextInterface;
import java.io.Serializable;
import java.rmi.ConnectException;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.util.List;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public class SessionServiceProxy
extends ServiceProxy
implements SessionServiceInterface,
Serializable {
    private static final long serialVersionUID = 3648277038724301096L;

    public SessionServiceProxy(SessionServiceInterface sessionService) throws InitializationException {
        super(sessionService);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final SessionContextInterface newSessionContext(UserContextInterface userContext) throws InitializationException, RemoteException {
        SessionContextInterface sessionContext = null;
        SessionServiceInterface service = this.getSessionService();
        RemoteException remoteException = null;
        try {
            sessionContext = service.newSessionContext(userContext);
        }
        catch (ConnectException e) {
            remoteException = e;
        }
        catch (NoSuchObjectException e) {
            remoteException = e;
        }
        finally {
            if (remoteException != null) {
                try {
                    sessionContext = this.findSessionService().newSessionContext(userContext);
                }
                catch (ServiceException ex) {
                    throw remoteException;
                }
            }
        }
        return sessionContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final SessionContextInterface getSessionContext(String uniqueId) throws RemoteException {
        SessionContextInterface sessionContext = null;
        SessionServiceInterface service = this.getSessionService();
        RemoteException remoteException = null;
        try {
            sessionContext = service.getSessionContext(uniqueId);
        }
        catch (ConnectException e) {
            remoteException = e;
        }
        catch (NoSuchObjectException e) {
            remoteException = e;
        }
        finally {
            if (remoteException != null) {
                try {
                    sessionContext = this.findSessionService().getSessionContext(uniqueId);
                }
                catch (ServiceException ex) {
                    throw remoteException;
                }
            }
        }
        return sessionContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final SessionContextInterface getSessionContext(UserContextInterface userContext, String uniqueId) throws RemoteException {
        SessionContextInterface sessionContext = null;
        SessionServiceInterface service = this.getSessionService();
        RemoteException remoteException = null;
        try {
            sessionContext = service.getSessionContext(userContext, uniqueId);
        }
        catch (ConnectException e) {
            remoteException = e;
        }
        catch (NoSuchObjectException e) {
            remoteException = e;
        }
        finally {
            if (remoteException != null) {
                try {
                    sessionContext = this.findSessionService().getSessionContext(userContext, uniqueId);
                }
                catch (ServiceException ex) {
                    throw remoteException;
                }
            }
        }
        return sessionContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void quiesce(UserContextInterface userContext) throws ServiceException, QuiesceException, RemoteException {
        SessionServiceInterface service = this.getSessionService();
        RemoteException remoteException = null;
        try {
            service.quiesce(userContext);
        }
        catch (ConnectException e) {
            remoteException = e;
        }
        catch (NoSuchObjectException e) {
            remoteException = e;
        }
        finally {
            if (remoteException != null) {
                this.findSessionService().quiesce(userContext);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isQuiesced() throws RemoteException {
        boolean quiesced = false;
        SessionServiceInterface service = this.getSessionService();
        RemoteException remoteException = null;
        try {
            quiesced = service.isQuiesced();
        }
        catch (ConnectException e) {
            remoteException = e;
        }
        catch (NoSuchObjectException e) {
            remoteException = e;
        }
        finally {
            if (remoteException != null) {
                try {
                    quiesced = this.findSessionService().isQuiesced();
                }
                catch (ServiceException ex) {
                    throw remoteException;
                }
            }
        }
        return quiesced;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void resume(UserContextInterface userContext) throws ServiceException, QuiesceException, RemoteException {
        SessionServiceInterface service = this.getSessionService();
        RemoteException remoteException = null;
        try {
            service.resume(userContext);
        }
        catch (ConnectException e) {
            remoteException = e;
        }
        catch (NoSuchObjectException e) {
            remoteException = e;
        }
        finally {
            if (remoteException != null) {
                this.findSessionService().resume(userContext);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroySessions(UserContextInterface userContext) throws RemoteException {
        SessionServiceInterface service = this.getSessionService();
        RemoteException remoteException = null;
        try {
            service.destroySessions(userContext);
        }
        catch (ConnectException e) {
            remoteException = e;
        }
        catch (NoSuchObjectException e) {
            remoteException = e;
        }
        finally {
            if (remoteException != null) {
                try {
                    this.findSessionService().destroySessions(userContext);
                }
                catch (ServiceException ex) {
                    throw remoteException;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean destroySession(UserContextInterface userContext, String sessionContextId) throws RemoteException {
        boolean found = false;
        SessionServiceInterface service = this.getSessionService();
        RemoteException remoteException = null;
        try {
            found = service.destroySession(userContext, sessionContextId);
        }
        catch (ConnectException e) {
            remoteException = e;
        }
        catch (NoSuchObjectException e) {
            remoteException = e;
        }
        finally {
            if (remoteException != null) {
                try {
                    found = this.findSessionService().destroySession(userContext, sessionContextId);
                }
                catch (ServiceException ex) {
                    throw remoteException;
                }
            }
        }
        return found;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getSummaryData(UserContextInterface userContext) throws RemoteException {
        List list = null;
        SessionServiceInterface service = this.getSessionService();
        RemoteException remoteException = null;
        try {
            list = service.getSummaryData(userContext);
        }
        catch (ConnectException e) {
            remoteException = e;
        }
        catch (NoSuchObjectException e) {
            remoteException = e;
        }
        finally {
            if (remoteException != null) {
                try {
                    list = this.findSessionService().getSummaryData(userContext);
                }
                catch (ServiceException ex) {
                    throw remoteException;
                }
            }
        }
        return list;
    }

    private final SessionServiceInterface getSessionService() {
        return (SessionServiceInterface)this.getService();
    }

    private final SessionServiceInterface findSessionService() throws ServiceException, RemoteException {
        return (SessionServiceInterface)this.findRemoteService();
    }

    @Override
    public SessionContextInterface fromByteArray(byte[] data) throws RemoteException, ServiceException {
        SessionContextInterface result = null;
        SessionServiceInterface service = this.getSessionService();
        if (service != null) {
            result = service.fromByteArray(data);
        }
        return result;
    }
}

