/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.session;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.entities.EntityKeyInterface;
import com.sas.net.rmi.RemoteObjectExporterInterface;
import com.sas.net.rmi.UnicastRemoteObjectExporter;
import com.sas.net.ssl.SSLRMISocketFactories;
import com.sas.services.AbstractRemoteService;
import com.sas.services.InitializationException;
import com.sas.services.QuiesceException;
import com.sas.services.RemoteServiceInterface;
import com.sas.services.ServiceConfigurationInterface;
import com.sas.services.ServiceException;
import com.sas.services.ServiceInitializationObject;
import com.sas.services.ServiceState;
import com.sas.services.discovery.DiscoveryService;
import com.sas.services.discovery.DiscoveryServiceInterface;
import com.sas.services.discovery.ServiceNotAvailableException;
import com.sas.services.discovery.ServiceTemplate;
import com.sas.services.information.metadata.IdentityInterface;
import com.sas.services.information.metadata.PersonInterface;
import com.sas.services.security.SecurityUtil;
import com.sas.services.session.RB;
import com.sas.services.session.RemoteSessionContextStateChangedListener;
import com.sas.services.session.SessionContext;
import com.sas.services.session.SessionContextDeferredMap;
import com.sas.services.session.SessionContextInterface;
import com.sas.services.session.SessionContextPermission;
import com.sas.services.session.SessionContextStateChangedEvent;
import com.sas.services.session.SessionPermission;
import com.sas.services.session.SessionServiceInitObject;
import com.sas.services.session.SessionServiceInitializer;
import com.sas.services.session.SessionServiceInterface;
import com.sas.services.session.SessionServiceMBean;
import com.sas.services.session.SessionServiceProxy;
import com.sas.services.session.SummaryData;
import com.sas.services.user.UserContextInterface;
import com.sas.services.user.UserServiceInterface;
import com.sas.services.util.JMXAgent;
import com.sas.services.util.JMXRegistration;
import com.sas.services.util.Names;
import com.sas.text.Message;
import java.io.ByteArrayInputStream;
import java.io.ObjectInputStream;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public class SessionService
extends AbstractRemoteService
implements SessionServiceInterface,
RemoteSessionContextStateChangedListener {
    private static HashMap _contexts = new HashMap();
    private static SessionServiceInterface _sessionService = null;
    private static SessionContextInterface _rootSessionContext = null;
    private static String _rootSessionContextUniqueId = null;
    private static Logger _logger = LogManager.getLogger(SessionService.class);
    private static Object _rootLockObject = null;
    private boolean _quiesce;
    private static SessionContextDeferredMap _deferredMap = null;
    private boolean _destroyed;
    private JMXRegistration _mbeanJMXRegistration;
    private static long _defaultSessionTimeout = -1L;
    private static Timer _timer = null;
    private static TimerTask _timerTask = null;
    private static final int TIMER_PERIOD = 120000;
    private static final int TIMER_DELAY = 120000;
    private static final String SESSION_CREATE_CONTEXT = "com.sas.services.session.SessionContext.create";
    public static final String RB_KEY = "SessionService.";
    public static final long serialVersionUID = -4154413008328811671L;

    private SessionService(ServiceConfigurationInterface serviceConfiguration, DiscoveryServiceInterface discoveryService) throws ServiceException {
        super(discoveryService);
        String mbeanObjectName;
        SSLRMISocketFactories sslRMISocketFactories = SSLRMISocketFactories.getInstance();
        Class<?> theClass = this.getClass();
        this.setRemoteableExporter((RemoteObjectExporterInterface)new UnicastRemoteObjectExporter((Remote)this, sslRMISocketFactories.getPortForClass(0, theClass), sslRMISocketFactories.getRMIClientSocketFactoryForClass(theClass), sslRMISocketFactories.getRMIServerSocketFactoryForClass(theClass), true));
        try {
            this.configure(serviceConfiguration);
        }
        catch (RemoteException e) {
            if (_logger != null) {
                _logger.fatal(RB.getStringResource(RB_KEY, "initRemoteException.txt"), (Throwable)e);
            }
            throw new ServiceException(RB.getStringResource(RB_KEY, "serviceCreation.serviceProviderException.ex.txt"));
        }
        JMXAgent agent = JMXAgent.getInstance();
        if (agent != null && agent.isMBeanEnabled(mbeanObjectName = Names.getObjectName("SessionService", this)) && null == this._mbeanJMXRegistration) {
            SessionServiceMBean mbean = new SessionServiceMBean();
            try {
                this._mbeanJMXRegistration = agent.registerMBean(mbean, mbeanObjectName);
            }
            catch (Exception e) {
                if (_logger != null) {
                    _logger.error(RB.getStringResource(RB_KEY, "jmxError.txt"), (Throwable)e);
                }
                System.err.println(RB.getStringResource(RB_KEY, "jmxError.txt"));
                e.printStackTrace();
            }
        }
    }

    @Override
    public void configure(ServiceConfigurationInterface serviceConfiguration) throws RemoteException, ServiceException {
        super.configure(serviceConfiguration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() throws ServiceException, RemoteException {
        JMXAgent agent;
        SessionService sessionService = this;
        synchronized (sessionService) {
            if (this._destroyed) {
                return;
            }
            this._destroyed = true;
        }
        if (null != this._mbeanJMXRegistration && (agent = JMXAgent.getInstance()) != null) {
            try {
                agent.unregisterMBeanUsingRegistration(this._mbeanJMXRegistration);
                this._mbeanJMXRegistration = null;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (_timer != null) {
            _timer.cancel();
            _timer = null;
        }
        if (!ServiceState.isStateDeactivated(this.getServiceState())) {
            try {
                if (_logger != null && _logger.isInfoEnabled()) {
                    _logger.info(RB.getStringResource(RB_KEY, "destroy.txt"));
                }
                if (_deferredMap != null) {
                    _deferredMap.destroy();
                    _deferredMap = null;
                }
                Iterator itor = null;
                SessionService sessionService2 = this;
                synchronized (sessionService2) {
                    itor = new ArrayList(_contexts.values()).iterator();
                    _contexts.clear();
                }
                while (itor.hasNext()) {
                    SessionContextInterface sessCtx = (SessionContextInterface)itor.next();
                    try {
                        if (sessCtx instanceof SessionContext) {
                            try {
                                ((SessionContext)sessCtx).forceDestroy();
                            }
                            catch (IllegalStateException illegalStateException) {}
                            continue;
                        }
                        sessCtx.destroy();
                    }
                    catch (Exception e) {
                        if (_logger == null || !_logger.isDebugEnabled()) continue;
                        _logger.debug(RB.getStringResource(RB_KEY, "destroyContextError.txt"), (Throwable)e);
                    }
                }
                if (_rootSessionContext != null) {
                    block34: {
                        block33: {
                            try {
                                _rootSessionContext.unlock(_rootLockObject);
                            }
                            catch (Exception e) {
                                if (_logger == null || !_logger.isDebugEnabled()) break block33;
                                _logger.debug(RB.getStringResource(RB_KEY, "unlockRootContextError.txt"), (Throwable)e);
                            }
                        }
                        try {
                            _rootSessionContext.destroy();
                        }
                        catch (Exception e) {
                            if (_logger == null || !_logger.isDebugEnabled()) break block34;
                            _logger.debug(RB.getStringResource(RB_KEY, "rootDestructionException.txt"), (Throwable)e);
                        }
                    }
                    _rootSessionContext = null;
                }
                _sessionService = null;
                if (_logger != null) {
                    if (_logger.isInfoEnabled()) {
                        _logger.info(RB.getStringResource(RB_KEY, "destroyComplete.txt"));
                    }
                    _logger = null;
                }
            }
            catch (Throwable t) {
                if (_logger != null) {
                    _logger.error(RB.getStringResource(RB_KEY, "destroyErr.txt"), t);
                }
            }
            finally {
                super.destroy();
            }
        }
    }

    public static SessionServiceInterface getInstance(ServiceConfigurationInterface serviceConfiguration) throws ServiceException {
        return SessionService.getInstance(serviceConfiguration, DiscoveryService.defaultInstance());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SessionServiceInterface getInstance(ServiceConfigurationInterface serviceConfiguration, DiscoveryServiceInterface discoveryService) throws ServiceException {
        try {
            SessionService.initSessionService(serviceConfiguration, discoveryService);
        }
        catch (ServiceException e) {
            if (_sessionService != null) {
                try {
                    _sessionService.destroy();
                }
                catch (RemoteException e2) {
                    LogManager.getLogger(SessionService.class).error(e2.getLocalizedMessage());
                }
                finally {
                    _sessionService = null;
                }
            }
            throw e;
        }
        return _sessionService;
    }

    private void createTimer() {
        int minSubsequentDelay = 900000;
        long initialDelay = _defaultSessionTimeout + 60000L;
        _timer = new Timer(true);
        _timerTask = new CheckSessionTimeouts(this);
        if (_defaultSessionTimeout > (long)minSubsequentDelay && (int)_defaultSessionTimeout / 4 > minSubsequentDelay) {
            minSubsequentDelay = (int)_defaultSessionTimeout / 4;
        }
        _timer.schedule(_timerTask, initialDelay, (long)minSubsequentDelay);
        if (_logger != null && _logger.isDebugEnabled()) {
            _logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"SessionService.delay.fmt.txt", (Object)minSubsequentDelay));
        }
    }

    public static final SessionContextInterface getRootSessionContext() {
        SessionContextPermission scp = new SessionContextPermission("read");
        SecurityUtil.checkPermission(null, scp);
        return _rootSessionContext;
    }

    public static final String getRootSessionContextEntityKey() throws RemoteException {
        String key = null;
        if (_rootSessionContext != null) {
            key = _rootSessionContext.getEntityKey();
        }
        return key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SessionContextInterface newSessionContext(UserContextInterface userContext) throws InitializationException, RemoteException, IllegalStateException {
        SessionContext sessCtx = null;
        if (this._destroyed) {
            throw new IllegalStateException(RB.getStringResource("SessionService.servicedestroyed.ex.txt"));
        }
        SessionService sessionService = this;
        synchronized (sessionService) {
            if (this._quiesce) {
                if (_logger != null) {
                    _logger.warn(RB.getStringResource(RB_KEY, "quiesce.ex.txt"));
                }
                QuiesceException qe = new QuiesceException(RB.getStringResource(RB_KEY, "quiesce.ex.txt"));
                throw new InitializationException((Throwable)((Object)qe), RB.getStringResource(RB_KEY, "quiesce.ex.txt"));
            }
            if (_timer == null && _defaultSessionTimeout != -1L) {
                this.createTimer();
            }
        }
        sessCtx = new SessionContext(this, _rootSessionContext, userContext);
        Logger logger = LogManager.getLogger((String)SessionContext.class.getName());
        if (logger == null) {
            throw new InitializationException(RB.getStringResource(RB_KEY, "loggerErr.ex.txt"));
        }
        sessCtx.setLogger(logger);
        if (userContext != null) {
            userContext.setSessionContext(sessCtx);
        }
        try {
            String uniqueId = sessCtx.getEntityKey();
            logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"SessionContext.sesscreat.fmt.txt", (Object)uniqueId), (Object)SESSION_CREATE_CONTEXT);
            SessionService sessionService2 = this;
            synchronized (sessionService2) {
                _contexts.put(uniqueId, sessCtx);
            }
        }
        catch (IllegalStateException e) {
            sessCtx = null;
            if (_logger != null) {
                _logger.error(RB.getStringResource(RB_KEY, "sessionContextError.txt"), (Throwable)e);
            }
            throw new InitializationException(RB.getStringResource(RB_KEY, "contextCreation.initializationException.ex.txt"));
        }
        return sessCtx;
    }

    @Override
    public SessionContextInterface getSessionContext(String uniqueId) throws RemoteException, IllegalStateException {
        if (this._destroyed) {
            throw new IllegalStateException(RB.getStringResource("SessionService.servicedestroyed.ex.txt"));
        }
        return this.getSessionContext(null, uniqueId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SessionContextInterface getSessionContext(UserContextInterface userContext, String uniqueId) throws RemoteException, IllegalStateException {
        if (this._destroyed) {
            throw new IllegalStateException(RB.getStringResource("SessionService.servicedestroyed.ex.txt"));
        }
        SessionContextInterface sessCtx = null;
        SessionContextPermission scp = new SessionContextPermission("read");
        SecurityUtil.checkPermission(userContext, scp);
        SessionService sessionService = this;
        synchronized (sessionService) {
            sessCtx = (SessionContextInterface)_contexts.get(uniqueId);
        }
        if (sessCtx == null && uniqueId.equals(_rootSessionContextUniqueId)) {
            sessCtx = _rootSessionContext;
        }
        return sessCtx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void contextStateChanged(SessionContextStateChangedEvent event) {
        block7: {
            int state = event.getStateChange();
            if (state == 2) {
                String uniqueId = null;
                SessionContextInterface sessionContext = event.getSessionContext();
                try {
                    uniqueId = sessionContext.getEntityKey();
                    if (_logger != null && _logger.isDebugEnabled()) {
                        _logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"SessionService.sessionContextCleanup.fmt.txt", (Object)sessionContext.getEntityKey()));
                    }
                    SessionService sessionService = this;
                    synchronized (sessionService) {
                        _contexts.remove(uniqueId);
                    }
                }
                catch (RemoteException e) {
                    if (_logger == null) break block7;
                    _logger.warn(RB.getStringResource(RB_KEY, "sessionContextCleanupFailed.txt"), (Throwable)e);
                }
            }
        }
    }

    void addDeferredSessionContext(SessionContextInterface sessionContext, long delay) throws ServiceException {
        _deferredMap.add(sessionContext, delay);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final synchronized void initSessionService(ServiceConfigurationInterface serviceConfiguration, DiscoveryServiceInterface discoveryService) throws ServiceException {
        SessionService sessionService;
        String defaultUser;
        UserServiceInterface userService;
        block21: {
            userService = null;
            defaultUser = null;
            if (_sessionService != null) {
                if (_logger != null) {
                    _logger.warn(RB.getStringResource("SessionService.alreadyConfigured.ex.txt"));
                }
                return;
            }
            sessionService = new SessionService(serviceConfiguration, discoveryService);
            try {
                _sessionService = sessionService;
                sessionService.bindToDiscoveryService();
            }
            catch (ServiceException e) {
                if (_sessionService == null) break block21;
                try {
                    _sessionService.destroy();
                }
                catch (RemoteException re) {
                    if (_logger != null) {
                        _logger.error(re.getLocalizedMessage());
                    }
                }
                finally {
                    _sessionService = null;
                }
                throw e;
            }
        }
        Object initObject = serviceConfiguration.getInitializationObject();
        SessionServiceInitObject sessionServiceInitObject = null;
        try {
            sessionServiceInitObject = (SessionServiceInitObject)initObject;
        }
        catch (ClassCastException e) {
            try {
                sessionServiceInitObject = (SessionServiceInitObject)((ServiceInitializationObject)initObject).getConfiguration(new SessionServiceInitializer());
            }
            catch (ClassCastException cce) {
                throw new InitializationException(Message.format((ResourceBundle)RB.getResources(), (String)"IllegalArgument.config.ex.fmt.txt", (Object)initObject));
            }
        }
        if (sessionServiceInitObject != null) {
            if (sessionServiceInitObject.getSessionContextTimeout() != null) {
                _defaultSessionTimeout = sessionServiceInitObject.getSessionContextTimeout();
                if (_logger != null && _logger.isInfoEnabled()) {
                    _logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"SessionService.timeout.fmt.txt", (Object)_defaultSessionTimeout));
                }
            } else if (_logger != null && _logger.isDebugEnabled()) {
                _logger.debug(RB.getStringResource("SessionService.noTimeout.txt"));
            }
            if ((defaultUser = sessionServiceInitObject.getUserContextName()) != null && defaultUser.length() != 0) {
                userService = SessionService.initUserService();
            }
        }
        if (_rootSessionContext == null) {
            sessionService.createRootSessionContext(userService, defaultUser);
        }
        _deferredMap = new SessionContextDeferredMap();
    }

    private static final synchronized UserServiceInterface initUserService() {
        UserServiceInterface userService;
        block5: {
            userService = null;
            try {
                ServiceTemplate serviceTemplate = new ServiceTemplate(new Class[]{UserServiceInterface.class});
                userService = (UserServiceInterface)DiscoveryService.defaultInstance().findService(serviceTemplate);
                if (_logger != null && _logger.isDebugEnabled()) {
                    _logger.debug(RB.getStringResource(RB_KEY, "userServiceSuccessful.txt"));
                }
            }
            catch (ServiceNotAvailableException e) {
                if (_logger != null) {
                    _logger.error(RB.getStringResource(RB_KEY, "userServiceNotAvail.txt"), (Throwable)((Object)e));
                }
            }
            catch (Exception e) {
                if (_logger == null) break block5;
                _logger.error(RB.getStringResource(RB_KEY, "userServiceError.txt"), (Throwable)e);
            }
        }
        return userService;
    }

    private synchronized void createRootSessionContext(UserServiceInterface userService, String defaultUser) throws ServiceException {
        UserContextInterface userContext;
        block13: {
            userContext = null;
            if (_rootSessionContext != null) {
                return;
            }
            try {
                block14: {
                    if (userService == null || defaultUser == null || defaultUser.equals("")) break block13;
                    if (_logger != null && _logger.isDebugEnabled()) {
                        _logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"SessionService.defaultUserContext.fmt.txt", (Object)defaultUser));
                    }
                    final UserServiceInterface usi = userService;
                    final String defUser = defaultUser;
                    PrivilegedExceptionAction action = new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            return usi.getUser(defUser);
                        }
                    };
                    try {
                        userContext = (UserContextInterface)AccessController.doPrivileged(action);
                    }
                    catch (PrivilegedActionException pae) {
                        Throwable t = pae.getCause();
                        if (t instanceof RemoteException) {
                            throw (RemoteException)t;
                        }
                        if (_logger == null) break block14;
                        _logger.error(Message.format((ResourceBundle)RB.getResources(), (String)"SessionService.userException.fmt.txt", (Object)defaultUser), t);
                    }
                }
                if (_logger != null && _logger.isDebugEnabled()) {
                    _logger.debug(RB.getStringResource(RB_KEY, "userContextSuccessful.txt"));
                }
            }
            catch (RemoteException e) {
                if (_logger == null) break block13;
                _logger.error(Message.format((ResourceBundle)RB.getResources(), (String)"SessionService.userException.fmt.txt", (Object)defaultUser), (Throwable)e);
            }
        }
        try {
            _rootSessionContext = new SessionContext(null, null, userContext);
            Logger logger = LogManager.getLogger((String)SessionContext.class.getName());
            if (logger == null) {
                throw new ServiceException(RB.getStringResource(RB_KEY, "loggerErr.ex.txt"));
            }
            ((SessionContext)_rootSessionContext).setLogger(logger);
            if (userContext != null) {
                userContext.setSessionContext(_rootSessionContext);
            }
            _rootSessionContextUniqueId = _rootSessionContext.getEntityKey();
            _rootLockObject = _rootSessionContext.lock("com.sas.services.session.SessionService");
        }
        catch (RemoteException e) {
            if (_logger != null) {
                _logger.fatal(RB.getStringResource(RB_KEY, "rootRemoteException.txt"), (Throwable)e);
            }
            throw new ServiceException(RB.getStringResource(RB_KEY, "rootFailure.serviceProviderException.ex.txt"));
        }
    }

    @Override
    public final RemoteServiceInterface getServiceProxy() {
        SessionServiceProxy proxy = null;
        try {
            proxy = new SessionServiceProxy(_sessionService);
        }
        catch (InitializationException e) {
            proxy = null;
        }
        return proxy;
    }

    @Override
    public void quiesce(UserContextInterface userContext) throws ServiceException, QuiesceException, IllegalStateException {
        this.invokeQuiesce(userContext, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void invokeQuiesce(UserContextInterface userContext, boolean checkPermission) throws ServiceException, QuiesceException, IllegalStateException {
        if (this._destroyed) {
            throw new IllegalStateException(RB.getStringResource("SessionService.servicedestroyed.ex.txt"));
        }
        if (_logger != null && _logger.isInfoEnabled()) {
            _logger.info(RB.getStringResource(RB_KEY, "quiesce.txt"));
        }
        if (checkPermission) {
            SessionPermission scp = new SessionPermission("quiesce");
            SecurityUtil.checkPermission(userContext, scp);
        }
        SessionService sessionService = this;
        synchronized (sessionService) {
            this._quiesce = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isQuiesced() throws RemoteException {
        SessionService sessionService = this;
        synchronized (sessionService) {
            return this._quiesce;
        }
    }

    @Override
    public void resume(UserContextInterface userContext) throws ServiceException, QuiesceException, IllegalStateException {
        this.invokeResume(userContext, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void invokeResume(UserContextInterface userContext, boolean checkPermission) throws ServiceException, QuiesceException, IllegalStateException {
        if (this._destroyed) {
            throw new IllegalStateException(RB.getStringResource("SessionService.servicedestroyed.ex.txt"));
        }
        if (_logger != null && _logger.isInfoEnabled()) {
            _logger.info(RB.getStringResource(RB_KEY, "resume.txt"));
        }
        if (checkPermission) {
            SessionPermission scp = new SessionPermission("resume");
            SecurityUtil.checkPermission(userContext, scp);
        }
        SessionService sessionService = this;
        synchronized (sessionService) {
            this._quiesce = false;
        }
    }

    @Override
    public void destroySessions(UserContextInterface userContext) throws RemoteException, IllegalStateException {
        this.invokeDestroySessions(userContext, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void invokeDestroySessions(UserContextInterface userContext, boolean checkPermission) throws RemoteException, IllegalStateException {
        if (this._destroyed) {
            throw new IllegalStateException(RB.getStringResource("SessionService.servicedestroyed.ex.txt"));
        }
        if (_logger != null) {
            _logger.warn(RB.getStringResource(RB_KEY, "destroySessions.txt"));
        }
        if (checkPermission) {
            SessionPermission scp = new SessionPermission("destroySessions");
            SecurityUtil.checkPermission(userContext, scp);
        }
        Iterator itor = null;
        SessionService sessionService = this;
        synchronized (sessionService) {
            itor = new ArrayList(_contexts.values()).iterator();
            _contexts.clear();
        }
        while (itor.hasNext()) {
            SessionContextInterface sessCtx = (SessionContextInterface)itor.next();
            try {
                if (sessCtx instanceof SessionContext) {
                    ((SessionContext)sessCtx).forceDestroy();
                    continue;
                }
                sessCtx.destroy();
            }
            catch (Exception e) {
                if (_logger == null) continue;
                _logger.error(RB.getStringResource(RB_KEY, "haltContextError.txt"), (Throwable)e);
            }
        }
    }

    @Override
    public boolean destroySession(UserContextInterface userContext, String sessionContextId) throws RemoteException {
        return this.invokeDestroySession(userContext, sessionContextId, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean invokeDestroySession(UserContextInterface userContext, String sessionContextId, boolean checkPermission) throws RemoteException {
        if (_logger != null && _logger.isDebugEnabled()) {
            _logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"SessionService.destroySession.fmt.txt", (Object)sessionContextId));
        }
        if (checkPermission) {
            SessionPermission scp = new SessionPermission("destroySessions");
            SecurityUtil.checkPermission(userContext, scp);
        }
        SessionContextInterface sc = null;
        SessionService sessionService = this;
        synchronized (sessionService) {
            sc = (SessionContextInterface)_contexts.get(sessionContextId);
        }
        if (sc != null) {
            ((SessionContext)sc).forceDestroy();
            return true;
        }
        if (_logger != null && _logger.isInfoEnabled()) {
            _logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"SessionService.invalidId.fmt.txt", (Object)sessionContextId));
        }
        return false;
    }

    @Override
    public List getSummaryData(UserContextInterface userContext) throws RemoteException, IllegalStateException {
        return this.invokeGetSummaryData(userContext, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List invokeGetSummaryData(UserContextInterface userContext, boolean checkPermission) throws RemoteException, IllegalStateException {
        if (this._destroyed) {
            throw new IllegalStateException(RB.getStringResource("SessionService.servicedestroyed.ex.txt"));
        }
        if (checkPermission) {
            SessionPermission scp = new SessionPermission("getSummaryData");
            SecurityUtil.checkPermission(userContext, scp);
        }
        ArrayList<SummaryData> list = new ArrayList<SummaryData>();
        List emails = null;
        Iterator itor = null;
        SessionService sessionService = this;
        synchronized (sessionService) {
            itor = new ArrayList(_contexts.values()).iterator();
        }
        while (itor.hasNext()) {
            SessionContextInterface sc = (SessionContextInterface)itor.next();
            try {
                UserContextInterface uc = sc.getUserContext();
                if (uc == null) continue;
                IdentityInterface identity = uc.getPerson();
                if (identity instanceof PersonInterface) {
                    PersonInterface pi = (PersonInterface)identity;
                    emails = pi != null ? pi.getEmailAddresses() : new ArrayList();
                }
                SummaryData sd = new SummaryData(uc.getProfile(), uc.getName(), emails, uc.getLoginTime(), uc.getUniqueId(), sc.getEntityKey());
                list.add(sd);
            }
            catch (Exception e) {
                if (_logger == null) continue;
                _logger.error(RB.getStringResource(RB_KEY, "sumError.txt"), (Throwable)e);
            }
        }
        return list;
    }

    protected void finalize() throws Throwable {
        try {
            if (_logger != null && _logger.isDebugEnabled()) {
                _logger.debug(RB.getStringResource(RB_KEY, "garbageCollection.txt"));
            }
            this.destroy();
        }
        finally {
            super.finalize();
        }
    }

    @Override
    public SessionContextInterface fromByteArray(byte[] data) throws RemoteException, ServiceException {
        SessionContext result = null;
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        try {
            EntityKeyInterface id;
            ObjectInputStream ois;
            block7: {
                ois = new ObjectInputStream(bais);
                final EntityKeyInterface myid = id = (EntityKeyInterface)ois.readObject();
                PrivilegedExceptionAction action = new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        return SessionService.this.getSessionContext(myid.getEntityKey());
                    }
                };
                try {
                    result = (SessionContext)AccessController.doPrivileged(action);
                }
                catch (PrivilegedActionException pae) {
                    Throwable t = pae.getCause();
                    if (t instanceof RemoteException) {
                        throw (RemoteException)t;
                    }
                    if (_logger == null) break block7;
                    _logger.error(Message.format((ResourceBundle)RB.getResources(), (String)"SessionService.userException.fmt.txt", (Object)id.getEntityKey()), t);
                }
            }
            if (result != null) {
                return result;
            }
            ServiceTemplate serviceTemplate = new ServiceTemplate(new Class[]{UserServiceInterface.class});
            UserServiceInterface userService = (UserServiceInterface)DiscoveryService.defaultInstance().findService(serviceTemplate);
            Map cacheMap = (Map)ois.readObject();
            Boolean destroyPending = (Boolean)ois.readObject();
            Map lockMap = (Map)ois.readObject();
            byte[] userData = (byte[])ois.readObject();
            UserContextInterface userContext = userService.fromByteArray(userData);
            result = new SessionContext(this, _rootSessionContext, userContext, id, cacheMap, destroyPending, lockMap);
            Logger logger = LogManager.getLogger((String)SessionContext.class.getName());
            if (logger == null) {
                throw new InitializationException(RB.getStringResource(RB_KEY, "loggerErr.ex.txt"));
            }
            result.setLogger(logger);
        }
        catch (Exception ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkForTimeouts() {
        Iterator itor = null;
        SessionService sessionService = this;
        synchronized (sessionService) {
            itor = new ArrayList(_contexts.values()).iterator();
        }
        while (itor.hasNext()) {
            SessionContext sc = (SessionContext)itor.next();
            if (System.currentTimeMillis() - sc.getLastAccessTime() <= _defaultSessionTimeout) continue;
            if (sc.isTimeoutDisabled()) {
                if (_logger == null || !_logger.isDebugEnabled()) continue;
                _logger.debug("Ignoring session context timeout because it has been disabled.");
                continue;
            }
            String sessionId = "";
            try {
                sessionId = sc.getEntityKey();
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            if (_logger != null && _logger.isInfoEnabled()) {
                _logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"SessionService.sessionTimeout.fmt.txt", (Object)sessionId));
            }
            try {
                sc.forceDestroy();
            }
            catch (Exception e) {
                if (_logger == null || !_logger.isInfoEnabled()) continue;
                _logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"SessionService.sessionTimeoutErr.fmt.txt", (Object)sessionId), (Throwable)e);
            }
        }
    }

    @SASScope
    private class CheckSessionTimeouts
    extends TimerTask {
        private SessionService ssi;

        CheckSessionTimeouts(SessionService ssi) {
            this.ssi = ssi;
        }

        @Override
        public void run() {
            this.ssi.checkForTimeouts();
        }
    }
}

