/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.util;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.services.ServiceException;
import com.sas.services.information.DAVRepositoryInterface;
import com.sas.services.information.Filter;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.browse.BrowseMetadataInterface;
import com.sas.services.information.metadata.PathUrl;
import com.sas.services.information.util.ISEntityKey;
import com.sas.services.information.util.OMRRepositoryKey;
import com.sas.services.information.util.RB;
import com.sas.services.user.UserContextInterface;
import java.rmi.RemoteException;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public class ISUtility {
    private static final String DEFAULT_TREE_TEMPLATE = "<Templates>\n  <Tree>\n    <ParentTree/>\n    <SoftwareComponents/>\n  </Tree>\n</Templates>";

    private ISUtility() {
    }

    public static PathUrl getPathFromEntityKey(UserContextInterface user, String iSEntityKey) throws ServiceException, RemoteException {
        ISEntityKey isKey = new ISEntityKey(iSEntityKey);
        String reposName = isKey.getRepository();
        String reposKey = isKey.getRepositoryKey();
        RepositoryInterface ri = user.getRepository(reposName);
        if (ri instanceof OMIRepositoryInterface) {
            BrowseMetadataInterface treeBmi;
            ServerInterface si = ri.getServer();
            String serverName = si.getName();
            OMRRepositoryKey oKey = new OMRRepositoryKey(reposKey);
            String type = oKey.getType();
            String template = null;
            template = type.equals("Tree") ? DEFAULT_TREE_TEMPLATE : "<Templates>\n  <" + type + ">\n    <Trees/>\n  </" + type + ">\n  <Tree>\n    <ParentTree/>\n    <SoftwareComponents/>\n  </Tree>\n</Templates>";
            Filter filter = new Filter();
            filter.setOMRTemplate(template);
            BrowseMetadataInterface bmi = ri.browseFetch(iSEntityKey, filter);
            String name = bmi.getName();
            String smartType = bmi.getSmartType();
            List treeList = null;
            if (bmi.isAFolder()) {
                treeList = (List)bmi.get("ParentTree");
                if (treeList == null) {
                    List scList = (List)bmi.get("SoftwareComponents");
                    if (scList == null) {
                        return null;
                    }
                    for (BrowseMetadataInterface scBmi : scList) {
                        if (!scBmi.getName().equals("BIP Service") || !scBmi.get("ClassIdentifier").equals("E5F27790-2149-11D6-8828-AA0004006D06")) continue;
                        PathUrl pathUrl = new PathUrl(reposName, name, null, null, "Folder");
                        return pathUrl;
                    }
                }
            } else {
                treeList = (List)bmi.get("Trees");
            }
            if (treeList == null) {
                return null;
            }
            Iterator treeIt = treeList.iterator();
            String path = null;
            while (treeIt.hasNext() && (path = ISUtility.pathToRoot(treeBmi = (BrowseMetadataInterface)treeIt.next())) == null) {
            }
            if (path == null) {
                return null;
            }
            String url = "SBIP://" + serverName + '/' + path + '/' + name + '(' + smartType + ')';
            PathUrl pathUrl = new PathUrl(url);
            return pathUrl;
        }
        if (ri instanceof DAVRepositoryInterface) {
            int p = reposKey.lastIndexOf("/");
            String path = reposKey.substring(0, p);
            String smartType = reposKey.substring(p + 1);
            String url = "SBIP://" + reposName + '/' + path + '(' + smartType + ')';
            PathUrl pathUrl = new PathUrl(url);
            return pathUrl;
        }
        return null;
    }

    private static String pathToRoot(BrowseMetadataInterface bmi) {
        List treeList = (List)bmi.get("ParentTree");
        if (treeList == null) {
            List scList = (List)bmi.get("SoftwareComponents");
            if (scList == null) {
                return null;
            }
            for (BrowseMetadataInterface scBmi : scList) {
                if (!scBmi.getName().equals("BIP Service") || !scBmi.get("ClassIdentifier").equals("E5F27790-2149-11D6-8828-AA0004006D06")) continue;
                return bmi.getName();
            }
            return null;
        }
        for (BrowseMetadataInterface nextBmi : treeList) {
            String path = ISUtility.pathToRoot(nextBmi);
            if (path == null) continue;
            return path + '/' + bmi.getName();
        }
        return null;
    }

    public static String getLocalizedTypeName(String type) {
        return ISUtility.getLocalizedTypeName(type, Locale.getDefault());
    }

    public static String getLocalizedTypeName(String type, Locale locale) {
        String key = type + ".txt";
        String result = null;
        try {
            result = RB.getStringResource(key, locale);
        }
        catch (MissingResourceException ex) {
            try {
                key = type + ".Name.txt";
                result = com.sas.services.information.publicobject.RB.getStringResource(key, locale);
            }
            catch (MissingResourceException ex2) {
                result = "";
            }
        }
        return result;
    }
}

