/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.search;

import com.sas.services.information.AssociationPathComponent;
import com.sas.services.information.FilterComponent;
import com.sas.services.information.search.RB;
import com.sas.services.information.search.SearchFilter;
import com.sas.text.Message;
import java.io.Serializable;
import java.util.ResourceBundle;

public class ResponsibilitiesFilter
implements SearchFilter,
Serializable {
    private static final long serialVersionUID = -4545361675820512345L;
    protected static final String RESPONSIBLEPARTY_NAME = "Name";
    protected static final String RESPONSIBLEPARTY_ROLE = "Role";
    protected static final String RESPONSIBLEPARTY_ASSOCNAME = "ResponsibleParties";
    protected static final String RESPONSIBLEPARTY_ASSOCTYPE = "ResponsibleParty";
    protected static final String PERSON_ASSOCNAME = "Persons";
    protected static final String PERSON_ASSOCTYPE = "Person";
    private String _responsiblePartyName = null;
    private String _responsiblePartyRole = null;

    public ResponsibilitiesFilter(String userName, String role) {
        this._responsiblePartyName = userName;
        this._responsiblePartyRole = role;
    }

    public String getReponsiblePartyName() {
        return this._responsiblePartyName;
    }

    public String getReponsiblePartyRole() {
        return this._responsiblePartyRole;
    }

    @Override
    public String getFilterType() {
        return RB.getStringResource("ResponsibilitiesFilter.FilterName.txt");
    }

    @Override
    public String getFilterDescription() {
        if (this._responsiblePartyName != null && this._responsiblePartyRole == null) {
            return Message.format((ResourceBundle)RB.getResources(), (String)"ResponsibilitiesFilter.FilterDesc1.fmt.txt", (Object)this._responsiblePartyName);
        }
        if (this._responsiblePartyName != null && this._responsiblePartyRole != null) {
            return Message.format((ResourceBundle)RB.getResources(), (String)"ResponsibilitiesFilter.FilterDesc2.fmt.txt", (Object)this._responsiblePartyName, (Object)this._responsiblePartyRole);
        }
        return null;
    }

    @Override
    public FilterComponent getFilterComponent() {
        FilterComponent comp = new FilterComponent();
        AssociationPathComponent ac1 = new AssociationPathComponent();
        ac1.setAssociationPath(RESPONSIBLEPARTY_ASSOCNAME, RESPONSIBLEPARTY_ASSOCTYPE);
        if (this._responsiblePartyRole != null && this._responsiblePartyRole.length() > 0) {
            FilterComponent roleComp = new FilterComponent(RESPONSIBLEPARTY_ROLE, 0, this.getReponsiblePartyRole());
            ac1.setAttributeCriteria(roleComp);
        }
        AssociationPathComponent ac2 = new AssociationPathComponent();
        ac2.setAssociationPath(PERSON_ASSOCNAME, PERSON_ASSOCTYPE);
        if (this._responsiblePartyName != null) {
            FilterComponent nameComp = new FilterComponent(RESPONSIBLEPARTY_NAME, 0, this.getReponsiblePartyName());
            ac2.setAttributeCriteria(nameComp);
        }
        ac1.setNextAssociationPath(ac2);
        comp.addAssociationPathComponent(ac1);
        return comp;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj != null && obj instanceof ResponsibilitiesFilter) {
            ResponsibilitiesFilter filter = (ResponsibilitiesFilter)obj;
            if (this._responsiblePartyName != null && this._responsiblePartyName.equals(filter.getReponsiblePartyName()) && (this._responsiblePartyRole == null && filter.getReponsiblePartyRole() == null || this._responsiblePartyRole.equals(filter.getReponsiblePartyRole()))) {
                return true;
            }
        }
        return false;
    }
}

