/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.metadata.servers;

import com.sas.metadata.remote.Machine;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.ServerComponent;
import com.sas.metadata.remote.ServiceType;
import com.sas.metadata.remote.SoftwareComponent;
import com.sas.services.ServiceException;
import com.sas.services.information.ItemAlreadyExistsException;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.metadata.MetadataBuilder;
import com.sas.services.information.metadata.SoftwareComponentInterface;
import com.sas.services.information.metadata.servers.ServersUtil;
import com.sas.services.user.UserContextInterface;
import java.rmi.RemoteException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class ServerBuilder<T extends SoftwareComponentInterface, J extends SoftwareComponent, B extends ServerBuilder<T, J, B>>
extends MetadataBuilder<T, J, B> {
    protected String classIdentifier = null;
    protected String productName = null;
    protected int majorVersion = 0;
    protected int minorVersion = 0;
    protected String version = "unknown";
    protected String vendor = "Unknown";
    protected String serviceType = null;
    private String associatedMachine = null;

    protected ServerBuilder(Class<J> metadataType, String publicType, double usageVersion, String classIdentifier, String productName) {
        super(metadataType, publicType, usageVersion);
        this.classIdentifier = classIdentifier;
        this.productName = productName;
    }

    public B associatedMachine(String machine) {
        this.associatedMachine = machine;
        return (B)this;
    }

    public B serverVersion(String version) {
        if (version == null) {
            throw new NullPointerException();
        }
        this.version = version;
        Pattern versionPattern = Pattern.compile("[^\\d]*(\\d+)(\\.(\\d+))?.*");
        Matcher versionMatcher = versionPattern.matcher(version);
        if (versionMatcher.matches()) {
            this.majorVersion = Integer.parseInt(versionMatcher.group(1));
            String minor = versionMatcher.group(3);
            this.minorVersion = minor != null ? Integer.parseInt(minor) : 0;
        }
        return (B)this;
    }

    public B serverVersion(String version, int major, int minor) {
        if (version == null) {
            throw new NullPointerException();
        }
        this.majorVersion = major;
        this.minorVersion = minor;
        this.version = version;
        return (B)this;
    }

    public B vendor(String vendor) {
        if (vendor == null) {
            throw new NullPointerException();
        }
        this.vendor = vendor;
        return (B)this;
    }

    public B repository(String repositoryName) {
        this.repositoryName = repositoryName;
        return (B)this;
    }

    public B repository(RepositoryInterface repository) {
        this.repository = repository;
        return (B)this;
    }

    @Override
    public void validate(UserContextInterface user) throws IllegalArgumentException, IllegalStateException, ItemAlreadyExistsException, ServiceException {
        super.validate(user);
        if (ServersUtil.serverExists(user, this.name)) {
            throw new ItemAlreadyExistsException("Server \"" + this.name + "\" already exists");
        }
    }

    @Override
    protected void createObject() throws RemoteException, MdException, ServiceException {
        super.createObject();
        if (this.classIdentifier != null) {
            ((SoftwareComponent)this.built).setClassIdentifier(this.classIdentifier);
        }
        if (this.productName != null) {
            ((SoftwareComponent)this.built).setProductName(this.productName);
        }
        if (this.version != null) {
            ((SoftwareComponent)this.built).setSoftwareVersion(this.version);
        }
        if (this.majorVersion != 0) {
            ((SoftwareComponent)this.built).setMajor(this.majorVersion);
        }
        if (this.minorVersion != 0) {
            ((SoftwareComponent)this.built).setMinor(this.minorVersion);
        }
        if (this.vendor != null) {
            ((SoftwareComponent)this.built).setVendor(this.vendor);
        }
        if (this.serviceType != null || this.associatedMachine != null) {
            ServerComponent builtDeployedComponent;
            try {
                builtDeployedComponent = (ServerComponent)this.built;
            }
            catch (ClassCastException e) {
                throw new ServiceException(e, "Implementation error in class " + this.getClass().getName() + " - serviceType cannot be set on objects of type " + ((SoftwareComponent)this.built).getClass().getSimpleName());
            }
            if (this.serviceType != null) {
                ServiceType serviceTypeObject = this.createMetadata(this.serviceType, ServiceType.class);
                builtDeployedComponent.getServiceTypes().add((Object)serviceTypeObject);
            }
            if (this.associatedMachine != null) {
                Machine machine = this.findMetadataByName(this.associatedMachine, Machine.class);
                if (machine == null) {
                    machine = this.createMetadata(this.associatedMachine, Machine.class);
                }
                builtDeployedComponent.setAssociatedMachine(machine);
            }
        }
    }

    public T build(UserContextInterface user) throws ItemAlreadyExistsException, IllegalArgumentException, IllegalStateException, ServiceException {
        return (T)((SoftwareComponentInterface)this.buildInternal(user));
    }
}

