/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.metadata.servers;

import com.sas.services.ServiceException;
import com.sas.services.information.MetadataServerInterface;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.metadata.servers.DataServerInterface;
import com.sas.services.information.metadata.servers.DataServerUtil;
import com.sas.services.session.SessionContextInterface;
import java.rmi.RemoteException;
import java.util.Map;

public class SASInfrastructureDataServerUtil
extends DataServerUtil {
    public static final String TYPE_NAME = "Server.SASInfrastructureData";
    public static final String CLASS_IDENTIFIER = "SASInfrastructureData";
    public static final String PRODUCT_NAME = "SASInfrastructureDataServer";
    public static final String VENDOR_NAME = "SAS Institute";
    public static final int DEFAULT_PORT = 5432;

    public SASInfrastructureDataServerUtil(MetadataServerInterface metadataServer) {
        super(metadataServer, TYPE_NAME);
    }

    public SASInfrastructureDataServerUtil(SessionContextInterface session) throws ServiceException {
        super(session, TYPE_NAME);
    }

    @Override
    public DataServerInterface createServer(String name, Map<String, String> properties) throws IllegalArgumentException, ServiceException {
        return this.createServer(null, name, properties);
    }

    @Override
    public DataServerInterface createServer(OMIRepositoryInterface repository, String name, Map<String, String> properties) throws IllegalArgumentException, ServiceException {
        if (!properties.containsKey("SERVER")) {
            throw new IllegalArgumentException("Server name not specified.");
        }
        try {
            DataServerInterface server;
            if (repository == null) {
                repository = (OMIRepositoryInterface)this.metadataServer.getFoundationRepository();
            }
            if ((server = this.getServerByName(name)) != null) {
                throw new IllegalArgumentException("Server already exists.");
            }
            server = (DataServerInterface)this.getInformationService().newMetadata(repository.getDefaultRepositoryId(), name, repository, TYPE_NAME);
            server.updateServerProperties(properties);
            server.update();
            return server;
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
    }
}

