/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.metadata.servers;

import com.sas.metadata.remote.DeployedComponent;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.SASClientConnection;
import com.sas.metadata.remote.ServerComponent;
import com.sas.services.ServiceException;
import com.sas.services.information.ItemAlreadyExistsException;
import com.sas.services.information.metadata.SASClientConnectionInterface;
import com.sas.services.information.metadata.ServerComponentInterface;
import com.sas.services.information.metadata.servers.AbstractConnectionBuilder;
import com.sas.services.information.metadata.servers.ServerBuilder;
import com.sas.services.user.UserContextInterface;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

public final class OracleServerBuilder
extends ServerBuilder<ServerComponentInterface, ServerComponent, OracleServerBuilder> {
    private static final double USAGE_VERSION = 1000000.0;
    private List<Connection> connections = new ArrayList<Connection>();

    public static OracleServerBuilder builder() {
        return new OracleServerBuilder();
    }

    private OracleServerBuilder() {
        super(ServerComponent.class, "Server.Oracle", 1000000.0, "ORACLE", "ORACLE");
        this.serviceType = "DBMS Server";
        this.prototypeName = "Server.Oracle.Prototype.Name.xmlKey.txt";
        this.vendor("Oracle Corporation");
    }

    public Connection connection() {
        Connection connection = (Connection)new Connection().buildName(this.name, this.connections.size() + 1);
        this.connections.add(connection);
        return connection;
    }

    @Override
    public void validate(UserContextInterface user) throws IllegalArgumentException, IllegalStateException, ItemAlreadyExistsException, ServiceException {
        if (this.connections.isEmpty()) {
            throw new IllegalStateException("No connection is defined.");
        }
        super.validate(user);
        for (Connection connection : this.connections) {
            connection.validate(user);
        }
        Connection.checkForDuplicateNames(this.connections);
    }

    @Override
    protected void createObject() throws RemoteException, MdException, ServiceException {
        super.createObject();
        for (Connection connection : this.connections) {
            connection.buildAndConnect(this.user, (DeployedComponent)this.built);
        }
    }

    public final class Connection
    extends AbstractConnectionBuilder<SASClientConnectionInterface, SASClientConnection, Connection> {
        private Connection() {
            super(SASClientConnection.class, null, 0.0, "OracleProtocol", "TCP");
            this.prototypeName = "Connection.Oracle.Prototype.Name.xmlKey.txt";
        }

        public Connection path(String path) {
            this.option("PATH", path);
            return this;
        }

        public OracleServerBuilder end() {
            return OracleServerBuilder.this;
        }

        @Override
        public void validate(UserContextInterface user) throws IllegalArgumentException, IllegalStateException, ItemAlreadyExistsException, ServiceException {
            super.validate(user);
        }

        @Override
        protected void createObject() throws RemoteException, MdException, ServiceException {
            super.createObject();
        }
    }
}

