/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.metadata.servers;

import com.sas.services.ServiceException;
import com.sas.services.information.Filter;
import com.sas.services.information.metadata.TCPIPConnectionInterface;
import com.sas.services.information.metadata.servers.LASRServerInterface;
import com.sas.services.information.metadata.servers.ServersUtil;
import com.sas.services.user.UserContextInterface;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.List;

public final class LASRServerUtil {
    private static final String PUBLIC_TYPE = "Server.LASR";

    private LASRServerUtil() {
    }

    public static LASRServerInterface getServer(UserContextInterface userContext, String name) throws ServiceException {
        return (LASRServerInterface)ServersUtil.getServer(userContext, name, PUBLIC_TYPE);
    }

    public static Collection<LASRServerInterface> getAllServers(UserContextInterface userContext) throws ServiceException {
        return ServersUtil.getAllServers(userContext, PUBLIC_TYPE);
    }

    public static String getAuthorizationServiceUrl(UserContextInterface userContext) throws ServiceException {
        try {
            String servicePath;
            Filter filter = new Filter();
            filter.setType("TCPIPConnection");
            filter.setOMRFlags(130);
            filter.setExplicitSearchString("omi", "<XMLSelect search=\"*[Source/DeployedComponent[@ClassIdentifier='LASRAuthorizationService REST']/Trees/Tree[@Name='Registered SAS Services']]\"/>");
            List objects = userContext.getAuthServer().search(filter);
            if (objects.size() == 0) {
                return null;
            }
            TCPIPConnectionInterface conn = (TCPIPConnectionInterface)objects.get(0);
            StringBuilder url = new StringBuilder();
            url.append(conn.getCommunicationProtocol());
            if (url.length() == 0) {
                url.append("http");
            }
            url.append("://");
            url.append(conn.getHost());
            if (conn.getPort() > 0) {
                url.append(":");
                url.append(Integer.toString(conn.getPort()));
            }
            if ((servicePath = conn.getService()).endsWith("/authorization")) {
                servicePath = servicePath.substring(0, servicePath.length() - 14);
            }
            url.append(servicePath);
            return url.toString();
        }
        catch (RemoteException e) {
            throw new ServiceException(e);
        }
    }
}

