/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.metadata.servers;

import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdOMIUtil;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.ServerComponent;
import com.sas.services.ServiceException;
import com.sas.services.discovery.DiscoveryService;
import com.sas.services.discovery.ServiceTemplate;
import com.sas.services.information.InformationServiceInterface;
import com.sas.services.information.MetadataServerInterface;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.OMIServer;
import com.sas.services.information.metadata.servers.DataServerInterface;
import com.sas.services.session.SessionContextInterface;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.text.StringEscapeUtils;

public abstract class DataServerUtil {
    public static final int MAJOR_VERSION = 9;
    public static final int MINOR_VERSION = 4;
    protected MetadataServerInterface metadataServer;
    protected String publicType;

    public DataServerUtil(MetadataServerInterface metadataServer, String publicType) {
        this.metadataServer = metadataServer;
        this.publicType = publicType;
    }

    public DataServerUtil(SessionContextInterface session, String publicType) throws ServiceException {
        try {
            this.metadataServer = (MetadataServerInterface)session.getUserContext().getAuthServer();
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
        this.publicType = publicType;
    }

    public DataServerInterface getServerById(String id) throws ServiceException {
        MdObjectStore store = ((OMIServer)this.metadataServer).getObjectStore();
        try {
            MdOMIUtil omiUtil = store.getFactory().getOMIUtil();
            ServerComponent object = (ServerComponent)omiUtil.getFullObject(store, "ServerComponent", id);
            if (object == null || !object.getPublicType().equals(this.publicType)) {
                return null;
            }
            return (DataServerInterface)this.metadataServer.factoryProcess(object);
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
        catch (MdException e) {
            throw new ServiceException(e);
        }
    }

    public DataServerInterface getServerByName(String name) throws ServiceException {
        MdObjectStore store = ((OMIServer)this.metadataServer).getObjectStore();
        try {
            MdOMIUtil omiUtil = store.getFactory().getOMIUtil();
            List objects = omiUtil.getMetadataObjectsSubset((MdStore)store, omiUtil.getFoundationReposID(), "ServerComponent", 8584, "<XMLSelect search=\"ServerComponent[@Name='" + StringEscapeUtils.escapeXml11((String)name) + "' and @PublicType='" + this.publicType + "']\"/>");
            if (objects.size() == 0) {
                return null;
            }
            return (DataServerInterface)this.metadataServer.factoryProcess(objects.get(0));
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
        catch (MdException e) {
            throw new ServiceException(e);
        }
    }

    public List<DataServerInterface> getAllServers() throws ServiceException {
        MdObjectStore store = ((OMIServer)this.metadataServer).getObjectStore();
        try {
            MdOMIUtil omiUtil = store.getFactory().getOMIUtil();
            List objects = omiUtil.getMetadataObjectsSubset((MdStore)store, omiUtil.getFoundationReposID(), "ServerComponent", 8584, "<XMLSelect search=\"ServerComponent[@PublicType='" + this.publicType + "']\"/>");
            ArrayList<DataServerInterface> servers = new ArrayList<DataServerInterface>(objects.size());
            for (ServerComponent object : objects) {
                servers.add((DataServerInterface)this.metadataServer.factoryProcess(object));
            }
            return servers;
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
        catch (MdException e) {
            throw new ServiceException(e);
        }
    }

    public abstract DataServerInterface createServer(String var1, Map<String, String> var2) throws IllegalArgumentException, ServiceException;

    public abstract DataServerInterface createServer(OMIRepositoryInterface var1, String var2, Map<String, String> var3) throws IllegalArgumentException, ServiceException;

    protected InformationServiceInterface getInformationService() throws ServiceException {
        try {
            return (InformationServiceInterface)DiscoveryService.defaultInstance().findService(new ServiceTemplate(new Class[]{InformationServiceInterface.class}, null));
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
    }
}

