/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.metadata.secureddata;

import com.sas.metadata.remote.Tree;
import com.sas.services.ServiceException;
import com.sas.services.information.InformationServiceInterface;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.FolderUtil;
import com.sas.services.information.metadata.RootFolderInterface;
import com.sas.services.information.metadata.secureddata.RB;
import com.sas.text.Message;
import java.rmi.RemoteException;
import java.util.List;
import java.util.ResourceBundle;

public class SecuredDataFolderUtil {
    private static final String SECURED_LIBRARIES_FOLDERNAME = "Secured Libraries";

    public static FolderInterface makeSecuredLibrariesFolder(InformationServiceInterface infoSvc, OMIRepositoryInterface repos) throws ServiceException, RemoteException {
        RootFolderInterface rootFolder = repos.getServer().getRootFolder();
        if ("FOUNDATION".equalsIgnoreCase(repos.getRepositoryType())) {
            FolderInterface systemFolder = FolderUtil.makeSystemFolder(rootFolder);
            if (systemFolder == null) {
                String msg = Message.format((ResourceBundle)RB.getResources(), (String)"SecuredDataFolderUtil.NoSystemFolder.fmt.txt", (Object)repos.getDefaultRepositoryName());
                throw new ServiceException(msg);
            }
            return SecuredDataFolderUtil.createSecuredLibrariesFolder(infoSvc, repos, systemFolder);
        }
        if ("CUSTOM".equalsIgnoreCase(repos.getRepositoryType())) {
            List topLevelFolders = rootFolder.getSASFolders(repos);
            if (topLevelFolders == null || topLevelFolders.isEmpty()) {
                String msg = Message.format((ResourceBundle)RB.getResources(), (String)"SecuredDataFolderUtil.NoRootFolder.fmt.txt", (Object)repos.getDefaultRepositoryName());
                throw new ServiceException(msg);
            }
            FolderInterface customFolder = (FolderInterface)topLevelFolders.get(0);
            FolderInterface systemFolder = FolderUtil.makeSystemFolder(customFolder);
            if (systemFolder == null) {
                String msg = Message.format((ResourceBundle)RB.getResources(), (String)"SecuredDataFolderUtil.NoSystemFolder.fmt.txt", (Object)repos.getDefaultRepositoryName());
                throw new ServiceException(msg);
            }
            return SecuredDataFolderUtil.createSecuredLibrariesFolder(infoSvc, repos, systemFolder);
        }
        return null;
    }

    private static FolderInterface createSecuredLibrariesFolder(InformationServiceInterface infoSvc, OMIRepositoryInterface repos, FolderInterface systemFolder) throws ServiceException, RemoteException {
        FolderInterface secureFolder = systemFolder.getSubfolder(SECURED_LIBRARIES_FOLDERNAME);
        if (secureFolder != null) {
            return secureFolder;
        }
        if (systemFolder.hasDuplicateSubfolder(SECURED_LIBRARIES_FOLDERNAME)) {
            throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"SecuredDataFolderUtil.Duplicate.fmt.txt", (Object)SECURED_LIBRARIES_FOLDERNAME));
        }
        if (infoSvc != null) {
            String reposId = repos.getDefaultRepositoryId();
            secureFolder = (FolderInterface)infoSvc.newMetadata(reposId, SECURED_LIBRARIES_FOLDERNAME, repos, "Folder.SecuredData");
            Tree tree = (Tree)secureFolder.getRepositoryEntity();
            tree.setPublicType("Folder.SecuredData");
            secureFolder.setDescription(RB.getStringResource("SecuredDataFolderUtil.SecuredLibrariesFolder.Desc.txt"));
            secureFolder.setFolderType("System");
            systemFolder.addSubfolder(secureFolder);
            secureFolder.update();
            return secureFolder;
        }
        return null;
    }
}

