/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.metadata.propertybag;

import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.propertybag.PropertyBagInterface;
import com.sas.services.information.metadata.propertybag.PropertyBagValue;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class PropertyBag
implements PropertyBagInterface,
Serializable {
    static final long serialVersionUID = 1051553803241734738L;
    private static final int BAG_MAP_INIT = 24;
    private MetadataInterface smartObject = null;
    private Map myMap;

    public PropertyBag(MetadataInterface smartObject) {
        this.smartObject = smartObject;
        this.myMap = new HashMap(24);
    }

    @Override
    public int size() {
        return this.myMap.size();
    }

    @Override
    public void clear() {
        this.myMap.clear();
    }

    @Override
    public boolean isEmpty() {
        return this.myMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.myMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.myMap.containsValue(value);
    }

    public Collection values() {
        Collection values = this.myMap.values();
        ArrayList<String> result = new ArrayList<String>(values.size());
        for (PropertyBagValue pbv : values) {
            result.add(pbv.getValue());
        }
        return result;
    }

    public void putAll(Map t) {
        throw new UnsupportedOperationException();
    }

    public Set entrySet() {
        return null;
    }

    public Set keySet() {
        return this.myMap.keySet();
    }

    public Object get(Object key) {
        return this.getString(key);
    }

    @Override
    public String getString(Object key) {
        PropertyBagValue pbv = (PropertyBagValue)this.myMap.get(key);
        if (pbv == null) {
            return null;
        }
        String value = pbv.getValue();
        return value;
    }

    public Object remove(Object key) {
        Object o = this.myMap.get(key);
        if (o == null) {
            return null;
        }
        PropertyBagValue pbv = (PropertyBagValue)o;
        if (pbv.isMutable()) {
            return this.myMap.remove(key);
        }
        throw new IllegalStateException();
    }

    public Object put(Object key, Object value) {
        if (value instanceof PropertyBagValue) {
            return this.myMap.put(key, value);
        }
        if (!(value instanceof String)) {
            throw new IllegalArgumentException();
        }
        PropertyBagValue pbv = (PropertyBagValue)this.myMap.get(key);
        if (pbv == null) {
            pbv = new PropertyBagValue((String)value, true);
            this.myMap.put(key, pbv);
            return null;
        }
        pbv.setValue((String)value);
        return this.myMap.put(key, pbv);
    }

    @Override
    public void reset() {
        Collection values = this.myMap.values();
        for (PropertyBagValue pbv : values) {
            pbv.reset();
        }
    }

    public PropertyBagValue getValue(Object key) {
        PropertyBagValue pbv = (PropertyBagValue)this.myMap.get(key);
        return pbv;
    }

    public String toString() {
        return this.myMap.toString();
    }

    @Override
    public MetadataInterface getSmartObject() {
        return this.smartObject;
    }
}

