/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.metadata.prompt;

import com.sas.codepolicy.SASScope;
import com.sas.prompts.SharedPromptFactory;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.definitions.shared.MutableSharedPromptDefinitionInterface;
import com.sas.prompts.definitions.shared.SharedPromptDefinitionInterface;
import com.sas.prompts.groups.PromptGroupInterface;
import com.sas.prompts.groups.shared.MutableSharedPromptGroupInterface;
import com.sas.prompts.groups.shared.SharedPromptGroupInterface;
import com.sas.services.ServiceException;
import com.sas.services.information.metadata.PathUrl;
import com.sas.services.information.metadata.prompt.PersistenceFactoryWithServices;
import com.sas.services.information.metadata.prompt.PromptsPersistUtil;
import com.sas.services.user.UserContextInterface;
import com.sas.util.ValidateArg;
import com.sas.util.log.CommonLoggerInterface;
import com.sas.util.log.LoggerFactoryInterface;
import com.sas.util.log.LoggerRepository2;
import com.sas.util.xmlpersist.PersistenceInterface;
import com.sas.util.xmlpersist.impl.PromptObjectFactory;
import java.rmi.RemoteException;
import java.util.prefs.BackingStoreException;

@SASScope
final class SharedPromptFactoryImpl
implements SharedPromptFactory {
    private static final String SHARED = "Shared";
    private UserContextInterface userContext;
    private PromptDefinitionInterface definition;
    private PromptGroupInterface group;
    private CommonLoggerInterface logger;

    SharedPromptFactoryImpl(UserContextInterface userContext) {
        this.userContext = userContext;
    }

    SharedPromptFactoryImpl(PromptDefinitionInterface definition) {
        this.definition = definition;
    }

    SharedPromptFactoryImpl(PromptGroupInterface group) {
        this.group = group;
    }

    public PromptDefinitionInterface getDefinitionFromFolder(String sbipUrl) throws BackingStoreException {
        if (null == this.definition && null != this.userContext) {
            ValidateArg.notNull((Object)sbipUrl, (String)"sbipUrl");
            this.getLogger().debug("getDefinitionFromFolder() for:", sbipUrl);
            try {
                PathUrl path = PersistenceFactoryWithServices.newPathUrlFromString(this.userContext, sbipUrl);
                return PromptsPersistUtil.getDefinitionFromFolder(path, this.userContext);
            }
            catch (ServiceException e) {
                throw new BackingStoreException((Throwable)((Object)e));
            }
            catch (RemoteException e) {
                throw new BackingStoreException(e);
            }
        }
        return this.definition;
    }

    public PromptGroupInterface getGroupFromFolder(String sbipUrl) throws BackingStoreException {
        if (null == this.group && null != this.userContext) {
            ValidateArg.notNull((Object)sbipUrl, (String)"sbipUrl");
            this.getLogger().debug("getDefinitionFromFolder() for:", sbipUrl);
            try {
                PathUrl path = PersistenceFactoryWithServices.newPathUrlFromString(this.userContext, sbipUrl);
                return PromptsPersistUtil.getGroupFromFolder(path, this.userContext);
            }
            catch (ServiceException e) {
                throw new BackingStoreException((Throwable)((Object)e));
            }
            catch (RemoteException e) {
                throw new BackingStoreException(e);
            }
        }
        return this.group;
    }

    public SharedPromptDefinitionInterface newDefinition(String sbipUrl, LoggerFactoryInterface logFactory) throws ClassNotFoundException, BackingStoreException {
        ValidateArg.notNull((Object)sbipUrl, (String)"sbipUrl");
        PromptDefinitionInterface definition = this.getDefinitionFromFolder(sbipUrl);
        MutableSharedPromptDefinitionInterface retVal = (MutableSharedPromptDefinitionInterface)this.newPersistenceObject((PersistenceInterface)definition, logFactory);
        retVal.setSharedPromptLocation(sbipUrl, (SharedPromptFactory)this);
        return retVal;
    }

    public SharedPromptGroupInterface newGroup(String sbipUrl, LoggerFactoryInterface logFactory) throws ClassNotFoundException, BackingStoreException {
        ValidateArg.notNull((Object)sbipUrl, (String)"sbipUrl");
        PromptGroupInterface group = this.getGroupFromFolder(sbipUrl);
        MutableSharedPromptGroupInterface retVal = (MutableSharedPromptGroupInterface)this.newPersistenceObject((PersistenceInterface)group, logFactory);
        retVal.setSharedPromptLocation(sbipUrl, (SharedPromptFactory)this);
        return retVal;
    }

    private PersistenceInterface newPersistenceObject(PersistenceInterface prompt, LoggerFactoryInterface logFactory) throws BackingStoreException, ClassNotFoundException {
        PersistenceInterface retVal = null;
        ValidateArg.notNull((Object)prompt, (String)"prompt");
        ValidateArg.notNull((Object)logFactory, (String)"logFactory");
        String className = prompt.getClass().getName();
        int period = className.lastIndexOf(".");
        if (period > 0) {
            className = className.substring(period + 1);
        }
        String shareName = null;
        shareName = !className.startsWith(SHARED) ? SHARED + className : className;
        this.getLogger(logFactory).debug("newPersistenceObject() for:", shareName);
        PromptObjectFactory factory = PromptObjectFactory.getInstance();
        if (factory.isElementRecognized(shareName)) {
            try {
                retVal = factory.newObject(shareName);
            }
            catch (InstantiationException e) {
                throw new BackingStoreException(e);
            }
            catch (IllegalAccessException e) {
                throw new BackingStoreException(e);
            }
        } else {
            throw new ClassNotFoundException(shareName);
        }
        return retVal;
    }

    private CommonLoggerInterface getLogger() {
        return this.getLogger(null);
    }

    private CommonLoggerInterface getLogger(LoggerFactoryInterface logFactory) {
        if (null == this.logger) {
            if (null != logFactory) {
                this.logger = LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)logFactory);
            } else if (null != this.userContext) {
                try {
                    LoggerFactoryInterface factory = PersistenceFactoryWithServices.newLoggerFactory(this.userContext.getSessionContext());
                    this.logger = factory.makeNewLoggerInstance(this.getClass().getName());
                }
                catch (RemoteException remoteException) {}
            } else if (null == this.logger) {
                this.logger = LoggerRepository2.getLogger((String)this.getClass().getName(), null);
            }
        }
        return this.logger;
    }
}

