/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.metadata.prompt;

import com.sas.codepolicy.SASScope;
import com.sas.prompts.SharedPromptFactory;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.groups.PromptGroupInterface;
import com.sas.services.ServiceException;
import com.sas.services.information.metadata.PathUrl;
import com.sas.services.information.metadata.prompt.ServicesEnabledReadingContext;
import com.sas.services.information.metadata.prompt.SharedPromptFactoryImpl;
import com.sas.services.session.SessionContextInterface;
import com.sas.services.user.UserContextInterface;
import com.sas.util.ValidateArg;
import com.sas.util.log.LoggerFactoryInterface;
import com.sas.util.log.log4j.Log4JFactory2;
import com.sas.util.xmlpersist.IntegratedReadingContext;
import com.sas.util.xmlpersist.PersistenceInterface;
import com.sas.util.xmlpersist.PromptsReadingContext;
import com.sas.util.xmlpersist.PromptsWritingContext;
import com.sas.util.xmlpersist.impl.PersistenceFactory;
import java.rmi.RemoteException;

@SASScope
public final class PersistenceFactoryWithServices
extends PersistenceFactory {
    private PersistenceFactoryWithServices() {
    }

    public static PromptsReadingContext newReadingContext(UserContextInterface userContext) {
        return new ServicesEnabledReadingContext(userContext);
    }

    public static PromptsReadingContext newReadingContext(UserContextInterface userContext, IntegratedReadingContext foreignContext) {
        ServicesEnabledReadingContext retVal = new ServicesEnabledReadingContext(userContext);
        retVal.setReadingContext(foreignContext);
        return retVal;
    }

    public static LoggerFactoryInterface newLoggerFactory(SessionContextInterface sessionContext) {
        return new Log4JFactory2();
    }

    public static SharedPromptFactory newSharedPromptFactory(UserContextInterface userContext) {
        ValidateArg.notNull((Object)userContext, (String)"userContext");
        return new SharedPromptFactoryImpl(userContext);
    }

    public static SharedPromptFactory newSharedPromptFactory(PromptDefinitionInterface definition) {
        ValidateArg.notNull((Object)definition, (String)"definition");
        return new SharedPromptFactoryImpl(definition);
    }

    public static SharedPromptFactory newSharedPromptFactory(PromptGroupInterface group) {
        ValidateArg.notNull((Object)group, (String)"group");
        return new SharedPromptFactoryImpl(group);
    }

    public static PromptsWritingContext newWritingContext(PersistenceInterface object, SessionContextInterface sessionContext) {
        PromptsWritingContext writingContext = PersistenceFactoryWithServices.newWritingContext((PersistenceInterface)object, (LoggerFactoryInterface)PersistenceFactoryWithServices.newLoggerFactory(sessionContext));
        return writingContext;
    }

    public static PathUrl newPathUrlFromString(UserContextInterface user, String url) throws ServiceException, RemoteException {
        ValidateArg.notNull((Object)url, (String)"url");
        PathUrl retVal = null;
        String upUrl = url;
        upUrl = upUrl.toUpperCase();
        if (upUrl.startsWith("SBIP://")) {
            retVal = new PathUrl(url);
        } else if (url.indexOf(47) == 0) {
            ValidateArg.notNull((Object)user, (String)"user");
            retVal = PathUrl.newPathUrlFromAbsolutePath(user.getAuthServer(), url);
        }
        return retVal;
    }
}

