/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.metadata.prompt;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.metadata.remote.Prompt;
import com.sas.metadata.remote.impl.PromptImpl;
import com.sas.metadata.remote.impl.PromptImpl_Stub;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.services.ServiceException;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.VersionIncompatibleException;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.prompt.AbstractPromptImpl;
import com.sas.services.information.metadata.prompt.OMRPromptDefinitionInterface;
import com.sas.services.information.metadata.prompt.PromptsPersistUtil;
import com.sas.services.information.metadata.prompt.RB;
import com.sas.storage.editableproperties.LocalizableProperties;
import com.sas.storage.editableproperties.MultiLocaleProperties;
import com.sas.storage.editableproperties.PropertyList;
import com.sas.storage.editableproperties.PropertyMap;
import com.sas.storage.editableproperties.SubstitutionProperties;
import com.sas.storage.editableproperties.UnexpectedLocalizationException;
import com.sas.storage.editableproperties.UnexpectedSubstitutionException;
import com.sas.util.ValidateArg;
import com.sas.util.anno.NotNull;
import com.sas.util.xmlpersist.PromptsReadingContext;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import org.apache.logging.log4j.Level;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public final class OMRPromptDefinition
extends AbstractPromptImpl
implements OMRPromptDefinitionInterface,
MultiLocaleProperties,
SubstitutionProperties {
    private static final long serialVersionUID = -5144211240231173647L;
    private boolean isLocalizationActive;
    private PromptDefinitionInterface promptDefinition;

    public OMRPromptDefinition(Prompt arg0) throws RemoteException {
        super(arg0, OMRPromptDefinition.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRPromptDefinition() throws RemoteException {
        super(OMRPromptDefinition.class);
    }

    public OMRPromptDefinition(Object arg0, Class arg1) throws RemoteException {
        super(arg0, arg1);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRPromptDefinition(PromptImpl arg0) throws RemoteException {
        super(arg0, OMRPromptDefinition.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRPromptDefinition(PromptImpl_Stub arg0) throws RemoteException {
        super(arg0, OMRPromptDefinition.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRPromptDefinition(RepositoryInterface repos, String name, FolderInterface parent) throws RemoteException {
        super(OMRPromptDefinition.class);
        ValidateArg.notNull((Object)repos, (String)"repos");
        if (null == name || "".equals(name)) {
            name = "unnamed";
        }
        try {
            OMIRepositoryInterface omirepository = (OMIRepositoryInterface)repos;
            Prompt prompt = (Prompt)omirepository.createMetadata(name, "Prompt");
            prompt.setName(name);
            prompt.setUsageVersion(CURRENT_VERSION.encode());
            this._isCompatible = true;
            this._isReadCompatible = true;
            this._repositoryObject = prompt;
            this._repositoryFlag = 2;
            this.setRepository(repos);
            if (parent != null) {
                prompt.setPublicType("Prompt");
                try {
                    parent.addItem(this);
                }
                catch (ServiceException ex) {
                    this.logMessage(Level.WARN, RB.getStringResource("Metadata.accessexcept.msg.txt"), this.getClass().getName(), (Throwable)((Object)ex));
                }
            } else {
                prompt.setPublicType("Embedded:Prompt");
            }
        }
        catch (ServiceException ex) {
            this.logMessage(Level.WARN, RB.getStringResource("Metadata.accessexcept.msg.txt"), this.getClass().getName(), (Throwable)((Object)ex));
        }
    }

    @Override
    public String getType() {
        return "Prompt";
    }

    @Override
    public String getPromptInfo() throws RemoteException, ServiceException {
        this.checkPulse(true);
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        String promptInfo = null;
        if (null != this._repositoryObject) {
            promptInfo = ((Prompt)this._repositoryObject).getPromptInfo();
        }
        return promptInfo;
    }

    @Override
    public void setPromptInfo(String promptInfo) throws RemoteException, ServiceException {
        this.checkPulse(true);
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        ((Prompt)this._repositoryObject).setPromptInfo(promptInfo);
    }

    @Override
    public void setPromptType(int type) throws RemoteException, ServiceException {
        this.checkPulse(true);
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        ((Prompt)this._repositoryObject).setPromptType(type);
    }

    @Override
    public int getPromptType() throws RemoteException, ServiceException {
        this.checkPulse(true);
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        if (null != this._repositoryObject) {
            return ((Prompt)this._repositoryObject).getPromptType();
        }
        return -1;
    }

    @Override
    public PromptDefinitionInterface getPromptDefinition() throws RemoteException, ServiceException {
        return this.getPromptDefinition(null);
    }

    @Override
    public PromptDefinitionInterface getPromptDefinition(PromptsReadingContext readingContext) throws RemoteException, ServiceException {
        this.checkPulse(true);
        PromptDefinitionInterface retVal = null;
        String xml = this.getPromptInfo();
        if (null == xml) {
            throw new ServiceException(RB.getStringResource("OMRPromptDefinition.noInfo.log"));
        }
        retVal = (PromptDefinitionInterface)this.getPromptFromXML(readingContext, xml);
        return retVal;
    }

    public PropertyList getLocalizableProperties() throws UnexpectedLocalizationException {
        this.checkReadCompatible();
        PropertyList list = this.getDefaultLocalizableProperties();
        try {
            PromptDefinitionInterface promptDefinition1 = this.getPromptDefinition();
            if (promptDefinition1 != null) {
                list.addProperty("Prompt", ((LocalizableProperties)promptDefinition1).getLocalizableProperties());
            }
        }
        catch (Exception e) {
            throw new UnexpectedLocalizationException((Throwable)e);
        }
        return list;
    }

    public Collection getLocales() throws UnexpectedLocalizationException {
        try {
            PromptDefinitionInterface promptDefinition1 = this.getPromptDefinition();
            if (promptDefinition1 != null) {
                return ((MultiLocaleProperties)promptDefinition1).getLocales();
            }
        }
        catch (Exception e) {
            throw new UnexpectedLocalizationException((Throwable)e);
        }
        return new ArrayList();
    }

    public PropertyList getLocalizableProperties(Locale locale) throws UnexpectedLocalizationException {
        this.checkReadCompatible();
        PropertyList list = new PropertyList();
        try {
            PromptDefinitionInterface promptDefinition1 = this.getPromptDefinition();
            if (promptDefinition1 != null) {
                list.addProperty("Prompt", ((MultiLocaleProperties)promptDefinition1).getLocalizableProperties(locale));
            }
        }
        catch (Exception e) {
            throw new UnexpectedLocalizationException((Throwable)e);
        }
        return list;
    }

    public void beginLocalization() throws UnexpectedLocalizationException {
        this.checkCompatible();
        try {
            this.promptDefinition = this.getPromptDefinition();
            this.isLocalizationActive = true;
        }
        catch (Exception e) {
            throw new UnexpectedLocalizationException((Throwable)e);
        }
    }

    public void setLocalizableProperties(PropertyMap map) throws UnexpectedLocalizationException {
        this.checkCompatible();
        this.setDefaultLocalizableProperties(map);
        boolean isLocalizationActiveCopy = this.isLocalizationActive;
        if (!this.isLocalizationActive) {
            this.beginLocalization();
        }
        if (this.promptDefinition != null) {
            ((LocalizableProperties)this.promptDefinition).setLocalizableProperties(map.getNestedProperties("Prompt"));
        }
        if (!isLocalizationActiveCopy) {
            this.endLocalization();
        }
    }

    public void setLocalizableProperties(Locale locale, PropertyMap map) throws UnexpectedLocalizationException {
        this.checkCompatible();
        boolean isLocalizationActiveCopy = this.isLocalizationActive;
        if (!this.isLocalizationActive) {
            this.beginLocalization();
        }
        if (this.promptDefinition != null) {
            ((MultiLocaleProperties)this.promptDefinition).setLocalizableProperties(locale, map.getNestedProperties("Prompt"));
        }
        if (!isLocalizationActiveCopy) {
            this.endLocalization();
        }
    }

    public void endLocalization() throws UnexpectedLocalizationException {
        this.checkCompatible();
        try {
            if (this.promptDefinition != null) {
                PromptsPersistUtil.updateDefinitionSmartObject(this.promptDefinition, this.getRepository().getUserContext(), this, null);
            }
            this.promptDefinition = null;
            this.isLocalizationActive = false;
        }
        catch (Exception e) {
            throw new UnexpectedLocalizationException((Throwable)e);
        }
    }

    private void checkReadCompatible() {
        try {
            if (!this.isReadCompatible()) {
                throw new IllegalStateException("Prompt definition with usage version " + this.getUsageVersion() + " is not supported.");
            }
        }
        catch (RemoteException e) {
            throw new IllegalStateException("Unexpected remote exception", e);
        }
    }

    private void checkCompatible() {
        try {
            if (!this.isCompatible()) {
                throw new IllegalStateException("Prompt definition with usage version " + this.getUsageVersion() + " is not supported.");
            }
        }
        catch (RemoteException e) {
            throw new IllegalStateException("Unexpected remote exception", e);
        }
    }

    public PropertyList getSubstitutionProperties() throws UnexpectedSubstitutionException {
        this.checkReadCompatible();
        PropertyList retVal = new PropertyList();
        try {
            PropertyList retVal0;
            this.logMessage(Level.DEBUG, "getSubstitutionProperties() was called.", this.getClass().getName(), null);
            PromptDefinitionInterface prompt = this.getPromptDefinition();
            if (null != prompt && prompt instanceof SubstitutionProperties && null != (retVal0 = ((SubstitutionProperties)prompt).getSubstitutionProperties()) && !retVal0.isEmpty()) {
                retVal.addComment("Nested properties for the named OMRPromptDefinition");
                retVal.addProperty(this.getName(), retVal0);
                this.logMessage(Level.DEBUG, "getSubstitutionProperties(), returning a list for " + this.getName(), this.getClass().getName(), null);
            }
        }
        catch (RemoteException e) {
            throw new UnexpectedSubstitutionException((Throwable)e);
        }
        catch (ServiceException e) {
            throw new UnexpectedSubstitutionException((Throwable)((Object)e));
        }
        return retVal;
    }

    public void setSubstitutionProperties(@NotNull PropertyMap map) throws UnexpectedSubstitutionException {
        this.checkCompatible();
        try {
            this.logMessage(Level.DEBUG, "setSubstitutionProperties() was called.", this.getClass().getName(), null);
            if (map.containsNestedProperty(this.getName())) {
                this.logMessage(Level.DEBUG, "setSubstitutionProperties(), proceeding for " + this.getName(), this.getClass().getName(), null);
                PromptDefinitionInterface prompt = this.getPromptDefinition();
                if (null != prompt && prompt instanceof SubstitutionProperties) {
                    ((SubstitutionProperties)prompt).setSubstitutionProperties(map.getNestedProperties(this.getName()));
                    PromptsPersistUtil.updateDefinitionSmartObject(prompt, this.getRepository().getUserContext(), this, null);
                }
            }
        }
        catch (RemoteException e) {
            throw new UnexpectedSubstitutionException((Throwable)e);
        }
        catch (ServiceException e) {
            throw new UnexpectedSubstitutionException((Throwable)((Object)e));
        }
    }
}

