/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.metadata.prompt;

import com.sas.metadata.remote.AbstractPrompt;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Classifier;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.Transformation;
import com.sas.services.ServiceException;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.VersionIncompatibleException;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.Metadata;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.prompt.BaseOMRPromptInterface;
import com.sas.services.information.metadata.prompt.PersistenceFactoryWithServices;
import com.sas.services.information.metadata.prompt.PromptsPersistUtil;
import com.sas.services.information.metadata.prompt.RB;
import com.sas.services.user.UserContextInterface;
import com.sas.util.UsageVersion;
import com.sas.util.ValidateArg;
import com.sas.util.xmlpersist.PersistenceInterface;
import com.sas.util.xmlpersist.PromptsReadingContext;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.logging.log4j.Level;
import org.xml.sax.SAXException;

abstract class AbstractPromptImpl
extends Metadata
implements BaseOMRPromptInterface {
    private static final long serialVersionUID = -1936040195053401872L;
    protected final String LOG_CONTEXT = this.getClass().getName();
    private static final String PROMPT = "prompt";
    private static final String METAOBJECT = "metaObject";
    protected static final String RB_KEY = "AbstractPromptImpl.";
    public static final UsageVersion OLDEST_VERSION = new UsageVersion(0, 0);
    public static final UsageVersion CURRENT_VERSION = new UsageVersion(1, 0);
    private int microVersion = 0;

    public AbstractPromptImpl(Class theClass) throws RemoteException {
        super(theClass);
    }

    public AbstractPromptImpl(Object o, Class theClass) throws RemoteException {
        super(o, theClass);
    }

    public AbstractPromptImpl(Object o) throws RemoteException {
        super(o);
    }

    public AbstractPromptImpl() throws RemoteException {
    }

    @Override
    public void removePromptEnabledObject() throws RemoteException, ServiceException {
        this.checkPulse(true);
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        if (null != this._repositoryObject) {
            try {
                ((AbstractPrompt)this._repositoryObject).getPromptEnabledObjects().clear();
                this.logMessage(Level.DEBUG, "removePromptEnabledObjects(): cleared!", this.LOG_CONTEXT, null);
            }
            catch (MdException e) {
                throw new ServiceException(e, e.getMessage());
            }
        }
    }

    @Override
    public void setPromptEnabledObject(MetadataInterface metaObject) throws RemoteException, ServiceException {
        this.checkPulse(true);
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        if (this.isPublic()) {
            String msg = RB.getStringResource("AbstractPromptImpl.cannotSetPromptEnabledObject.log");
            this.logMessage(Level.ERROR, msg, this.LOG_CONTEXT, null);
            throw new ServiceException(msg);
        }
        if (null == metaObject && null != this._repositoryObject) {
            try {
                ((AbstractPrompt)this._repositoryObject).getPromptEnabledObjects().clear();
            }
            catch (MdException e) {
                throw new ServiceException(e.getMessage());
            }
            this.logMessage(Level.DEBUG, "clearing promptEnabledObject", this.LOG_CONTEXT, null);
        } else {
            Object obj = metaObject.getRepositoryEntity();
            if (obj instanceof Root) {
                Root root = (Root)obj;
                if (null != this._repositoryObject) {
                    ((AbstractPrompt)this._repositoryObject).setPromptEnabledObject(root);
                    this.logMessage(Level.DEBUG, "setPromptEnabledObject() set to: " + metaObject.getName(), this.LOG_CONTEXT, null);
                }
            }
        }
    }

    @Override
    public MetadataInterface getPromptEnabledObject() throws RemoteException, ServiceException {
        this.checkPulse(true);
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        MetadataInterface retVal = null;
        if (null != this._repositoryObject) {
            try {
                Root root = ((AbstractPrompt)this._repositoryObject).getPromptEnabledObject();
                if (null != root) {
                    retVal = this._repository.factoryProcess(root);
                }
                if (null != retVal) {
                    this.logMessage(Level.DEBUG, "getPromptEnabledObject() returns: " + retVal.getName(), this.LOG_CONTEXT, null);
                } else {
                    this.logMessage(Level.DEBUG, "getPromptEnabledObject(): None (either root or retVal were null).", this.LOG_CONTEXT, null);
                }
            }
            catch (MdException e) {
                throw new ServiceException(e, e.getMessage());
            }
        }
        return retVal;
    }

    @Override
    public void addValueSource(MetadataInterface metaObject) throws RemoteException, ServiceException {
        this.checkPulse(true);
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        ValidateArg.notNull((Object)metaObject, (String)METAOBJECT);
        if (null != this._repositoryObject) {
            CMetadata reposObject = (CMetadata)metaObject.getRepositoryEntity();
            this.logMessage(Level.DEBUG, "Starting addValueSource() for: " + reposObject.getName(), this.LOG_CONTEXT, null);
            ClassifierMap map = null;
            try {
                Transformation out = ((AbstractPrompt)this._repositoryObject).getValueSource();
                if (null != out && out instanceof ClassifierMap) {
                    map = (ClassifierMap)out;
                } else {
                    OMIRepositoryInterface omiRepos = (OMIRepositoryInterface)this._repository;
                    map = (ClassifierMap)omiRepos.createMetadata(this.getName(), "ClassifierMap");
                }
                if (null != map) {
                    if (reposObject instanceof Column) {
                        DataTable table = ((Column)reposObject).getTable();
                        if (table != null) {
                            this.addClassifierSource(map, (CMetadata)table);
                        }
                    } else if (reposObject instanceof Classifier) {
                        this.addClassifierSource(map, reposObject);
                    } else {
                        this.addTransformationSource(map, reposObject);
                    }
                }
            }
            catch (MdException e) {
                throw new ServiceException(e, e.getMessage());
            }
            ((AbstractPrompt)this._repositoryObject).setValueSource((Transformation)map);
        }
    }

    private void addClassifierSource(ClassifierMap map, CMetadata reposObject) throws RemoteException, MdException {
        if (!map.getClassifierSources().contains((Object)reposObject)) {
            map.getClassifierSources().add((Object)reposObject);
            this.logMessage(Level.DEBUG, "added a Classifier source named: " + reposObject.getName(), this.LOG_CONTEXT, null);
        }
    }

    private void addTransformationSource(ClassifierMap map, CMetadata reposObject) throws RemoteException, MdException {
        if (!map.getTransformationSources().contains((Object)reposObject)) {
            map.getTransformationSources().add((Object)reposObject);
            this.logMessage(Level.DEBUG, "added a Transformation source named: " + reposObject.getName(), this.LOG_CONTEXT, null);
        }
    }

    @Override
    public List getValueSources() throws RemoteException, ServiceException {
        this.checkPulse(true);
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        ArrayList retVal = new ArrayList();
        if (null != this._repositoryObject) {
            try {
                Transformation trans = ((AbstractPrompt)this._repositoryObject).getValueSource();
                if (null != trans && trans instanceof ClassifierMap) {
                    AssociationList list2;
                    ClassifierMap map = (ClassifierMap)trans;
                    AssociationList list = map.getClassifierSources();
                    if (!list.isEmpty()) {
                        this.processSources(retVal, list.iterator());
                    }
                    if (!(list2 = map.getTransformationSources()).isEmpty()) {
                        this.processSources(retVal, list2.iterator());
                    }
                }
            }
            catch (MdException e) {
                this.logMessage(Level.INFO, e.getMessage(), this.LOG_CONTEXT, null);
            }
        }
        this.logMessage(Level.DEBUG, "Returning value source list of size: " + Integer.toString(retVal.size()), this.LOG_CONTEXT, null);
        return retVal;
    }

    private void processSources(List list, Iterator iterator) throws RemoteException, ServiceException {
        while (iterator.hasNext()) {
            Object element = iterator.next();
            MetadataInterface out = this._repository.factoryProcess(element);
            if (null == out) continue;
            list.add(out);
            this.logMessage(Level.DEBUG, "getValueSources() adding object to list: " + out.getName(), this.LOG_CONTEXT, null);
        }
    }

    @Override
    public void removeAllValueSources() throws RemoteException, ServiceException {
        this.checkPulse(true);
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        if (null != this._repositoryObject) {
            try {
                Transformation out = ((AbstractPrompt)this._repositoryObject).getValueSource();
                if (null != out) {
                    out.delete();
                    out.updateMetadataAll();
                    ((AbstractPrompt)this._repositoryObject).setValueSource(null);
                    this.logMessage(Level.DEBUG, "removeAllValueSources(): cleared!", this.LOG_CONTEXT, null);
                }
            }
            catch (MdException e) {
                throw new ServiceException(e, e.getMessage());
            }
        }
    }

    @Override
    public void addPromptReference(BaseOMRPromptInterface prompt) throws RemoteException, ServiceException {
        this.checkPulse(true);
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        if (!this.isPublic()) {
            String msg = RB.getStringResource("AbstractPromptImpl.cannotAddPromptReference.log");
            this.logMessage(Level.ERROR, msg, this.LOG_CONTEXT, null);
            throw new ServiceException(msg);
        }
        ValidateArg.notNull((Object)prompt, (String)PROMPT);
        this.logMessage(Level.DEBUG, "Starting addPromptReference() for: " + prompt.getName(), this.LOG_CONTEXT, null);
        if (prompt.isPublic()) {
            String msg = RB.getStringResource("AbstractPromptImpl.cannotAddPromptReference2.log");
            this.logMessage(Level.ERROR, msg, this.LOG_CONTEXT, null);
            throw new ServiceException(msg);
        }
        AbstractPrompt obj = (AbstractPrompt)prompt.getRepositoryEntity();
        if (null != this._repositoryObject) {
            try {
                AssociationList list = ((AbstractPrompt)this._repositoryObject).getPromptReferences();
                list.add((Object)obj);
            }
            catch (MdException e) {
                throw new ServiceException(e, e.getMessage());
            }
        }
    }

    @Override
    public void removePromptReference(BaseOMRPromptInterface prompt) throws RemoteException, ServiceException {
        this.checkPulse(true);
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        ValidateArg.notNull((Object)prompt, (String)PROMPT);
        AbstractPrompt obj = (AbstractPrompt)prompt.getRepositoryEntity();
        if (null != this._repositoryObject) {
            try {
                AssociationList list = ((AbstractPrompt)this._repositoryObject).getPromptReferences();
                if (list.contains((Object)obj)) {
                    list.remove((Object)obj);
                    this.logMessage(Level.DEBUG, "removePromptReference() removed: " + obj.getName(), this.LOG_CONTEXT, null);
                }
            }
            catch (MdException e) {
                throw new ServiceException(e, e.getMessage());
            }
        }
    }

    @Override
    public void removeAllPromptReferences() throws RemoteException, ServiceException {
        this.checkPulse(true);
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        if (null != this._repositoryObject) {
            try {
                AssociationList list = ((AbstractPrompt)this._repositoryObject).getPromptReferences();
                list.clear();
                this.logMessage(Level.DEBUG, "removeAllPromptReferences(): cleared!", this.LOG_CONTEXT, null);
            }
            catch (MdException e) {
                throw new ServiceException(e, e.getMessage());
            }
        }
    }

    @Override
    public List getPromptReferences() throws RemoteException, ServiceException {
        this.checkPulse(true);
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        ArrayList<MetadataInterface> retVal = new ArrayList<MetadataInterface>();
        if (null != this._repositoryObject) {
            try {
                AssociationList list = ((AbstractPrompt)this._repositoryObject).getPromptReferences();
                if (!list.isEmpty()) {
                    for (AbstractPrompt element : list) {
                        MetadataInterface out = this._repository.factoryProcess(element);
                        if (null == out) continue;
                        retVal.add(out);
                        this.logMessage(Level.DEBUG, "getPromptReferences() found: " + out.getName(), this.LOG_CONTEXT, null);
                    }
                } else {
                    this.logMessage(Level.DEBUG, "getPromptReferences(): None found.", this.LOG_CONTEXT, null);
                }
            }
            catch (MdException e) {
                throw new ServiceException(e, e.getMessage());
            }
        }
        return retVal;
    }

    @Override
    public void addReferencedPrompt(BaseOMRPromptInterface prompt) throws RemoteException, ServiceException {
        this.checkPulse(true);
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        if (this.isPublic()) {
            String msg = RB.getStringResource("AbstractPromptImpl.cannotAddReferencedPrompt.log");
            this.logMessage(Level.ERROR, msg, this.LOG_CONTEXT, null);
            throw new ServiceException(msg);
        }
        ValidateArg.notNull((Object)prompt, (String)PROMPT);
        this.logMessage(Level.DEBUG, "Starting addReferencedPrompt() for: " + prompt.getName(), this.LOG_CONTEXT, null);
        if (!prompt.isPublic()) {
            String msg = RB.getStringResource("AbstractPromptImpl.cannotAddReferencedPrompt2.log");
            this.logMessage(Level.ERROR, msg, this.LOG_CONTEXT, null);
            throw new ServiceException(msg);
        }
        AbstractPrompt obj = (AbstractPrompt)prompt.getRepositoryEntity();
        if (null != this._repositoryObject) {
            try {
                AssociationList list = ((AbstractPrompt)this._repositoryObject).getReferencedPrompts();
                list.add((Object)obj);
            }
            catch (MdException e) {
                throw new ServiceException(e, e.getMessage());
            }
        }
    }

    @Override
    public void removeReferencedPrompt(BaseOMRPromptInterface prompt) throws RemoteException, ServiceException {
        this.checkPulse(true);
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        ValidateArg.notNull((Object)prompt, (String)PROMPT);
        AbstractPrompt obj = (AbstractPrompt)prompt.getRepositoryEntity();
        if (null != this._repositoryObject) {
            try {
                AssociationList list = ((AbstractPrompt)this._repositoryObject).getReferencedPrompts();
                if (list.contains((Object)obj)) {
                    list.remove((Object)obj);
                    this.logMessage(Level.DEBUG, "removeReferencedPrompt() removed: " + obj.getName(), this.LOG_CONTEXT, null);
                }
            }
            catch (MdException e) {
                throw new ServiceException(e, e.getMessage());
            }
        }
    }

    @Override
    public void removeAllReferencedPrompts() throws RemoteException, ServiceException {
        this.checkPulse(true);
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        if (null != this._repositoryObject) {
            try {
                AssociationList list = ((AbstractPrompt)this._repositoryObject).getReferencedPrompts();
                list.clear();
                this.logMessage(Level.DEBUG, "removeAllReferencedPrompts(): cleared!", this.LOG_CONTEXT, null);
            }
            catch (MdException e) {
                throw new ServiceException(e, e.getMessage());
            }
        }
    }

    @Override
    public List getReferencedPrompts() throws RemoteException, ServiceException {
        this.checkPulse(true);
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        ArrayList<MetadataInterface> retVal = new ArrayList<MetadataInterface>();
        if (null != this._repositoryObject) {
            try {
                AssociationList list = ((AbstractPrompt)this._repositoryObject).getReferencedPrompts();
                if (!list.isEmpty()) {
                    for (AbstractPrompt element : list) {
                        MetadataInterface out = this._repository.factoryProcess(element);
                        if (null == out) continue;
                        retVal.add(out);
                        this.logMessage(Level.DEBUG, "getReferencedPrompts() adding: " + out.getName(), this.LOG_CONTEXT, null);
                    }
                } else {
                    this.logMessage(Level.DEBUG, "getPromptReferences(): None found.", this.LOG_CONTEXT, null);
                }
            }
            catch (MdException e) {
                throw new ServiceException(e, e.getMessage());
            }
        }
        return retVal;
    }

    @Override
    public void delete() throws ServiceException, RemoteException {
        String msg;
        this.checkPulse(true);
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.logMessage(Level.DEBUG, "delete() is running for: " + this.getName(), this.LOG_CONTEXT, null);
        if (null != this.getPromptEnabledObject()) {
            msg = RB.getStringResource("AbstractPromptImpl.cannotDelete.log");
            this.logMessage(Level.WARN, msg, this.LOG_CONTEXT, null);
        }
        this.update();
        if (this.countAssociatedObjects("PromptReferences") > 0) {
            msg = RB.getStringResource("AbstractPromptImpl.cannotDeleteDue2Refs.log");
            this.logMessage(Level.WARN, msg, this.LOG_CONTEXT, null);
        }
        this.removeAllPromptReferences();
        this.removeAllReferencedPrompts();
        this.removeAllValueSources();
        this.logMessage(Level.DEBUG, "deleting " + this.getName(), this.LOG_CONTEXT, null);
        super.delete();
    }

    @Override
    public MetadataInterface copyTo(FolderInterface folder, String name) throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.logMessage(Level.DEBUG, "copyTo() is running for: " + name, this.LOG_CONTEXT, null);
        BaseOMRPromptInterface retVal = (BaseOMRPromptInterface)super.copyTo(folder, name);
        List list = this.getValueSources();
        this.logMessage(Level.DEBUG, "Copying value sources numbering: " + list.size(), this.LOG_CONTEXT, null);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            retVal.addValueSource((MetadataInterface)iterator.next());
        }
        return retVal;
    }

    @Override
    public boolean isPublic() throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (this.getParents().isEmpty()) {
            this.logMessage(Level.DEBUG, "This prompt is private: " + this.getName(), this.LOG_CONTEXT, null);
            return false;
        }
        this.logMessage(Level.DEBUG, "This prompt is public: " + this.getName(), this.LOG_CONTEXT, null);
        return true;
    }

    protected PersistenceInterface getPromptFromXML(PromptsReadingContext readingContext, String xml) throws RemoteException, ServiceException {
        PersistenceInterface retVal = null;
        UserContextInterface userContext = this._repository.getUserContext();
        PromptsReadingContext myReadingContext = null;
        if (null == readingContext) {
            myReadingContext = PersistenceFactoryWithServices.newReadingContext(userContext);
            myReadingContext.setServer((Object)this._repository.getServer());
            this.logMessage(Level.DEBUG, "getPromptFromXML(), made our own reading context.", this.LOG_CONTEXT, null);
        } else {
            myReadingContext = readingContext;
        }
        try {
            retVal = PromptsPersistUtil.newPromptObject(null, xml, userContext, myReadingContext);
            if (null == readingContext) {
                myReadingContext.destroy();
            }
            this.logMessage(Level.DEBUG, "getPromptFromXML() returning from: " + this.getName(), this.LOG_CONTEXT, null);
        }
        catch (SAXException e) {
            throw new ServiceException(e, e.getMessage());
        }
        catch (IOException e) {
            throw new ServiceException(e, e.getMessage());
        }
        catch (ParserConfigurationException e) {
            throw new ServiceException(e, e.getMessage());
        }
        return retVal;
    }

    final void setMicroVersion(int microVersion) {
        this.microVersion = microVersion;
    }

    @Override
    public UsageVersion getUsageVersion() throws RemoteException {
        UsageVersion uv = super.getUsageVersion();
        return new UsageVersion(uv.getMajorVersion(), uv.getMinorVersion(), this.microVersion);
    }
}

