/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.metadata.libraries;

import com.sas.services.information.metadata.LoginInterface;
import com.sas.services.information.metadata.SASClientConnectionInterface;
import com.sas.services.information.metadata.ServerComponentInterface;
import com.sas.services.information.metadata.libraries.LibraryBuilder;

public final class OracleLibraryBuilder
extends LibraryBuilder<OracleLibraryBuilder> {
    private static final String ENGINE = "ORACLE";

    public static OracleLibraryBuilder builder() {
        return new OracleLibraryBuilder();
    }

    private OracleLibraryBuilder() {
        this.engine = ENGINE;
        this.isDBMSLibrary = true;
        this.dataServerPublicType = "Server.Oracle";
        this.prototypeName = "Library.Oracle.Prototype.Name.xmlKey.txt";
    }

    public OracleLibraryBuilder dataServer(String serverName) {
        this.dataServerName = serverName;
        return this;
    }

    public OracleLibraryBuilder dataServer(ServerComponentInterface server) {
        this.dataServer = server;
        return this;
    }

    public OracleLibraryBuilder schema(String schema) {
        this.schema = schema;
        return this;
    }

    public OracleLibraryBuilder connection(String connectionName) {
        this.connectionName = connectionName;
        return this;
    }

    public OracleLibraryBuilder connection(SASClientConnectionInterface connection) {
        this.connection = connection;
        return this;
    }

    public OracleLibraryBuilder defaultLogin(String defaultLoginUserId) {
        this.defaultLoginUserId = defaultLoginUserId;
        return this;
    }

    public OracleLibraryBuilder defaultLogin(LoginInterface defaultLogin) {
        this.defaultLogin = defaultLogin;
        return this;
    }
}

