/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.metadata.libraries;

import com.sas.metadata.remote.AbstractTransformation;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.SASLibrary;
import com.sas.metadata.remote.Transformation;
import com.sas.services.ServiceException;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.metadata.SASLibraryInterface;
import com.sas.services.information.metadata.libraries.SASLibraryUtil;
import com.sas.services.user.UserContextInterface;
import java.rmi.RemoteException;
import java.util.Collection;

public final class LASRLibraryUtil {
    private static final String ENGINE = "SASIOLA";

    private LASRLibraryUtil() {
    }

    public static SASLibraryInterface getLibrary(UserContextInterface userContext, String path) throws ServiceException {
        return SASLibraryUtil.getLibrary(userContext, path);
    }

    public static Collection<SASLibraryInterface> getAllLibraries(UserContextInterface userContext) throws ServiceException {
        return SASLibraryUtil.getAllLibraries(userContext, ENGINE);
    }

    public static SASLibraryInterface getDataProviderLibrary(SASLibraryInterface library) throws ServiceException {
        try {
            SASLibrary lasrLibraryObject = (SASLibrary)library.getRepositoryEntity();
            if (!lasrLibraryObject.getEngine().equalsIgnoreCase(ENGINE)) {
                throw new IllegalArgumentException("Library is not a LASR library");
            }
            AssociationList transforms = lasrLibraryObject.getTargetTransformations();
            for (AbstractTransformation transform : transforms) {
                if (!transform.getName().equals("DataProviderLibraryTransformation")) continue;
                AssociationList sources = transform.getTransformationSources();
                if (sources.size() > 0 && sources.get(0) instanceof SASLibrary) {
                    return (SASLibraryInterface)library.getRepository().factoryProcess(sources.get(0));
                }
                return null;
            }
            return null;
        }
        catch (RemoteException e) {
            throw new ServiceException(e);
        }
        catch (MdException e) {
            throw new ServiceException(e);
        }
    }

    public static void setDataProviderLibrary(SASLibraryInterface lasrLibrary, SASLibraryInterface dataProviderLibrary) throws ServiceException {
        try {
            AbstractTransformation transform2;
            SASLibrary lasrLibraryObject = (SASLibrary)lasrLibrary.getRepositoryEntity();
            if (!lasrLibraryObject.getEngine().equalsIgnoreCase(ENGINE)) {
                throw new IllegalArgumentException("Library is not a LASR library");
            }
            AssociationList transforms = lasrLibraryObject.getTargetTransformations();
            for (AbstractTransformation transform2 : transforms) {
                if (!transform2.getName().equals("DataProviderLibraryTransformation")) continue;
                if (dataProviderLibrary != null) {
                    transform2.getTransformationSources().clear();
                    transform2.getTransformationSources().add(dataProviderLibrary.getRepositoryEntity());
                } else {
                    transform2.delete();
                }
                return;
            }
            if (dataProviderLibrary == null) {
                return;
            }
            OMIRepositoryInterface repos = (OMIRepositoryInterface)lasrLibrary.getRepository();
            transform2 = (Transformation)repos.createMetadata("DataProviderLibraryTransformation", "Transformation");
            transform2.setTransformRole("DataProviderLibrary");
            transform2.getTransformationSources().add(dataProviderLibrary.getRepositoryEntity());
            transform2.getTransformationTargets().add((Object)lasrLibraryObject);
            return;
        }
        catch (RemoteException e) {
            throw new ServiceException(e);
        }
        catch (MdException e) {
            throw new ServiceException(e);
        }
    }
}

