/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.metadata.favorites.impl;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.impl.FavoritesContainerImpl;
import com.sas.metadata.remote.impl.FavoritesContainerImpl_Stub;
import com.sas.services.ServiceException;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.PathUrl;
import com.sas.services.information.metadata.favorites.FavoritesContainer;
import com.sas.services.information.metadata.favorites.FavoritesGroup;
import com.sas.services.information.metadata.favorites.impl.AbstractFavoritesContainer;
import com.sas.services.information.metadata.favorites.impl.RB;
import com.sas.services.information.publicobject.PublicObjectContainerInterface;
import com.sas.services.util.Names;
import com.sas.text.Message;
import java.rmi.RemoteException;
import java.util.ResourceBundle;
import org.apache.logging.log4j.Level;

public class FavoritesGroupImpl
extends AbstractFavoritesContainer
implements FavoritesGroup {
    private static final long serialVersionUID = 5024127592732394671L;

    public FavoritesGroupImpl() throws RemoteException {
        super(FavoritesGroupImpl.class);
    }

    public FavoritesGroupImpl(Object o, Class theClass) throws RemoteException {
        super(o, theClass);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public FavoritesGroupImpl(Object o) throws RemoteException {
        super(o);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public FavoritesGroupImpl(com.sas.metadata.remote.FavoritesContainer o) throws RemoteException {
        super(o, FavoritesGroupImpl.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public FavoritesGroupImpl(FavoritesContainerImpl o) throws RemoteException {
        super(o, FavoritesGroupImpl.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public FavoritesGroupImpl(FavoritesContainerImpl_Stub o) throws RemoteException {
        super(o, FavoritesGroupImpl.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public FavoritesGroupImpl(RepositoryInterface repos, String name, FolderInterface parent) throws RemoteException {
        super(FavoritesGroupImpl.class);
        if (repos == null || name == null) {
            throw new IllegalArgumentException();
        }
        OMIRepositoryInterface omirepository = (OMIRepositoryInterface)repos;
        try {
            com.sas.metadata.remote.FavoritesContainer favoritesGroup = (com.sas.metadata.remote.FavoritesContainer)omirepository.createMetadata(name, "FavoritesContainer");
            favoritesGroup.setPublicType("FavoritesGroup");
            favoritesGroup.setUsageVersion(CURRENT_VERSION.encode());
            this._isCompatible = true;
            this._isReadCompatible = true;
            this._repositoryObject = favoritesGroup;
            this._repositoryFlag = 2;
            this.setRepository(repos);
        }
        catch (ServiceException ex) {
            this.logThrowable(Level.WARN, ex.getMessage(), "com.sas.services.information.metadata.favorites.impl.FavoritesGroupImpl", (Throwable)((Object)ex));
        }
    }

    @Override
    public String getType() throws RemoteException {
        return "FavoritesGroup";
    }

    @Override
    public FavoritesContainer getFavoritesContainer() throws ServiceException, RemoteException {
        this.checkReadAllowed();
        com.sas.metadata.remote.FavoritesContainer container = (com.sas.metadata.remote.FavoritesContainer)this.getRepositoryEntity();
        try {
            MetadataInterface mi;
            com.sas.metadata.remote.FavoritesContainer parentContainer = container.getParentContainer();
            if (parentContainer != null && (mi = this._repository.factoryProcess(parentContainer)) instanceof FavoritesContainer) {
                return (FavoritesContainer)mi;
            }
        }
        catch (MdException mdex) {
            throw new ServiceException(mdex, mdex.getMessage());
        }
        return null;
    }

    @Override
    public void setFavoritesContainer(FavoritesContainer parent) throws ServiceException, RemoteException {
        this.checkWriteAllowed();
        com.sas.metadata.remote.FavoritesContainer container = (com.sas.metadata.remote.FavoritesContainer)this.getRepositoryEntity();
        try {
            com.sas.metadata.remote.FavoritesContainer parentContainer = (com.sas.metadata.remote.FavoritesContainer)parent.getRepositoryEntity();
            AssociationList containers = container.getParentContainers();
            if (!containers.isEmpty()) {
                containers.clear();
            }
            containers.add(parentContainer);
            parentContainer.touch();
        }
        catch (MdException e) {
            throw new ServiceException(e, e.getMessage());
        }
    }

    @Override
    public void setName(String name) throws RemoteException {
        this.checkPulse(true);
        String myName = this.getName();
        if (myName != null && myName.equals(name)) {
            return;
        }
        Names.validateOMRObjectName(name, true);
        if (!name.equalsIgnoreCase(myName)) {
            try {
                FavoritesContainer container = this.getFavoritesContainer();
                if (container != null && container.hasDuplicateFavoritesGroup(name)) {
                    String msg = Message.format((ResourceBundle)RB.getResources(), (String)"AbstractFavoritesContainer.Duplicate.fmt.txt", (Object)name);
                    throw new IllegalArgumentException(msg);
                }
            }
            catch (ServiceException ex) {
                throw new RuntimeException(ex.getMessage(), (Throwable)((Object)ex));
            }
        }
        com.sas.metadata.remote.FavoritesContainer fc = (com.sas.metadata.remote.FavoritesContainer)this._repositoryObject;
        fc.setName(name);
    }

    @Override
    public PublicObjectContainerInterface getContainer() throws ServiceException, RemoteException {
        return this.getFavoritesContainer();
    }

    @Override
    public PathUrl getPathUrl() throws IllegalStateException, ServiceException, RemoteException {
        PublicObjectContainerInterface myContainer = this.getContainer();
        if (myContainer == null) {
            return null;
        }
        PathUrl containerPath = (PathUrl)myContainer.getPathUrl().clone();
        String extendedPath = containerPath.getExtendedPath();
        if (extendedPath == null || extendedPath.length() == 0) {
            containerPath.setExtendedPath(PathUrl.encodeString(this.getName()) + "(" + this.getType() + ")");
        } else {
            extendedPath = extendedPath + '#' + PathUrl.encodeString(this.getName()) + "(" + this.getType() + ")";
            containerPath.setExtendedPath(extendedPath);
        }
        return containerPath;
    }

    @Override
    public void delete() throws ServiceException, RemoteException {
        Object fc;
        FavoritesContainer container = this.getFavoritesContainer();
        super.delete();
        if (this.isDeleted() && container != null && (fc = container.getRepositoryEntity()) instanceof com.sas.metadata.remote.FavoritesContainer) {
            ((com.sas.metadata.remote.FavoritesContainer)fc).touch();
            container.update();
        }
    }
}

