/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.metadata;

import com.sas.services.information.metadata.RB;
import com.sas.util.Strings;
import java.util.MissingResourceException;

public class SubscriberDeliveryTransports {
    public static final int SUBSCRIPTION_TYPE_CONTENT = 0;
    public static final int SUBSCRIPTION_TYPE_EVENT = 1;
    public static final String DELIVERY_TRANSPORT_CODE_EMAIL = "email";
    public static final String DELIVERY_TRANSPORT_CODE_HTTP = "http";
    public static final String DELIVERY_TRANSPORT_CODE_NONE = "none";
    public static final String DELIVERY_TRANSPORT_CODE_QUEUE = "queue";
    public static final String DELIVERY_TRANSPORT_CODE_WEBDAV = "webdav";
    private static String LOCALIZED_DELIVERY_TRANSPORT_EMAIL = null;
    private static String LOCALIZED_DELIVERY_TRANSPORT_HTTP = null;
    private static String LOCALIZED_DELIVERY_TRANSPORT_NONE = null;
    private static String LOCALIZED_DELIVERY_TRANSPORT_QUEUE = null;
    private static String LOCALIZED_DELIVERY_TRANSPORT_WEBDAV = null;
    private static final String[][] DELIVERY_TRANSPORTS_CONTENT;
    private static final String[][] DELIVERY_TRANSPORTS_EVENT;
    private static final int INDEX_CODE = 0;
    private static final int INDEX_LOCALIZED = 1;

    public static final String[] getLocalizedDeliveryTransports(int subscriptionType) {
        String[] deliveryTransports = null;
        if (subscriptionType == 0) {
            deliveryTransports = SubscriberDeliveryTransports.getDeliveryTransports(DELIVERY_TRANSPORTS_CONTENT);
        } else if (subscriptionType == 1) {
            deliveryTransports = SubscriberDeliveryTransports.getDeliveryTransports(DELIVERY_TRANSPORTS_EVENT);
        }
        return deliveryTransports;
    }

    public static final String getDeliveryTransportCode(int subscriptionType, int index) {
        String deliveryTransportCode = null;
        String[][] deliveryTransports = null;
        if (subscriptionType == 0) {
            deliveryTransports = DELIVERY_TRANSPORTS_CONTENT;
        } else if (subscriptionType == 1) {
            deliveryTransports = DELIVERY_TRANSPORTS_EVENT;
        }
        if (deliveryTransports != null && deliveryTransports.length > index && index >= 0) {
            deliveryTransportCode = deliveryTransports[index][0];
        }
        if (deliveryTransportCode == null) {
            throw new IllegalArgumentException();
        }
        return deliveryTransportCode;
    }

    public static final String getDefaultDeliveryTransportCode(int subscriptionType) {
        String defaultDeliveryTransportCode = null;
        if (subscriptionType == 0) {
            defaultDeliveryTransportCode = DELIVERY_TRANSPORT_CODE_NONE;
        } else if (subscriptionType == 1) {
            defaultDeliveryTransportCode = DELIVERY_TRANSPORT_CODE_NONE;
        }
        return defaultDeliveryTransportCode;
    }

    public static final String getDeliveryTransportResource(int subscriptionType, String deliveryTransportCode) {
        String deliveryTransportResource = null;
        if (deliveryTransportCode != null) {
            String[][] deliveryTransports = null;
            if (subscriptionType == 0) {
                deliveryTransports = DELIVERY_TRANSPORTS_CONTENT;
            } else if (subscriptionType == 1) {
                deliveryTransports = DELIVERY_TRANSPORTS_EVENT;
            }
            if (deliveryTransports != null) {
                int numTransports = deliveryTransports.length;
                String deliveryTransportCodeCandidate = null;
                for (int i = 0; i < numTransports; ++i) {
                    deliveryTransportCodeCandidate = deliveryTransports[i][0];
                    if (!Strings.equal((String)deliveryTransportCode, (String)deliveryTransportCodeCandidate, (boolean)false, (boolean)false)) continue;
                    deliveryTransportResource = deliveryTransports[i][1];
                    break;
                }
            }
        }
        if (deliveryTransportCode == null) {
            throw new IllegalArgumentException();
        }
        return deliveryTransportResource;
    }

    private static final String[] getDeliveryTransports(String[][] codeResource) {
        int numTransports = codeResource != null ? codeResource.length : 0;
        String[] deliveryTransports = new String[numTransports];
        for (int i = 0; i < numTransports; ++i) {
            deliveryTransports[i] = codeResource[i][1];
        }
        return deliveryTransports;
    }

    static {
        try {
            LOCALIZED_DELIVERY_TRANSPORT_EMAIL = RB.getStringResource("SubscriberDeliveryTransports.email.txt");
            LOCALIZED_DELIVERY_TRANSPORT_HTTP = RB.getStringResource("SubscriberDeliveryTransports.http.txt");
            LOCALIZED_DELIVERY_TRANSPORT_NONE = RB.getStringResource("SubscriberDeliveryTransports.none.txt");
            LOCALIZED_DELIVERY_TRANSPORT_QUEUE = RB.getStringResource("SubscriberDeliveryTransports.queue.txt");
            LOCALIZED_DELIVERY_TRANSPORT_WEBDAV = RB.getStringResource("SubscriberDeliveryTransports.webdav.txt");
        }
        catch (MissingResourceException e) {
            LOCALIZED_DELIVERY_TRANSPORT_EMAIL = DELIVERY_TRANSPORT_CODE_EMAIL;
            LOCALIZED_DELIVERY_TRANSPORT_HTTP = DELIVERY_TRANSPORT_CODE_HTTP;
            LOCALIZED_DELIVERY_TRANSPORT_NONE = DELIVERY_TRANSPORT_CODE_NONE;
            LOCALIZED_DELIVERY_TRANSPORT_QUEUE = DELIVERY_TRANSPORT_CODE_QUEUE;
            LOCALIZED_DELIVERY_TRANSPORT_WEBDAV = DELIVERY_TRANSPORT_CODE_WEBDAV;
        }
        DELIVERY_TRANSPORTS_CONTENT = new String[][]{{DELIVERY_TRANSPORT_CODE_NONE, LOCALIZED_DELIVERY_TRANSPORT_NONE}, {DELIVERY_TRANSPORT_CODE_EMAIL, LOCALIZED_DELIVERY_TRANSPORT_EMAIL}, {DELIVERY_TRANSPORT_CODE_WEBDAV, LOCALIZED_DELIVERY_TRANSPORT_WEBDAV}, {DELIVERY_TRANSPORT_CODE_QUEUE, LOCALIZED_DELIVERY_TRANSPORT_QUEUE}};
        DELIVERY_TRANSPORTS_EVENT = new String[][]{{DELIVERY_TRANSPORT_CODE_NONE, LOCALIZED_DELIVERY_TRANSPORT_NONE}, {DELIVERY_TRANSPORT_CODE_HTTP, LOCALIZED_DELIVERY_TRANSPORT_HTTP}, {DELIVERY_TRANSPORT_CODE_QUEUE, LOCALIZED_DELIVERY_TRANSPORT_QUEUE}};
    }
}

