/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.metadata;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.services.information.Filter;
import com.sas.services.util.XMLUtil;
import java.util.ArrayList;
import java.util.List;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public class ServerFilter
extends Filter {
    private static final long serialVersionUID = 4717523970119218867L;
    private static final int SELECT_BUFFER_INIT = 128;
    private static final String SERVER_TEMPLATE = "<Templates>\n<DeployedComponent Name=\"\" >\n  <PropertySets/>\n  <Properties/>\n  <SourceConnections/>\n  <ProviderConnections/>\n  <AssociatedMachine/>\n</DeployedComponent>\n</Templates>";
    public static final int SERVER_ANY = 0;
    public static final int SERVER_LDAP = 1;
    public static final int SERVER_OMI = 2;
    public static final int SERVER_DAV = 4;
    public static final int SERVER_WORKSPACE = 8;
    public static final int SERVER_STOREDPROCESS = 16;
    public static final int SERVER_MDX = 32;
    public static final int SERVER_GMS = 64;
    public static final int SERVER_MQX = 128;
    public static final int SERVER_FTP = 256;
    private int _type = 0;
    private List protocols = new ArrayList();

    public ServerFilter() {
        this.protocols.add("omi");
        this.setType("Server");
    }

    public ServerFilter(String key, int relation, String value) {
        super(key, relation, value);
        this.setType("Server");
    }

    @Override
    public String getOMRType() {
        return "ServerComponent";
    }

    public String getLDAPType() {
        return "sasServer";
    }

    public void setServerType(int type) {
        this._type = type;
    }

    public int getServerType() {
        return this._type;
    }

    @Override
    public String getXMLSelectString() {
        StringBuffer buffer = new StringBuffer(128);
        String name = this.getName();
        boolean join = false;
        if (name != null || this._type != 0) {
            buffer.append("<XMLSelect Search=\"*[");
            if (name != null) {
                buffer.append("@Name='" + XMLUtil.normalize(name) + '\'');
                join = true;
            }
            if (this._type != 0) {
                if (join) {
                    buffer.append(" AND");
                }
                boolean firstName = true;
                if ((this._type & 1) != 0) {
                    if (join && !firstName) {
                        buffer.append(" OR");
                    }
                    buffer.append(" @ClassIdentifier='LDAP'");
                    join = true;
                    firstName = false;
                }
                if ((this._type & 2) != 0) {
                    if (join && !firstName) {
                        buffer.append(" OR");
                    }
                    buffer.append(" @ClassIdentifier='0217e202-b560-11db-ad91-001083ff6836'");
                    join = true;
                    firstName = false;
                }
                if ((this._type & 4) != 0) {
                    if (join && !firstName) {
                        buffer.append(" OR");
                    }
                    buffer.append(" @ClassIdentifier='DAC0D7F0-10DA-11D6-8816-AA0004006D06'");
                    join = true;
                    firstName = false;
                }
                if ((this._type & 0x100) != 0) {
                    if (join && !firstName) {
                        buffer.append(" OR");
                    }
                    buffer.append(" @ClassIdentifier='CBA26437-1577-4FF8-93F6-9B68B4DD8D2E'");
                    join = true;
                    firstName = false;
                }
                if ((this._type & 8) != 0) {
                    if (join && !firstName) {
                        buffer.append(" OR");
                    }
                    buffer.append(" @ClassIdentifier='440196d4-90f0-11d0-9f41-00a024bb830c'");
                    join = true;
                    firstName = false;
                }
                if ((this._type & 0x10) != 0) {
                    if (join && !firstName) {
                        buffer.append(" OR");
                    }
                    buffer.append(" @ClassIdentifier='15931e31-667f-11d5-8804-00c04f35ac8c'");
                    join = true;
                    firstName = false;
                }
                if ((this._type & 0x20) != 0) {
                    if (join && !firstName) {
                        buffer.append(" OR");
                    }
                    buffer.append(" @ClassIdentifier='f3f46472-1e31-11d5-87c2-00c04f38f9f6'");
                    join = true;
                    firstName = false;
                }
                if ((this._type & 0x40) != 0) {
                    if (join && !firstName) {
                        buffer.append(" OR");
                    }
                    buffer.append(" @ClassIdentifier='9c186a64-83e4-11d2-b956-00c04f81993c'");
                    join = true;
                    firstName = false;
                }
                if ((this._type & 0x80) != 0) {
                    if (join) {
                        buffer.append(" OR");
                    }
                    buffer.append(" @ClassIdentifier='8d9ef489-8d1e-11d2-b94f-00c04f8198c0'");
                    join = true;
                    firstName = false;
                }
            }
            buffer.append("]\" />\n");
            if (this.getOMRTemplate() == null) {
                this.setOMRTemplate(SERVER_TEMPLATE);
            }
        }
        return buffer.toString();
    }

    @Override
    public String getDAVBasicSearchString() {
        return "UNSUPPORTED";
    }

    @Override
    public String getDAVSQLString() {
        return "UNSUPPORTED";
    }

    @Override
    public List getProtocols() {
        return this.protocols;
    }
}

