/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.metadata;

import com.sas.codepolicy.SASScope;
import com.sas.metadata.remote.TextStore;
import com.sas.metadata.remote.impl.TextStoreImpl;
import com.sas.metadata.remote.impl.TextStoreImpl_Stub;
import com.sas.services.ServiceException;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.VersionIncompatibleException;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.Metadata;
import com.sas.services.information.metadata.RB;
import com.sas.services.information.metadata.TextStoreInterface;
import com.sas.util.BASE64;
import com.sas.util.UsageVersion;
import java.io.UnsupportedEncodingException;
import java.rmi.RemoteException;
import org.apache.logging.log4j.Level;

@SASScope
public class OMRTextStore
extends Metadata
implements TextStoreInterface {
    private static final long serialVersionUID = 1148388257796403361L;
    public static final UsageVersion OLDEST_VERSION = new UsageVersion(0, 0);
    public static final UsageVersion CURRENT_VERSION = new UsageVersion(1, 0);
    public static final String BINARY_PREFIX = "{BASE64}";

    public OMRTextStore() throws RemoteException {
        this(OMRTextStore.class);
    }

    public OMRTextStore(TextStore t) throws RemoteException {
        this(t, OMRTextStore.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRTextStore(TextStoreImpl t) throws RemoteException {
        this(t, OMRTextStore.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRTextStore(TextStoreImpl_Stub t) throws RemoteException {
        this(t, OMRTextStore.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRTextStore(RepositoryInterface repos, String name, FolderInterface parent) throws RemoteException {
        this(repos, name, parent, OMRTextStore.class);
    }

    protected OMRTextStore(Class theClass) throws RemoteException {
        super(theClass);
    }

    protected OMRTextStore(TextStore t, Class theClass) throws RemoteException {
        super(t, theClass);
    }

    protected OMRTextStore(TextStoreImpl t, Class theClass) throws RemoteException {
        super(t, theClass);
    }

    protected OMRTextStore(TextStoreImpl_Stub t, Class theClass) throws RemoteException {
        super(t, theClass);
    }

    protected OMRTextStore(RepositoryInterface repos, String name, FolderInterface parent, Class theClass) throws RemoteException {
        block5: {
            super(theClass);
            if (repos == null || name == null) {
                throw new IllegalArgumentException();
            }
            OMIRepositoryInterface omirepository = (OMIRepositoryInterface)repos;
            try {
                TextStore text = (TextStore)omirepository.createMetadata(name, "TextStore");
                text.setUsageVersion(CURRENT_VERSION.encode());
                this._isCompatible = true;
                this._isReadCompatible = true;
                this._repositoryObject = text;
                this._repositoryFlag = 2;
                this.setRepository(repos);
                if (parent == null) break block5;
                try {
                    parent.addItem(this);
                }
                catch (ServiceException ex) {
                    text.delete();
                    throw new RuntimeException(ex.getMessage(), (Throwable)((Object)ex));
                }
            }
            catch (ServiceException e) {
                if (!this.isLoggingEnabled(Level.WARN, "com.sas.services.information.metadata.OMRTextStore")) break block5;
                this.logMessage(Level.WARN, RB.getStringResource("Metadata.accessexcept.msg.txt"), "com.sas.services.information.metadata.OMRTextStore", (Throwable)((Object)e));
            }
        }
    }

    @Override
    public String getType() throws RemoteException {
        return "TextStore";
    }

    @Override
    public String getText() throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        TextStore text = (TextStore)this._repositoryObject;
        return text.getStoredText();
    }

    @Override
    public void setText(String text) throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        TextStore ts = (TextStore)this._repositoryObject;
        ts.setStoredText(text);
    }

    @Override
    public String getTextRole() throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        TextStore text = (TextStore)this._repositoryObject;
        return text.getTextRole();
    }

    @Override
    public void setTextRole(String role) throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        TextStore ts = (TextStore)this._repositoryObject;
        ts.setTextRole(role);
    }

    @Override
    public String getTextType() throws ServiceException, RemoteException {
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        TextStore text = (TextStore)this._repositoryObject;
        return text.getTextType();
    }

    @Override
    public void setTextType(String type) throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        TextStore ts = (TextStore)this._repositoryObject;
        ts.setTextType(type);
    }

    @Override
    public byte[] getBytes() throws ServiceException, RemoteException {
        if (this.containsBytes()) {
            return BASE64.decode((String)this.getText().substring(BINARY_PREFIX.length()));
        }
        try {
            return this.getText().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean containsBytes() throws ServiceException, RemoteException {
        return this.getText().startsWith(BINARY_PREFIX);
    }

    @Override
    public void setBytes(byte[] bytes) throws ServiceException, RemoteException {
        this.setText(BINARY_PREFIX + BASE64.encode((byte[])bytes));
    }
}

