/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.metadata;

import com.sas.metadata.remote.ServerComponent;
import com.sas.metadata.remote.impl.ServerComponentImpl;
import com.sas.metadata.remote.impl.ServerComponentImpl_Stub;
import com.sas.services.ServiceException;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.metadata.ConnectionInterface;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.OMRServerComponent;
import com.sas.services.information.metadata.PropertyInterface;
import com.sas.services.information.metadata.SPDSServerInterface;
import com.sas.services.information.metadata.ServerSubPropsHandler;
import com.sas.storage.editableproperties.PropertyList;
import com.sas.storage.editableproperties.PropertyMap;
import com.sas.storage.editableproperties.UnexpectedSubstitutionException;
import com.sas.util.UsageVersion;
import java.rmi.RemoteException;
import java.util.List;

public class OMRSPDSServer
extends OMRServerComponent
implements SPDSServerInterface {
    public static final UsageVersion OLDEST_VERSION = new UsageVersion(0, 0);
    public static final UsageVersion CURRENT_VERSION = new UsageVersion(1, 0);

    public OMRSPDSServer() throws RemoteException {
    }

    public OMRSPDSServer(ServerComponent o) throws RemoteException {
        this(o, OMRSPDSServer.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRSPDSServer(ServerComponentImpl o) throws RemoteException {
        this(o, OMRSPDSServer.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRSPDSServer(ServerComponentImpl_Stub o) throws RemoteException {
        this(o, OMRSPDSServer.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRSPDSServer(RepositoryInterface repos, String name, FolderInterface parent) throws RemoteException {
        this(repos, name, parent, OMRSPDSServer.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    protected OMRSPDSServer(Class theClass) throws RemoteException {
        super(theClass);
    }

    protected OMRSPDSServer(ServerComponent o, Class theClass) throws RemoteException {
        super(o, theClass);
    }

    protected OMRSPDSServer(ServerComponentImpl o, Class theClass) throws RemoteException {
        super(o, theClass);
    }

    protected OMRSPDSServer(ServerComponentImpl_Stub o, Class theClass) throws RemoteException {
        super(o, theClass);
    }

    protected OMRSPDSServer(RepositoryInterface repos, String name, FolderInterface parent, Class theClass) throws RemoteException {
        super(repos, name, parent, theClass);
        ServerComponent sc = (ServerComponent)this._repositoryObject;
        sc.setClassIdentifier("SASSPDS");
    }

    @Override
    public String getType() throws RemoteException {
        return "Server.SPDS";
    }

    @Override
    public PropertyList getSubstitutionProperties() {
        PropertyList srvProperties = new PropertyList();
        try {
            if (this.getTypeDescriptor() != null) {
                String serverName = this.getName();
                List _lstCon = this.getSourceConnections();
                if (_lstCon != null && _lstCon.size() > 0) {
                    for (int i = 0; i < _lstCon.size(); ++i) {
                        ConnectionInterface con = (ConnectionInterface)_lstCon.get(i);
                        List<MetadataInterface> lstProp = con.getProperties();
                        if (lstProp == null || lstProp.size() <= 0) continue;
                        for (int j = 0; j < lstProp.size(); ++j) {
                            String port;
                            PropertyInterface prop = (PropertyInterface)lstProp.get(j);
                            String propertyName = prop.getKey();
                            String serverHost = ServerSubPropsHandler.getHostServerPropertyName(this.getType());
                            if (serverHost != null && serverHost.equalsIgnoreCase(propertyName)) {
                                if (_lstCon.size() > 1) {
                                    String contextValue = con.getName() + ":" + serverName;
                                    srvProperties.addBlankLine();
                                    srvProperties.addProperty("Host[" + (i + 1) + "]", prop.getValue());
                                    srvProperties.addProperty("Host." + con.getType() + "[" + (i + 1) + "]", contextValue);
                                } else {
                                    srvProperties.addBlankLine();
                                    srvProperties.addProperty("Host", prop.getValue());
                                }
                            }
                            if ((port = ServerSubPropsHandler.getPortPropertyName(this.getType())) == null || !port.equalsIgnoreCase(propertyName)) continue;
                            if (_lstCon.size() > 1) {
                                String contextValue = con.getName() + ":" + serverName;
                                srvProperties.addBlankLine();
                                srvProperties.addProperty("Port[" + (i + 1) + "]", prop.getValue());
                                srvProperties.addProperty("Port." + con.getType() + "[" + (i + 1) + "]", contextValue);
                                continue;
                            }
                            srvProperties.addBlankLine();
                            srvProperties.addProperty("Port", prop.getValue());
                        }
                    }
                }
            }
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return srvProperties;
    }

    @Override
    public void setSubstitutionProperties(PropertyMap map) throws UnexpectedSubstitutionException {
        try {
            List _lstCon;
            if (this.getTypeDescriptor() != null && (_lstCon = this.getSourceConnections()) != null && _lstCon.size() > 0) {
                for (int i = 0; i < _lstCon.size(); ++i) {
                    String PropName;
                    ConnectionInterface objCon = (ConnectionInterface)_lstCon.get(i);
                    String serverHost = null;
                    String port = null;
                    if (_lstCon.size() == 1) {
                        serverHost = map.getProperty("Host");
                        port = map.getProperty("Port");
                    } else {
                        serverHost = map.getProperty("Host", i + 1);
                        port = map.getProperty("Port", i + 1);
                    }
                    if (serverHost != null) {
                        PropName = ServerSubPropsHandler.getHostServerPropertyName(this.getType());
                        objCon.setProperty(objCon, serverHost, PropName);
                    }
                    if (port == null) continue;
                    PropName = ServerSubPropsHandler.getPathPropertyName(this.getType());
                    objCon.setProperty(objCon, port, PropName);
                }
            }
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            throw new UnexpectedSubstitutionException((Throwable)e);
        }
        catch (ServiceException e) {
            e.printStackTrace();
            throw new UnexpectedSubstitutionException((Throwable)((Object)e));
        }
        catch (RemoteException e) {
            e.printStackTrace();
            throw new UnexpectedSubstitutionException((Throwable)e);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

