/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.metadata;

import com.sas.codepolicy.SASScope;
import com.sas.metadata.remote.AbstractTransformation;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CredentialResolver;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.DatabaseSchema;
import com.sas.metadata.remote.DeployedComponent;
import com.sas.metadata.remote.DeployedDataPackage;
import com.sas.metadata.remote.Directory;
import com.sas.metadata.remote.File;
import com.sas.metadata.remote.LogicalServer;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdLibGenInterface;
import com.sas.metadata.remote.MdModelUtil;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.metadata.remote.PrimaryType;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.PropertySet;
import com.sas.metadata.remote.RelationalSchema;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SASLibrary;
import com.sas.metadata.remote.ServerContext;
import com.sas.metadata.remote.Transformation;
import com.sas.metadata.remote.impl.RelationalSchemaImpl;
import com.sas.metadata.remote.impl.SASLibraryImpl;
import com.sas.metadata.remote.impl.SASLibraryImpl_Stub;
import com.sas.services.ServiceException;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.VersionIncompatibleException;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.FolderUtil;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.OMRRelationalSchema;
import com.sas.services.information.metadata.RB;
import com.sas.services.information.metadata.SASLibraryInterface;
import com.sas.services.user.UserContextInterface;
import com.sas.services.util.Names;
import com.sas.services.util.UpgradeInterface;
import com.sas.storage.editableproperties.LocalizableProperties;
import com.sas.storage.editableproperties.PropertyList;
import com.sas.storage.editableproperties.PropertyMap;
import com.sas.storage.editableproperties.SubstitutionProperties;
import com.sas.storage.editableproperties.UnexpectedSubstitutionException;
import com.sas.util.UsageVersion;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.Level;

@SASScope
public class OMRSASLibrary
extends OMRRelationalSchema
implements SASLibraryInterface,
LocalizableProperties,
SubstitutionProperties,
UpgradeInterface {
    private static final long serialVersionUID = -5425249318326300231L;
    private static final String PROPERTYSET_PREASSIGNEDLIBRARYSET = "PreAssignedLibrarySet";
    private static final String PROPERTY_PREASSIGNMENTTYPE = "PreAssignmentType";
    public static final UsageVersion OLDEST_VERSION = new UsageVersion(0, 0);
    public static final UsageVersion CURRENT_VERSION = new UsageVersion(1, 0);
    public static final String PREASSIGNMENTOPTION_NATIVE_VALUE = "Native";
    public static final String PREASSIGNMENTOPTION_MLE_VALUE = "MLE";
    public static final String PREASSIGNMENTOPTION_EXTERNAL_VALUE = "External";
    public static final String DATAPROVIDERLIBRARY_NAME = "Data Provider Library";
    public static final String DATAPROVIDERLIBRARY_ROLE = "DataProviderLibrary";

    protected OMRSASLibrary(Class c) throws RemoteException {
        super(c);
    }

    public OMRSASLibrary() throws RemoteException {
        this(OMRSASLibrary.class);
    }

    protected OMRSASLibrary(SASLibrary o, Class c) throws RemoteException {
        super((RelationalSchema)o, c);
    }

    public OMRSASLibrary(SASLibrary o) throws RemoteException {
        this(o, OMRSASLibrary.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    protected OMRSASLibrary(SASLibraryImpl o, Class c) throws RemoteException {
        super((RelationalSchemaImpl)o, c);
    }

    public OMRSASLibrary(SASLibraryImpl o) throws RemoteException {
        this(o, OMRSASLibrary.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    protected OMRSASLibrary(SASLibraryImpl_Stub o, Class c) throws RemoteException {
        super((RelationalSchema)o, c);
    }

    public OMRSASLibrary(SASLibraryImpl_Stub o) throws RemoteException {
        this(o, OMRSASLibrary.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRSASLibrary(RepositoryInterface repos, String name, FolderInterface parent) throws RemoteException {
        block5: {
            super(OMRSASLibrary.class);
            if (repos == null || name == null) {
                throw new IllegalArgumentException();
            }
            try {
                OMIRepositoryInterface omirepository = (OMIRepositoryInterface)repos;
                SASLibrary sasLibrary = (SASLibrary)omirepository.createMetadata(name, "SASLibrary");
                sasLibrary.setPublicType("Library");
                sasLibrary.setUsageVersion(CURRENT_VERSION.encode());
                this._isCompatible = true;
                this._isReadCompatible = true;
                this._repositoryObject = sasLibrary;
                this._repositoryFlag = 2;
                this.setRepository(repos);
                if (parent == null) break block5;
                try {
                    parent.addItem(this);
                }
                catch (Exception ex) {
                    sasLibrary.delete();
                    throw new RuntimeException(ex.getMessage(), ex);
                }
            }
            catch (ServiceException ex) {
                this.logMessage(Level.WARN, RB.getStringResource("Metadata.accessexcept.msg.txt"), "com.sas.services.information.metadata.OMRSASLibrary", (Throwable)((Object)ex));
            }
        }
    }

    @Override
    public String getType() throws RemoteException {
        PrimaryType pt;
        String ptype;
        if (this._repositoryObject != null && (ptype = (pt = (PrimaryType)this._repositoryObject).getPublicType()) != null && ptype.trim().length() > 0) {
            return pt.getPublicType();
        }
        return "Library";
    }

    @Override
    public boolean isDBMSLibname() throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        SASLibrary library = (SASLibrary)this._repositoryObject;
        return library.getIsDBMSLibname() != 0;
    }

    @Override
    public void setIsDBMSLibname(boolean value) throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        SASLibrary library = (SASLibrary)this._repositoryObject;
        library.setIsDBMSLibname(value ? 1 : 0);
    }

    @Override
    public String getEngine() throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        SASLibrary library = (SASLibrary)this._repositoryObject;
        return library.getEngine();
    }

    @Override
    public void setEngine(String engine) throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        SASLibrary library = (SASLibrary)this._repositoryObject;
        library.setEngine(engine);
    }

    @Override
    public void setDataProviderLibrary(SASLibraryInterface dataProviderLibrary) throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        SASLibrary library = (SASLibrary)this._repositoryObject;
        try {
            Transformation dataProviderTransformation = null;
            AssociationList tgtTrans = library.getTargetTransformations();
            for (AbstractTransformation trans : tgtTrans) {
                if (!(trans instanceof Transformation) || !trans.getTransformRole().equalsIgnoreCase(DATAPROVIDERLIBRARY_ROLE)) continue;
                dataProviderTransformation = (Transformation)trans;
                break;
            }
            if (dataProviderLibrary == null) {
                if (dataProviderTransformation == null) {
                    return;
                }
                dataProviderTransformation.delete();
                return;
            }
            if (dataProviderTransformation == null) {
                OMIRepositoryInterface omirepository = (OMIRepositoryInterface)this.getRepository();
                dataProviderTransformation = (Transformation)omirepository.createMetadata(DATAPROVIDERLIBRARY_NAME, "Transformation");
                dataProviderTransformation.setTransformRole(DATAPROVIDERLIBRARY_ROLE);
                AssociationList trgTrans = library.getTargetTransformations();
                trgTrans.add(dataProviderTransformation);
            }
            AssociationList transSources = dataProviderTransformation.getTransformationSources();
            transSources.clear();
            transSources.add((SASLibrary)dataProviderLibrary.getRepositoryEntity());
        }
        catch (MdException mdex) {
            throw new ServiceException(mdex, mdex.getMessage());
        }
    }

    @Override
    public SASLibraryInterface getDataProviderLibrary() throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        SASLibrary library = (SASLibrary)this._repositoryObject;
        try {
            Transformation dataProviderTransformation = null;
            AssociationList tgtTrans = library.getTargetTransformations();
            for (AbstractTransformation trans : tgtTrans) {
                if (!(trans instanceof Transformation) || !trans.getTransformRole().equalsIgnoreCase(DATAPROVIDERLIBRARY_ROLE)) continue;
                dataProviderTransformation = (Transformation)trans;
                break;
            }
            if (dataProviderTransformation != null) {
                AssociationList transSources = dataProviderTransformation.getTransformationSources();
                for (Root source : transSources) {
                    if (!(source instanceof SASLibrary)) continue;
                    SASLibraryInterface mi = (SASLibraryInterface)this._repository.factoryProcess(source);
                    return mi;
                }
            }
        }
        catch (MdException mdex) {
            throw new ServiceException(mdex, mdex.getMessage());
        }
        return null;
    }

    @Override
    public String getLibref() throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        SASLibrary library = (SASLibrary)this._repositoryObject;
        return library.getLibref();
    }

    @Override
    public void setLibref(String libref) throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        SASLibrary library = (SASLibrary)this._repositoryObject;
        library.setLibref(libref);
    }

    @Override
    public boolean isPreassigned() throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        SASLibrary library = (SASLibrary)this._repositoryObject;
        return library.getIsPreassigned() != 0;
    }

    @Override
    public void setIsPreassigned(boolean flag) throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        SASLibrary library = (SASLibrary)this._repositoryObject;
        library.setIsPreassigned(flag ? 1 : 0);
    }

    @Override
    public List getPhysicalTables() throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        ArrayList<MetadataInterface> result = new ArrayList<MetadataInterface>();
        RelationalSchema rs = (RelationalSchema)this._repositoryObject;
        try {
            AssociationList list = rs.getTables();
            for (DataTable dt : list) {
                if (!(dt instanceof PhysicalTable)) continue;
                MetadataInterface mi = this._repository.factoryProcess(dt);
                result.add(mi);
            }
        }
        catch (MdException mdex) {
            throw new ServiceException(mdex, mdex.getMessage());
        }
        if (result.size() < 1) {
            try {
                SASLibrary temp = (SASLibrary)this._repositoryObject;
                AssociationList usingPkg = temp.getUsingPackages();
                Object obj = null;
                if (usingPkg.size() > 0) {
                    obj = usingPkg.get(0);
                    AssociationList tableList = null;
                    if (obj != null && obj instanceof DatabaseSchema && (tableList = ((DatabaseSchema)obj).getTables()) != null) {
                        for (Object tempTable : tableList) {
                            if (!(tempTable instanceof PhysicalTable)) continue;
                            PhysicalTable pt = (PhysicalTable)tempTable;
                            MetadataInterface mi = this._repository.factoryProcess(pt);
                            result.add(mi);
                        }
                    }
                }
            }
            catch (MdException mdex) {
                throw new ServiceException(mdex, mdex.getMessage());
            }
        }
        return result;
    }

    @Override
    public String generateLibref() throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        return this.generateLibref(null, true, true, false);
    }

    @Override
    public String generateLibref(String prompt, boolean encodePasswords, boolean genFilenameForXMLLibs, boolean ignorePreassigned) throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        SASLibrary iMeta = (SASLibrary)this._repositoryObject;
        try {
            UserContextInterface resolver = this._repository.getUserContext();
            MdLibGenInterface libgen = MdModelUtil.getInstance((CredentialResolver)resolver, (String)prompt, (boolean)encodePasswords, (boolean)genFilenameForXMLLibs, (boolean)ignorePreassigned);
            String result = libgen.genLibname(iMeta);
            return result;
        }
        catch (MdException mdex) {
            throw new ServiceException(mdex, mdex.getMessage());
        }
    }

    @Override
    public Map generateLibrefMap(String prompt, boolean encodePasswords, boolean genFilenameForXMLLibs, boolean ignorePreassigned, String overrideLibname) throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        SASLibrary iMeta = (SASLibrary)this._repositoryObject;
        try {
            UserContextInterface resolver = this._repository.getUserContext();
            MdLibGenInterface libgen = MdModelUtil.getInstance((CredentialResolver)resolver, (String)prompt, (boolean)encodePasswords, (boolean)genFilenameForXMLLibs, (boolean)ignorePreassigned);
            Map result = libgen.genAssignLibrefMap(iMeta, null);
            return result;
        }
        catch (MdException mdex) {
            throw new ServiceException(mdex, mdex.getMessage());
        }
    }

    @Override
    public List getWorkspaceServers() throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        ArrayList<MetadataInterface> result = new ArrayList<MetadataInterface>();
        SASLibrary library = (SASLibrary)this._repositoryObject;
        try {
            AssociationList list = library.getDeployedComponents();
            for (DeployedComponent dc : list) {
                if (dc instanceof LogicalServer && "440196d4-90f0-11d0-9f41-00a024bb830c".equalsIgnoreCase(dc.getClassIdentifier())) {
                    result.add(this._repository.factoryProcess(dc));
                    continue;
                }
                if (!(dc instanceof ServerContext)) continue;
                AssociationList usingList = dc.getUsingComponents();
                for (DeployedComponent usingDc : usingList) {
                    if (!(usingDc instanceof LogicalServer) || !"440196d4-90f0-11d0-9f41-00a024bb830c".equalsIgnoreCase(usingDc.getClassIdentifier())) continue;
                    result.add(this._repository.factoryProcess(usingDc));
                }
            }
        }
        catch (MdException mdex) {
            throw new ServiceException(mdex, mdex.getMessage());
        }
        return result;
    }

    public PropertyList getLocalizableProperties() {
        return this.getDefaultLocalizableProperties();
    }

    public void setLocalizableProperties(PropertyMap map) {
        this.setDefaultLocalizableProperties(map);
    }

    public PropertyList getSubstitutionProperties() throws UnexpectedSubstitutionException {
        PropertyList list = new PropertyList();
        try {
            int pathCount = 0;
            AssociationList packages = ((SASLibrary)this._repositoryObject).getUsingPackages(true);
            if (packages != null && packages.size() > 0) {
                for (int i = 0; i < packages.size(); ++i) {
                    DeployedDataPackage iDDP = (DeployedDataPackage)packages.get(i);
                    if (iDDP instanceof Directory) {
                        ++pathCount;
                        if (i == 0 && packages.size() == 1) {
                            list.addProperty("DirPath", ((Directory)iDDP).getDirectoryName());
                            continue;
                        }
                        list.addProperty("DirPath", i + 1, ((Directory)iDDP).getDirectoryName());
                        continue;
                    }
                    if (!(iDDP instanceof File)) continue;
                    if (i == 0 && packages.size() == 1) {
                        list.addProperty("FilePath", ((File)iDDP).getFileName());
                        continue;
                    }
                    list.addProperty("FilePath", i + 1, ((File)iDDP).getFileName());
                }
                AssociationList servers = ((SASLibrary)this._repositoryObject).getDeployedComponents(true);
                if (servers != null && servers.size() > 0 && pathCount > 0) {
                    PropertyList serverList = new PropertyList();
                    int serverCount = 0;
                    for (Object deployedComponent : servers) {
                        ServerContext appServer;
                        if (!(deployedComponent instanceof ServerContext) || !(appServer = (ServerContext)deployedComponent).getClassIdentifier().equalsIgnoreCase("SAS Application Server")) continue;
                        serverList.addProperty("ApplicationServer", ++serverCount, ((ServerContext)deployedComponent).getName());
                    }
                    list.addBlankLine();
                    list.addComment(RB.getStringResource("OMRSASLibrary.appServerPropertiesWarning1.txt"));
                    list.addComment(RB.getStringResource("OMRSASLibrary.appServerPropertiesWarning2.txt"));
                    list.addComment(RB.getStringResource("OMRSASLibrary.appServerPropertiesWarning3.txt"));
                    for (int i = 0; i < packages.size(); ++i) {
                        DeployedDataPackage iDDP = (DeployedDataPackage)packages.get(i);
                        if (!(iDDP instanceof Directory)) continue;
                        if (i == 0 && packages.size() == 1) {
                            list.addProperty("DirPath", serverList);
                            continue;
                        }
                        list.addProperty("DirPath", i + 1, serverList);
                    }
                }
            }
        }
        catch (MdException e) {
            throw new UnexpectedSubstitutionException((Throwable)e);
        }
        catch (RemoteException e) {
            throw new UnexpectedSubstitutionException((Throwable)e);
        }
        return list;
    }

    public void setSubstitutionProperties(PropertyMap map) throws UnexpectedSubstitutionException {
        try {
            AssociationList packages = ((SASLibrary)this._repositoryObject).getUsingPackages(true);
            for (int i = 0; i < packages.size(); ++i) {
                String path;
                DeployedDataPackage iDDP = (DeployedDataPackage)packages.get(i);
                if (iDDP instanceof Directory) {
                    if (i == 0 && packages.size() == 1 && map.containsProperty("DirPath")) {
                        path = map.getProperty("DirPath");
                        if (path == ((Directory)iDDP).getDirectoryName()) continue;
                        ((Directory)iDDP).setDirectoryName(path);
                        continue;
                    }
                    if (!map.containsIndexedProperty("DirPath", i + 1) || (path = map.getProperty("DirPath", i + 1)) == ((Directory)iDDP).getDirectoryName()) continue;
                    ((Directory)iDDP).setDirectoryName(path);
                    continue;
                }
                if (!(iDDP instanceof File)) continue;
                if (i == 0 && packages.size() == 1 && map.containsProperty("FilePath")) {
                    String filePath = map.getProperty("FilePath");
                    if (filePath == ((File)iDDP).getFileName()) continue;
                    ((File)iDDP).setFileName(filePath);
                    continue;
                }
                if (!map.containsIndexedProperty("FilePath", i + 1) || (path = map.getProperty("FilePath", i + 1)) == ((File)iDDP).getFileName()) continue;
                ((File)iDDP).setFileName(path);
            }
        }
        catch (MdException e) {
            throw new UnexpectedSubstitutionException((Throwable)e);
        }
        catch (RemoteException e) {
            throw new UnexpectedSubstitutionException((Throwable)e);
        }
    }

    @Override
    public void upgradeFromPreviousVersion() throws ServiceException, RemoteException {
        String targetFolderName;
        FolderInterface sharedData;
        FolderInterface targetFolder;
        if (!this.getUsageVersion().isCompatible(new UsageVersion(0, 0), CURRENT_VERSION)) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        SASLibrary jomaObject = (SASLibrary)this._repositoryObject;
        if (!jomaObject.getPublicType().equals("Library")) {
            jomaObject.setPublicType("Library");
        }
        if (jomaObject.getUsageVersion() < CURRENT_VERSION.encode()) {
            jomaObject.setUsageVersion(CURRENT_VERSION.encode());
        }
        if ((targetFolder = this.getParent()) != null && FolderUtil.isDIStudioUngroupedFolder(targetFolder) && !FolderUtil.isInProjectRepository(this, targetFolder)) {
            targetFolder = null;
        }
        if (targetFolder == null && (sharedData = FolderUtil.makeSharedDataFolder(this)) != null && (targetFolder = sharedData.getSubfolder(targetFolderName = Names.mapNameToOMRObjectName(this.getName()))) == null) {
            targetFolder = sharedData.makeSubfolder(targetFolderName);
        }
        this.validateNameAndFolder(targetFolder);
    }

    @Override
    public void setPreAssignmentType(SASLibraryInterface.PreAssignmentType type) throws ServiceException, RemoteException {
        boolean propertyFound = false;
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        SASLibrary library = (SASLibrary)this._repositoryObject;
        try {
            if (!this.isPreassigned()) {
                throw new MdException(RB.getStringResource("Metadata.library.ispreassigned.txt"));
            }
            PropertySet ps = null;
            Property property = this.getPreAssignmentTypeProperty(library);
            if (property == null) {
                ps = this.createPreAssignedLibraryPropertySet(type);
                library.getPropertySets().add((Object)ps);
            } else {
                property.setDefaultValue(type.getValue());
            }
        }
        catch (MdException mdex) {
            throw new ServiceException(mdex, mdex.getMessage());
        }
    }

    @Override
    public SASLibraryInterface.PreAssignmentType getPreAssignmentType() throws ServiceException, RemoteException {
        boolean propertyFound = false;
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
        SASLibrary library = (SASLibrary)this._repositoryObject;
        try {
            Property property = this.getPreAssignmentTypeProperty(library);
            if (property != null) {
                SASLibraryInterface.PreAssignmentType[] types = SASLibraryInterface.PreAssignmentType.values();
                for (int i = 0; i < types.length; ++i) {
                    if (!types[i].getValue().equalsIgnoreCase(property.getDefaultValue())) continue;
                    return types[i];
                }
            }
        }
        catch (Exception ex) {
            throw new ServiceException(ex, ex.getMessage());
        }
        return SASLibraryInterface.PreAssignmentType.NATIVE;
    }

    private Property getPreAssignmentTypeProperty(SASLibrary library) throws ServiceException, RemoteException {
        try {
            AssociationList alPropertySets = library.getPropertySets();
            Iterator iterPropertySets = alPropertySets.iterator();
            PropertySet ps = null;
            AssociationList alProperty = null;
            Iterator iterProperty = null;
            Property property2 = null;
            while (iterPropertySets.hasNext()) {
                ps = (PropertySet)iterPropertySets.next();
                if (!PROPERTYSET_PREASSIGNEDLIBRARYSET.equalsIgnoreCase(ps.getName())) continue;
                alProperty = ps.getSetProperties();
                for (Property property2 : alProperty) {
                    if (!PROPERTY_PREASSIGNMENTTYPE.equalsIgnoreCase(property2.getPropertyName())) continue;
                    return property2;
                }
            }
        }
        catch (MdException mdex) {
            throw new ServiceException(mdex, mdex.getMessage());
        }
        return null;
    }

    private PropertySet createPreAssignedLibraryPropertySet(SASLibraryInterface.PreAssignmentType type) throws ServiceException, RemoteException {
        PropertySet ps = null;
        Property property = null;
        try {
            OMIRepositoryInterface omirepository = (OMIRepositoryInterface)this.getRepository();
            ps = (PropertySet)omirepository.createMetadata(PROPERTYSET_PREASSIGNEDLIBRARYSET, "PropertySet");
            property = (Property)omirepository.createMetadata(PROPERTY_PREASSIGNMENTTYPE, "Property");
            ps.setName(PROPERTYSET_PREASSIGNEDLIBRARYSET);
            property.setPropertyName(PROPERTY_PREASSIGNMENTTYPE);
            property.setDefaultValue(type.getValue());
            property.setSQLType(12);
            ps.getSetProperties().add((Object)property);
        }
        catch (MdException mdex) {
            throw new ServiceException(mdex, mdex.getMessage());
        }
        return ps;
    }
}

