/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.metadata;

import com.sas.codepolicy.SASScope;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.DatabaseCatalog;
import com.sas.metadata.remote.DatabaseSchema;
import com.sas.metadata.remote.DeployedDataPackage;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.RelationalSchema;
import com.sas.metadata.remote.impl.DeployedDataPackageImpl;
import com.sas.metadata.remote.impl.RelationalSchemaImpl;
import com.sas.metadata.remote.impl.RelationalSchemaImpl_Stub;
import com.sas.services.ServiceException;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.VersionIncompatibleException;
import com.sas.services.information.metadata.DataTableInterface;
import com.sas.services.information.metadata.DatabaseCatalogInterface;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.OMRDeployedDataPackage;
import com.sas.services.information.metadata.RB;
import com.sas.services.information.metadata.RelationalSchemaInterface;
import com.sas.util.UsageVersion;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.logging.log4j.Level;

@SASScope
public class OMRRelationalSchema
extends OMRDeployedDataPackage
implements RelationalSchemaInterface {
    private static final long serialVersionUID = -6269609616385533990L;
    public static final UsageVersion OLDEST_VERSION = new UsageVersion(0, 0);
    public static final UsageVersion CURRENT_VERSION = new UsageVersion(1, 0);

    protected OMRRelationalSchema(Class c) throws RemoteException {
        super(c);
    }

    public OMRRelationalSchema() throws RemoteException {
        this(OMRRelationalSchema.class);
    }

    protected OMRRelationalSchema(RelationalSchema o, Class c) throws RemoteException {
        super((DeployedDataPackage)o, c);
    }

    public OMRRelationalSchema(RelationalSchema o) throws RemoteException {
        this(o, OMRRelationalSchema.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    protected OMRRelationalSchema(RelationalSchemaImpl o, Class c) throws RemoteException {
        super((DeployedDataPackageImpl)o, c);
    }

    public OMRRelationalSchema(RelationalSchemaImpl o) throws RemoteException {
        this(o, OMRRelationalSchema.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    protected OMRRelationalSchema(RelationalSchemaImpl_Stub o, Class c) throws RemoteException {
        super((DeployedDataPackage)o, c);
    }

    public OMRRelationalSchema(RelationalSchemaImpl_Stub o) throws RemoteException {
        this(o, OMRRelationalSchema.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRRelationalSchema(RepositoryInterface repos, String name, FolderInterface parent) throws RemoteException {
        block5: {
            super(OMRRelationalSchema.class);
            if (repos == null || name == null) {
                throw new IllegalArgumentException();
            }
            try {
                OMIRepositoryInterface omirepository = (OMIRepositoryInterface)repos;
                RelationalSchema relationalSchema = (RelationalSchema)omirepository.createMetadata(name, "RelationalSchema");
                relationalSchema.setUsageVersion(CURRENT_VERSION.encode());
                this._isCompatible = true;
                this._isReadCompatible = true;
                this._repositoryObject = relationalSchema;
                this._repositoryFlag = 2;
                this.setRepository(repos);
                if (parent == null) break block5;
                try {
                    parent.addItem(this);
                }
                catch (Exception ex) {
                    relationalSchema.delete();
                    throw new RuntimeException(ex.getMessage(), ex);
                }
            }
            catch (ServiceException ex) {
                this.logMessage(Level.WARN, RB.getStringResource("Metadata.accessexcept.msg.txt"), "com.sas.services.information.metadata.OMRRelationalSchema", (Throwable)((Object)ex));
            }
        }
    }

    @Override
    public String getType() throws RemoteException {
        return "RelationalSchema";
    }

    @Override
    public List getTables() throws ServiceException, RemoteException {
        ArrayList<MetadataInterface> result;
        block8: {
            this.checkPulse(true);
            if (!this._isReadCompatible) {
                throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
            }
            result = new ArrayList<MetadataInterface>();
            RelationalSchema rs = (RelationalSchema)this._repositoryObject;
            try {
                AssociationList list = rs.getTables();
                if (list.size() > 0) {
                    Iterator it = list.iterator();
                    while (it.hasNext()) {
                        MetadataInterface mi = this._repository.factoryProcess(it.next());
                        result.add(mi);
                    }
                    break block8;
                }
                AssociationList packages = rs.getUsingPackages();
                if (packages.size() <= 0) break block8;
                try {
                    DatabaseSchema dbs = (DatabaseSchema)packages.get(0);
                    AssociationList tableList = dbs.getTables();
                    Iterator it = tableList.iterator();
                    while (it.hasNext()) {
                        MetadataInterface mi = this._repository.factoryProcess(it.next());
                        result.add(mi);
                    }
                }
                catch (ClassCastException classCastException) {
                }
            }
            catch (MdException mdex) {
                throw new ServiceException(mdex, mdex.getMessage());
            }
        }
        return result;
    }

    @Override
    public void addTable(DataTableInterface table) throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        RelationalSchema rs = (RelationalSchema)this._repositoryObject;
        DataTable dt = (DataTable)table.getRepositoryEntity();
        try {
            AssociationList packages = rs.getUsingPackages();
            if (packages.size() > 0) {
                try {
                    DatabaseSchema dbs = (DatabaseSchema)packages.get(0);
                    AssociationList tableList = dbs.getTables();
                    tableList.add(dt);
                    return;
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
            }
            rs.getTables().add((Object)dt);
        }
        catch (MdException mdex) {
            throw new ServiceException(mdex, mdex.getMessage());
        }
    }

    @Override
    public void removeTable(DataTableInterface table) throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        RelationalSchema rs = (RelationalSchema)this._repositoryObject;
        try {
            DataTable dt = (DataTable)table.getRepositoryEntity();
            rs.getTables().remove((Object)dt);
        }
        catch (MdException mdex) {
            throw new ServiceException(mdex, mdex.getMessage());
        }
    }

    @Override
    public DatabaseCatalogInterface getDatabaseCatalog() throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isReadCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        RelationalSchema rs = (RelationalSchema)this._repositoryObject;
        try {
            DatabaseCatalog dc = rs.getSchemaPackage();
            if (dc == null) {
                return null;
            }
            DatabaseCatalogInterface dci = (DatabaseCatalogInterface)this._repository.factoryProcess(dc);
            return dci;
        }
        catch (MdException mdex) {
            throw new ServiceException(mdex, mdex.getMessage());
        }
    }

    @Override
    public void setDatabaseCatalog(DatabaseCatalogInterface catalog) throws ServiceException, RemoteException {
        this.checkPulse(true);
        if (!this._isCompatible) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        RelationalSchema rs = (RelationalSchema)this._repositoryObject;
        if (catalog == null) {
            rs.setSchemaPackage(null);
        } else {
            DatabaseCatalog dc = (DatabaseCatalog)catalog.getRepositoryEntity();
            rs.setSchemaPackage(dc);
        }
    }
}

