/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.metadata;

import com.sas.codepolicy.SASScope;
import com.sas.metadata.remote.DeployedComponent;
import com.sas.metadata.remote.LogicalServer;
import com.sas.metadata.remote.impl.LogicalServerImpl;
import com.sas.metadata.remote.impl.LogicalServerImpl_Stub;
import com.sas.metadata.remote.impl.ServerComponentImpl;
import com.sas.services.ServiceException;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.LogicalServerInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.OMRServer;
import com.sas.services.information.publicobject.PublicObjectContainerInterface;
import com.sas.services.information.publicobject.PublicObjectInterface;
import com.sas.util.UsageVersion;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

@SASScope
public class OMRLogicalServer
extends OMRServer
implements LogicalServerInterface,
PublicObjectContainerInterface {
    private static final long serialVersionUID = -7771716830215203625L;
    public static final UsageVersion OLDEST_VERSION = new UsageVersion(0, 0);
    public static final UsageVersion CURRENT_VERSION = new UsageVersion(1, 0);

    public OMRLogicalServer() throws RemoteException {
        super(OMRLogicalServer.class);
    }

    public OMRLogicalServer(LogicalServer o) throws RemoteException {
        super((DeployedComponent)o, OMRLogicalServer.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRLogicalServer(LogicalServerImpl o) throws RemoteException {
        super((ServerComponentImpl)o, OMRLogicalServer.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRLogicalServer(LogicalServerImpl_Stub o) throws RemoteException {
        super((DeployedComponent)o, OMRLogicalServer.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public OMRLogicalServer(RepositoryInterface repos, String name, FolderInterface parent) throws RemoteException {
        block5: {
            super(OMRLogicalServer.class);
            if (repos == null || name == null) {
                throw new IllegalArgumentException();
            }
            OMIRepositoryInterface omirepository = (OMIRepositoryInterface)repos;
            try {
                LogicalServer ls = (LogicalServer)omirepository.createMetadata(name, "LogicalServer");
                ls.setUsageVersion(CURRENT_VERSION.encode());
                this._isCompatible = true;
                this._isReadCompatible = true;
                this._repositoryObject = ls;
                this._repositoryFlag = 2;
                this.setRepository(repos);
                if (parent == null) break block5;
                try {
                    parent.addItem(this);
                }
                catch (Exception ex) {
                    ls.delete();
                    throw new RuntimeException(ex.getMessage(), ex);
                }
            }
            catch (ServiceException ex) {
                throw new RuntimeException((Throwable)((Object)ex));
            }
        }
    }

    @Override
    public String getType() throws RemoteException {
        LogicalServer server;
        if (this._repositoryObject != null && (server = (LogicalServer)this._repositoryObject).getPublicType() != null && server.getPublicType().length() > 0) {
            return server.getPublicType();
        }
        return "LogicalServer";
    }

    @Override
    public PublicObjectInterface getChildAt(int index) throws ServiceException, RemoteException {
        return null;
    }

    @Override
    public int getChildCount() throws ServiceException, RemoteException {
        return 0;
    }

    @Override
    public List getChildren() throws ServiceException, RemoteException {
        return this.getServers();
    }

    @Override
    public List getChildren(String type) throws ServiceException, RemoteException {
        List servers = this.getServers();
        ArrayList<MetadataInterface> typedServers = null;
        if (type != null && servers != null) {
            typedServers = new ArrayList<MetadataInterface>();
            for (MetadataInterface server : servers) {
                if (!type.equals(server.getType())) continue;
                typedServers.add(server);
            }
        }
        return typedServers;
    }

    @Override
    public PublicObjectInterface newChild(String type, String name) throws ServiceException, RemoteException {
        return null;
    }
}

